/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.DataInputStream;
import java.io.IOException;
import javax.xml.bind.DatatypeConverter;
import org.openmuc.j60870.ie.InformationElement;

public class IeBinaryStateInformation
extends InformationElement {
    private final int value;

    public IeBinaryStateInformation(int value) {
        this.value = value;
    }

    public IeBinaryStateInformation(byte[] value) {
        if (value == null || value.length != 4) {
            throw new IllegalArgumentException("value needs to be of length 4");
        }
        this.value = value[0] << 24 | (value[1] & 0xFF) << 16 | (value[2] & 0xFF) << 8 | value[3] & 0xFF;
    }

    IeBinaryStateInformation(DataInputStream is) throws IOException {
        this.value = is.readInt();
    }

    @Override
    int encode(byte[] buffer, int i) {
        buffer[i++] = (byte)(this.value >> 24);
        buffer[i++] = (byte)(this.value >> 16);
        buffer[i++] = (byte)(this.value >> 8);
        buffer[i] = (byte)this.value;
        return 4;
    }

    public int getValue() {
        return this.value;
    }

    public byte[] getValueAsByteArray() {
        return new byte[]{(byte)(this.value >> 24), (byte)(this.value >> 16), (byte)(this.value >> 8), (byte)this.value};
    }

    public boolean getBinaryState(int position) {
        if (position < 1 || position > 32) {
            throw new IllegalArgumentException("Position out of bound. Should be between 1 and 32.");
        }
        return (this.value >> position - 1 & 1) == 1;
    }

    @Override
    public String toString() {
        return "BinaryStateInformation (32 bits as hex): " + DatatypeConverter.printHexBinary((byte[])new byte[]{(byte)(this.value >> 24), (byte)(this.value >> 16), (byte)(this.value >> 8), (byte)this.value});
    }
}

