/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.DataInputStream;
import java.io.IOException;
import org.openmuc.j60870.ie.InformationElement;

public class IeCauseOfInitialization
extends InformationElement {
    private final int value;
    private final boolean initAfterParameterChange;

    public IeCauseOfInitialization(int value, boolean initAfterParameterChange) {
        if (value < 0 || value > 127) {
            throw new IllegalArgumentException("Value has to be in the range 0..127");
        }
        this.value = value;
        this.initAfterParameterChange = initAfterParameterChange;
    }

    IeCauseOfInitialization(DataInputStream is) throws IOException {
        int b1 = is.readByte() & 0xFF;
        this.initAfterParameterChange = (b1 & 0x80) == 128;
        this.value = b1 & 0x7F;
    }

    @Override
    int encode(byte[] buffer, int i) {
        buffer[i] = this.initAfterParameterChange ? (byte)(this.value | 0x80) : (byte)this.value;
        return 1;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isInitAfterParameterChange() {
        return this.initAfterParameterChange;
    }

    @Override
    public String toString() {
        return "Cause of initialization: " + this.value + ", init after parameter change: " + this.initAfterParameterChange;
    }
}

