/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.DataInputStream;
import java.io.IOException;
import org.openmuc.j60870.ie.InformationElement;

public class IeFileReadyQualifier
extends InformationElement {
    private final int value;
    private final boolean negativeConfirm;

    public IeFileReadyQualifier(int value, boolean negativeConfirm) {
        this.value = value;
        this.negativeConfirm = negativeConfirm;
    }

    static InformationElement decode(DataInputStream is) throws IOException {
        int b1 = is.readUnsignedByte();
        int value = b1 & 0x7F;
        boolean negativeConfirm = (b1 & 0x80) == 128;
        return new IeFileReadyQualifier(value, negativeConfirm);
    }

    @Override
    int encode(byte[] buffer, int i) {
        buffer[i] = (byte)this.value;
        if (this.negativeConfirm) {
            int n = i;
            buffer[n] = (byte)(buffer[n] | 0x80);
        }
        return 1;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isNegativeConfirm() {
        return this.negativeConfirm;
    }

    @Override
    public String toString() {
        return "File ready qualifier: " + this.value + ", negative confirm: " + this.negativeConfirm;
    }
}

