/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.DataInputStream;
import java.io.IOException;
import org.openmuc.j60870.ie.InformationElement;

public class IeFileSegment
extends InformationElement {
    private final byte[] segment;
    private final int offset;
    private final int length;

    public IeFileSegment(byte[] segment, int offset, int length) {
        this.segment = segment;
        this.offset = offset;
        this.length = length;
    }

    IeFileSegment(DataInputStream is) throws IOException {
        this.length = is.readByte() & 0xFF;
        this.segment = new byte[this.length];
        is.readFully(this.segment);
        this.offset = 0;
    }

    @Override
    int encode(byte[] buffer, int i) {
        buffer[i++] = (byte)this.length;
        System.arraycopy(this.segment, this.offset, buffer, i, this.length);
        return this.length + 1;
    }

    public byte[] getSegment() {
        return this.segment;
    }

    @Override
    public String toString() {
        return "File segment of length: " + this.length;
    }
}

