/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.DataInputStream;
import java.io.IOException;
import org.openmuc.j60870.ie.InformationElement;

public class IeNormalizedValue
extends InformationElement {
    final int value;

    public IeNormalizedValue(int value) {
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Value has to be in the range -32768..32767");
        }
        this.value = value;
    }

    public IeNormalizedValue(double value) {
        this.value = (int)(value * 32768.0);
        if (this.value < Short.MIN_VALUE || this.value > Short.MAX_VALUE) {
            throw new IllegalArgumentException("The value multiplied by 32768 has to be an integer in the range -32768..32767, but it is: " + this.value);
        }
    }

    IeNormalizedValue(DataInputStream is) throws IOException {
        this.value = is.readByte() & 0xFF | is.readByte() << 8;
    }

    @Override
    int encode(byte[] buffer, int i) {
        buffer[i++] = (byte)this.value;
        buffer[i] = (byte)(this.value >> 8);
        return 2;
    }

    public double getNormalizedValue() {
        return (double)this.value / 32768.0;
    }

    public int getUnnormalizedValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return "Normalized value: " + (double)this.value / 32768.0;
    }
}

