/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.DataInputStream;
import java.io.IOException;
import org.openmuc.j60870.ie.InformationElement;

public class IeProtectionOutputCircuitInformation
extends InformationElement {
    private int value;

    public IeProtectionOutputCircuitInformation(boolean generalCommand, boolean commandToL1, boolean commandToL2, boolean commandToL3) {
        this.value = 0;
        if (generalCommand) {
            this.value |= 1;
        }
        if (commandToL1) {
            this.value |= 2;
        }
        if (commandToL2) {
            this.value |= 4;
        }
        if (commandToL3) {
            this.value |= 8;
        }
    }

    IeProtectionOutputCircuitInformation(DataInputStream is) throws IOException {
        this.value = is.readByte() & 0xFF;
    }

    @Override
    int encode(byte[] buffer, int i) {
        buffer[i] = (byte)this.value;
        return 1;
    }

    public boolean isGeneralCommand() {
        return (this.value & 1) == 1;
    }

    public boolean isCommandToL1() {
        return (this.value & 2) == 2;
    }

    public boolean isCommandToL2() {
        return (this.value & 4) == 4;
    }

    public boolean isCommandToL3() {
        return (this.value & 8) == 8;
    }

    @Override
    public String toString() {
        return "Protection output circuit information, general command: " + this.isGeneralCommand() + ", command to L1: " + this.isCommandToL1() + ", command to L2: " + this.isCommandToL2() + ", command to L3: " + this.isCommandToL3();
    }
}

