/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.DataInputStream;
import java.io.IOException;
import org.openmuc.j60870.ie.InformationElement;

public class IeProtectionStartEvent
extends InformationElement {
    private int value;

    public IeProtectionStartEvent(boolean generalStart, boolean startOperationL1, boolean startOperationL2, boolean startOperationL3, boolean startOperationIe, boolean startReverseOperation) {
        this.value = 0;
        if (generalStart) {
            this.value |= 1;
        }
        if (startOperationL1) {
            this.value |= 2;
        }
        if (startOperationL2) {
            this.value |= 4;
        }
        if (startOperationL3) {
            this.value |= 8;
        }
        if (startOperationIe) {
            this.value |= 0x10;
        }
        if (startReverseOperation) {
            this.value |= 0x20;
        }
    }

    IeProtectionStartEvent(DataInputStream is) throws IOException {
        this.value = is.readByte() & 0xFF;
    }

    @Override
    int encode(byte[] buffer, int i) {
        buffer[i] = (byte)this.value;
        return 1;
    }

    public boolean isGeneralStart() {
        return (this.value & 1) == 1;
    }

    public boolean isStartOperationL1() {
        return (this.value & 2) == 2;
    }

    public boolean isStartOperationL2() {
        return (this.value & 4) == 4;
    }

    public boolean isStartOperationL3() {
        return (this.value & 8) == 8;
    }

    public boolean isStartOperationIe() {
        return (this.value & 0x10) == 16;
    }

    public boolean isStartReverseOperation() {
        return (this.value & 0x20) == 32;
    }

    @Override
    public String toString() {
        return "Protection start event, general start of operation: " + this.isGeneralStart() + ", start of operation L1: " + this.isStartOperationL1() + ", start of operation L2: " + this.isStartOperationL2() + ", start of operation L3: " + this.isStartOperationL3() + ", start of operation IE(earth current): " + this.isStartOperationIe() + ", start of operation in reverse direction: " + this.isStartReverseOperation();
    }
}

