/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.DataInputStream;
import java.io.IOException;
import org.openmuc.j60870.ie.InformationElement;

public class IeQualifierOfSetPointCommand
extends InformationElement {
    private final int ql;
    private final boolean select;

    public IeQualifierOfSetPointCommand(int ql, boolean select) {
        this.ql = ql;
        this.select = select;
    }

    IeQualifierOfSetPointCommand(DataInputStream is) throws IOException {
        int b1 = is.readByte() & 0xFF;
        this.ql = b1 & 0x7F;
        this.select = (b1 & 0x80) == 128;
    }

    @Override
    int encode(byte[] buffer, int i) {
        buffer[i] = (byte)this.ql;
        if (this.select) {
            int n = i;
            buffer[n] = (byte)(buffer[n] | 0x80);
        }
        return 1;
    }

    public int getQl() {
        return this.ql;
    }

    public boolean isSelect() {
        return this.select;
    }

    @Override
    public String toString() {
        return "Qualifier of set point command, QL: " + this.ql + ", select: " + this.select;
    }
}

