/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.DataInputStream;
import java.io.IOException;
import org.openmuc.j60870.ie.InformationElement;

public class IeSectionReadyQualifier
extends InformationElement {
    private final int value;
    private final boolean sectionNotReady;

    public IeSectionReadyQualifier(int value, boolean sectionNotReady) {
        this.value = value;
        this.sectionNotReady = sectionNotReady;
    }

    static IeSectionReadyQualifier decode(DataInputStream is) throws IOException {
        int b1 = is.readUnsignedByte();
        int value = b1 & 0x7F;
        boolean sectionNotReady = (b1 & 0x80) == 128;
        return new IeSectionReadyQualifier(value, sectionNotReady);
    }

    @Override
    int encode(byte[] buffer, int i) {
        buffer[i] = (byte)this.value;
        if (this.sectionNotReady) {
            int n = i;
            buffer[n] = (byte)(buffer[n] | 0x80);
        }
        return 1;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isSectionNotReady() {
        return this.sectionNotReady;
    }

    @Override
    public String toString() {
        return "Section ready qualifier: " + this.value + ", section not ready: " + this.sectionNotReady;
    }
}

