/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.DataInputStream;
import java.io.IOException;
import org.openmuc.j60870.ie.InformationElement;

public class IeShortFloat
extends InformationElement {
    private final float value;

    public IeShortFloat(float value) {
        this.value = value;
    }

    IeShortFloat(DataInputStream is) throws IOException {
        this.value = Float.intBitsToFloat(is.readByte() & 0xFF | (is.readByte() & 0xFF) << 8 | (is.readByte() & 0xFF) << 16 | (is.readByte() & 0xFF) << 24);
    }

    @Override
    int encode(byte[] buffer, int i) {
        int tempVal = Float.floatToIntBits(this.value);
        buffer[i++] = (byte)tempVal;
        buffer[i++] = (byte)(tempVal >> 8);
        buffer[i++] = (byte)(tempVal >> 16);
        buffer[i] = (byte)(tempVal >> 24);
        return 4;
    }

    public float getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return "Short float value: " + this.value;
    }
}

