/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.DataInputStream;
import java.io.IOException;
import org.openmuc.j60870.ie.InformationElement;

public class IeSingleProtectionEvent
extends InformationElement {
    private int value;

    public IeSingleProtectionEvent(EventState eventState, boolean elapsedTimeInvalid, boolean blocked, boolean substituted, boolean notTopical, boolean eventInvalid) {
        this.value = 0;
        switch (eventState) {
            case OFF: {
                this.value |= 1;
                break;
            }
            case ON: {
                this.value |= 2;
                break;
            }
        }
        if (elapsedTimeInvalid) {
            this.value |= 8;
        }
        if (blocked) {
            this.value |= 0x10;
        }
        if (substituted) {
            this.value |= 0x20;
        }
        if (notTopical) {
            this.value |= 0x40;
        }
        if (eventInvalid) {
            this.value |= 0x80;
        }
    }

    IeSingleProtectionEvent(DataInputStream is) throws IOException {
        this.value = is.readByte() & 0xFF;
    }

    @Override
    int encode(byte[] buffer, int i) {
        buffer[i] = (byte)this.value;
        return 1;
    }

    public EventState getEventState() {
        switch (this.value & 3) {
            case 1: {
                return EventState.OFF;
            }
            case 2: {
                return EventState.ON;
            }
        }
        return EventState.INDETERMINATE;
    }

    public boolean isElapsedTimeInvalid() {
        return (this.value & 8) == 8;
    }

    public boolean isBlocked() {
        return (this.value & 0x10) == 16;
    }

    public boolean isSubstituted() {
        return (this.value & 0x20) == 32;
    }

    public boolean isNotTopical() {
        return (this.value & 0x40) == 64;
    }

    public boolean isEventInvalid() {
        return (this.value & 0x80) == 128;
    }

    @Override
    public String toString() {
        return "Single protection event, elapsed time invalid: " + this.isElapsedTimeInvalid() + ", blocked: " + this.isBlocked() + ", substituted: " + this.isSubstituted() + ", not topical: " + this.isNotTopical() + ", event invalid: " + this.isEventInvalid();
    }

    public static enum EventState {
        INDETERMINATE,
        OFF,
        ON;

    }
}

