/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.DataInputStream;
import java.io.IOException;
import org.openmuc.j60870.ie.InformationElement;

public class IeStatusAndStatusChanges
extends InformationElement {
    private final int value;

    public IeStatusAndStatusChanges(int value) {
        this.value = value;
    }

    IeStatusAndStatusChanges(DataInputStream is) throws IOException {
        this.value = is.readInt();
    }

    @Override
    int encode(byte[] buffer, int i) {
        buffer[i++] = (byte)(this.value >> 24);
        buffer[i++] = (byte)(this.value >> 16);
        buffer[i++] = (byte)(this.value >> 8);
        buffer[i] = (byte)this.value;
        return 4;
    }

    public int getValue() {
        return this.value;
    }

    public boolean getStatus(int position) {
        if (position < 1 || position > 16) {
            throw new IllegalArgumentException("Position out of bound. Should be between 1 and 16.");
        }
        return (this.value >> position - 17 & 1) == 1;
    }

    public boolean hasStatusChanged(int position) {
        if (position < 1 || position > 16) {
            throw new IllegalArgumentException("Position out of bound. Should be between 1 and 16.");
        }
        return (this.value >> position - 1 & 1) == 1;
    }

    @Override
    public String toString() {
        StringBuilder sb1 = new StringBuilder();
        sb1.append(Integer.toHexString(this.value >>> 16));
        while (sb1.length() < 4) {
            sb1.insert(0, '0');
        }
        StringBuilder sb2 = new StringBuilder();
        sb2.append(Integer.toHexString(this.value & 0xFFFF));
        while (sb2.length() < 4) {
            sb2.insert(0, '0');
        }
        return "Status and status changes (first bit = LSB), states: " + sb1.toString() + ", state changes: " + sb2.toString();
    }
}

