/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openmuc.j60870.ie.InformationElement;

public class IeStatusOfFile
extends InformationElement {
    private final int status;
    private final Set<Flag> flags;

    public IeStatusOfFile(int status, Flag ... flags) {
        this(status, new HashSet<Flag>(Arrays.asList(flags)));
    }

    public IeStatusOfFile(int status, Set<Flag> flags) {
        this.status = status;
        this.flags = flags;
    }

    static IeStatusOfFile decode(DataInputStream is) throws IOException {
        int b1 = is.readUnsignedByte();
        int status = b1 & 0x1F;
        Set flags = Flag.flagsFor(b1);
        return new IeStatusOfFile(status, flags);
    }

    @Override
    int encode(byte[] buffer, int i) {
        buffer[i] = (byte)this.status;
        for (Flag f : this.flags) {
            int n = i;
            buffer[n] = (byte)(buffer[n] | (byte)f.mask);
        }
        return 1;
    }

    public int getStatus() {
        return this.status;
    }

    public Set<Flag> getFlags() {
        return this.flags;
    }

    @Override
    public String toString() {
        return "Status of file: " + this.status + ", last file of directory: " + this.flags.contains((Object)Flag.LAST_FILE_OF_DIRECTORY) + ", name defines directory: " + this.flags.contains((Object)Flag.NAME_DEFINES_DIRECTORY) + ", transfer is active: " + this.flags.contains((Object)Flag.TRANSFER_IS_ACTIVE);
    }

    public static enum Flag {
        LAST_FILE_OF_DIRECTORY(32),
        NAME_DEFINES_DIRECTORY(64),
        TRANSFER_IS_ACTIVE(128);

        private int mask;

        private Flag(int mask) {
            this.mask = mask;
        }

        private static Set<Flag> flagsFor(int b) {
            HashSet<Flag> res = new HashSet<Flag>();
            for (Flag v : Flag.values()) {
                if ((v.mask & b) != v.mask) continue;
                res.add(v);
            }
            return res;
        }
    }
}

