/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.DataInputStream;
import java.io.IOException;
import org.openmuc.j60870.ie.InformationElement;

public class IeTestSequenceCounter
extends InformationElement {
    private static final int LOWER_BOUND = 0;
    private static final int UPPER_BOUND = 65535;
    private final int value;

    public IeTestSequenceCounter(int value) {
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException("Value has to be in the range 0..65535");
        }
        this.value = value;
    }

    static IeTestSequenceCounter decode(DataInputStream is) throws IOException {
        return new IeTestSequenceCounter(is.readUnsignedByte() | is.readUnsignedByte() << 8);
    }

    @Override
    int encode(byte[] buffer, int i) {
        buffer[i++] = (byte)this.value;
        buffer[i] = (byte)(this.value >> 8);
        return 2;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return "Test sequence counter: " + this.getValue();
    }
}

