/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Calendar;
import org.openmuc.j60870.ie.InformationElement;

public class IeTime16
extends InformationElement {
    private final byte[] value = new byte[2];

    public IeTime16(long timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp);
        int ms = calendar.get(14) + 1000 * calendar.get(13);
        this.value[0] = (byte)ms;
        this.value[1] = (byte)(ms >> 8);
    }

    public IeTime16(int timeInMs) {
        int ms = timeInMs % 60000;
        this.value[0] = (byte)ms;
        this.value[1] = (byte)(ms >> 8);
    }

    IeTime16(DataInputStream is) throws IOException {
        is.readFully(this.value);
    }

    @Override
    int encode(byte[] buffer, int i) {
        System.arraycopy(this.value, 0, buffer, i, 2);
        return 2;
    }

    public int getTimeInMs() {
        return (this.value[0] & 0xFF) + ((this.value[1] & 0xFF) << 8);
    }

    @Override
    public String toString() {
        return "Time16, time in ms: " + this.getTimeInMs();
    }
}

