/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Calendar;
import org.openmuc.j60870.ie.InformationElement;

public class IeTime24
extends InformationElement {
    private final byte[] value = new byte[3];

    public IeTime24(long timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp);
        int ms = calendar.get(14) + 1000 * calendar.get(13);
        this.value[0] = (byte)ms;
        this.value[1] = (byte)(ms >> 8);
        this.value[2] = (byte)calendar.get(12);
    }

    public IeTime24(int timeInMs) {
        int ms = timeInMs % 60000;
        this.value[0] = (byte)ms;
        this.value[1] = (byte)(ms >> 8);
        this.value[2] = (byte)(timeInMs / 60000);
    }

    IeTime24(DataInputStream is) throws IOException {
        is.readFully(this.value);
    }

    @Override
    int encode(byte[] buffer, int i) {
        System.arraycopy(this.value, 0, buffer, i, 3);
        return 3;
    }

    public int getTimeInMs() {
        return (this.value[0] & 0xFF) + ((this.value[1] & 0xFF) << 8) + this.value[2] * 60000;
    }

    @Override
    public String toString() {
        return "Time24, time in ms: " + this.getTimeInMs();
    }
}

