/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import org.openmuc.j60870.ie.InformationElement;

public class IeTime56
extends InformationElement {
    private static final int LENGTH = 7;
    private final byte[] value;
    private final TimeZone timeZone;

    public IeTime56(long timestamp, TimeZone timeZone, boolean invalid) {
        Calendar calendar = Calendar.getInstance(timeZone);
        this.timeZone = timeZone;
        calendar.setTimeInMillis(timestamp);
        short ms = (short)(calendar.get(14) + 1000 * calendar.get(13));
        byte day = (byte)(calendar.get(5) + ((calendar.get(7) + 5) % 7 + 1 << 5));
        this.value = ByteBuffer.allocate(7).order(ByteOrder.LITTLE_ENDIAN).putShort(ms).put(IeTime56.minuteFor(invalid, calendar)).put(IeTime56.hourOfTheDay(calendar)).put(day).put((byte)(calendar.get(2) + 1)).put((byte)(calendar.get(1) % 100)).array();
    }

    private static byte hourOfTheDay(Calendar calendar) {
        int hod = calendar.get(11);
        if (calendar.getTimeZone().inDaylightTime(calendar.getTime())) {
            hod |= 0x80;
        }
        return (byte)hod;
    }

    private static byte minuteFor(boolean invalid, Calendar calendar) {
        int min = calendar.get(12);
        if (invalid) {
            min |= 0x80;
        }
        return (byte)min;
    }

    public IeTime56(long timestamp) {
        this(timestamp, TimeZone.getDefault(), false);
    }

    public IeTime56(byte[] value) {
        this.timeZone = TimeZone.getDefault();
        this.value = Arrays.copyOf(value, 7);
    }

    static IeTime56 decode(DataInputStream is) throws IOException {
        byte[] value = new byte[7];
        is.readFully(value);
        return new IeTime56(value);
    }

    @Override
    int encode(byte[] buffer, int i) {
        System.arraycopy(this.value, 0, buffer, i, 7);
        return 7;
    }

    public long getTimestamp(int startOfCentury, TimeZone timeZone) {
        int century = startOfCentury / 100 * 100;
        if (this.value[6] < startOfCentury % 100) {
            century += 100;
        }
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.set(16, this.isSummerTime() ? 3600000 : 0);
        calendar.set(this.getYear() + century, this.getMonth() - 1, this.getDayOfMonth(), this.getHour(), this.getMinute(), this.getSecond());
        calendar.set(14, this.getMillisecond());
        return calendar.getTimeInMillis();
    }

    public long getTimestamp(int startOfCentury) {
        return this.getTimestamp(startOfCentury, this.timeZone);
    }

    public long getTimestamp() {
        return this.getTimestamp(1970, this.timeZone);
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public int getMillisecond() {
        return this.getV0V1Short() % 1000;
    }

    public int getSecond() {
        return this.getV0V1Short() / 1000;
    }

    private int getV0V1Short() {
        return (this.value[0] & 0xFF) + ((this.value[1] & 0xFF) << 8);
    }

    public int getMinute() {
        return this.value[2] & 0x3F;
    }

    public int getHour() {
        return this.value[3] & 0x1F;
    }

    public int getDayOfWeek() {
        return (this.value[4] & 0xE0) >> 5;
    }

    public int getDayOfMonth() {
        return this.value[4] & 0x1F;
    }

    public int getMonth() {
        return this.value[5] & 0xF;
    }

    public int getYear() {
        return this.value[6] & 0x7F;
    }

    public boolean isSummerTime() {
        return this.flagIsSet(3);
    }

    public boolean isInvalid() {
        return this.flagIsSet(2);
    }

    private boolean flagIsSet(int arrIndex) {
        return (this.value[arrIndex] & 0x80) == 128;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("Time56: ");
        builder.append(String.format("%02d", this.getDayOfMonth()));
        builder.append("-");
        builder.append(String.format("%02d", this.getMonth()));
        builder.append("-");
        builder.append(String.format("%02d", this.getYear()));
        builder.append(" ");
        builder.append(String.format("%02d", this.getHour()));
        builder.append(":");
        builder.append(String.format("%02d", this.getMinute()));
        builder.append(":");
        builder.append(String.format("%02d", this.getSecond()));
        builder.append(":");
        builder.append(String.format("%03d", this.getMillisecond()));
        if (this.isSummerTime()) {
            builder.append(" DST");
        }
        if (this.isInvalid()) {
            builder.append(", invalid");
        }
        return builder.toString();
    }
}

