/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.DataInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import org.openmuc.j60870.ie.InformationElement;

public class IeValueWithTransientState
extends InformationElement {
    private final int value;
    private final boolean transientState;

    public IeValueWithTransientState(int value, boolean transientState) {
        if (value < -64 || value > 63) {
            throw new IllegalArgumentException("Value has to be in the range -64..63");
        }
        this.value = value;
        this.transientState = transientState;
    }

    IeValueWithTransientState(DataInputStream is) throws IOException {
        int b1 = is.readByte() & 0xFF;
        this.transientState = (b1 & 0x80) == 128;
        this.value = (b1 & 0x40) == 64 ? b1 | 0xFFFFFF80 : b1 & 0x3F;
    }

    @Override
    int encode(byte[] buffer, int i) {
        buffer[i] = this.transientState ? (byte)(this.value | 0x80) : (byte)(this.value & 0x7F);
        return 1;
    }

    public int getValue() {
        return this.value;
    }

    public boolean getTransientState() {
        return this.transientState;
    }

    @Override
    public String toString() {
        return MessageFormat.format("Value with transient state, value: {0}, transient state: {1}.", this.getValue(), this.getTransientState());
    }
}

