/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.ie;

import java.io.DataInputStream;
import java.io.IOException;
import org.openmuc.j60870.ASduType;
import org.openmuc.j60870.ie.IeAckFileOrSectionQualifier;
import org.openmuc.j60870.ie.IeBinaryCounterReading;
import org.openmuc.j60870.ie.IeBinaryStateInformation;
import org.openmuc.j60870.ie.IeCauseOfInitialization;
import org.openmuc.j60870.ie.IeChecksum;
import org.openmuc.j60870.ie.IeDoubleCommand;
import org.openmuc.j60870.ie.IeDoublePointWithQuality;
import org.openmuc.j60870.ie.IeFileReadyQualifier;
import org.openmuc.j60870.ie.IeFileSegment;
import org.openmuc.j60870.ie.IeFixedTestBitPattern;
import org.openmuc.j60870.ie.IeLastSectionOrSegmentQualifier;
import org.openmuc.j60870.ie.IeLengthOfFileOrSection;
import org.openmuc.j60870.ie.IeNameOfFile;
import org.openmuc.j60870.ie.IeNameOfSection;
import org.openmuc.j60870.ie.IeNormalizedValue;
import org.openmuc.j60870.ie.IeProtectionOutputCircuitInformation;
import org.openmuc.j60870.ie.IeProtectionQuality;
import org.openmuc.j60870.ie.IeProtectionStartEvent;
import org.openmuc.j60870.ie.IeQualifierOfCounterInterrogation;
import org.openmuc.j60870.ie.IeQualifierOfInterrogation;
import org.openmuc.j60870.ie.IeQualifierOfParameterActivation;
import org.openmuc.j60870.ie.IeQualifierOfParameterOfMeasuredValues;
import org.openmuc.j60870.ie.IeQualifierOfResetProcessCommand;
import org.openmuc.j60870.ie.IeQualifierOfSetPointCommand;
import org.openmuc.j60870.ie.IeQuality;
import org.openmuc.j60870.ie.IeRegulatingStepCommand;
import org.openmuc.j60870.ie.IeScaledValue;
import org.openmuc.j60870.ie.IeSectionReadyQualifier;
import org.openmuc.j60870.ie.IeSelectAndCallQualifier;
import org.openmuc.j60870.ie.IeShortFloat;
import org.openmuc.j60870.ie.IeSingleCommand;
import org.openmuc.j60870.ie.IeSinglePointWithQuality;
import org.openmuc.j60870.ie.IeSingleProtectionEvent;
import org.openmuc.j60870.ie.IeStatusAndStatusChanges;
import org.openmuc.j60870.ie.IeStatusOfFile;
import org.openmuc.j60870.ie.IeTestSequenceCounter;
import org.openmuc.j60870.ie.IeTime16;
import org.openmuc.j60870.ie.IeTime24;
import org.openmuc.j60870.ie.IeTime56;
import org.openmuc.j60870.ie.IeValueWithTransientState;
import org.openmuc.j60870.ie.InformationElement;
import org.openmuc.j60870.internal.ExtendedDataInputStream;

public class InformationObject {
    private final int informationObjectAddress;
    private final InformationElement[][] informationElements;

    public InformationObject(int informationObjectAddress, InformationElement[][] informationElements) {
        this.informationObjectAddress = informationObjectAddress;
        this.informationElements = informationElements;
    }

    public InformationObject(int informationObjectAddress, InformationElement ... informationElement) {
        this(informationObjectAddress, new InformationElement[][]{informationElement});
    }

    public static InformationObject decode(ExtendedDataInputStream is, ASduType aSduType, int numberOfSequenceElements, int ioaFieldLength) throws IOException {
        InformationElement[][] informationElements;
        int informationObjectAddress = InformationObject.readInformationObjectAddress(is, ioaFieldLength);
        switch (aSduType) {
            case M_SP_NA_1: {
                informationElements = new InformationElement[numberOfSequenceElements][1];
                for (int i = 0; i < numberOfSequenceElements; ++i) {
                    informationElements[i][0] = new IeSinglePointWithQuality(is);
                }
                break;
            }
            case M_SP_TA_1: {
                informationElements = new InformationElement[][]{{new IeSinglePointWithQuality(is), new IeTime24(is)}};
                break;
            }
            case M_DP_NA_1: {
                informationElements = new InformationElement[numberOfSequenceElements][1];
                for (int i = 0; i < numberOfSequenceElements; ++i) {
                    informationElements[i][0] = new IeDoublePointWithQuality(is);
                }
                break;
            }
            case M_DP_TA_1: {
                informationElements = new InformationElement[][]{{new IeDoublePointWithQuality(is), new IeTime24(is)}};
                break;
            }
            case M_ST_NA_1: {
                informationElements = new InformationElement[numberOfSequenceElements][2];
                for (int i = 0; i < numberOfSequenceElements; ++i) {
                    informationElements[i][0] = new IeValueWithTransientState(is);
                    informationElements[i][1] = new IeQuality(is);
                }
                break;
            }
            case M_ST_TA_1: {
                informationElements = new InformationElement[][]{{new IeValueWithTransientState(is), new IeQuality(is), new IeTime24(is)}};
                break;
            }
            case M_BO_NA_1: {
                informationElements = new InformationElement[numberOfSequenceElements][2];
                for (int i = 0; i < numberOfSequenceElements; ++i) {
                    informationElements[i][0] = new IeBinaryStateInformation(is);
                    informationElements[i][1] = new IeQuality(is);
                }
                break;
            }
            case M_BO_TA_1: {
                informationElements = new InformationElement[][]{{new IeBinaryStateInformation(is), new IeQuality(is), new IeTime24(is)}};
                break;
            }
            case M_ME_NA_1: {
                for (InformationElement[] informationElementCombination : informationElements = new InformationElement[numberOfSequenceElements][2]) {
                    informationElementCombination[0] = new IeNormalizedValue(is);
                    informationElementCombination[1] = new IeQuality(is);
                }
                break;
            }
            case M_ME_TA_1: {
                informationElements = new InformationElement[][]{{new IeNormalizedValue(is), new IeQuality(is), new IeTime24(is)}};
                break;
            }
            case M_ME_NB_1: {
                for (InformationElement[] informationElementCombination : informationElements = new InformationElement[numberOfSequenceElements][2]) {
                    informationElementCombination[0] = new IeScaledValue(is);
                    informationElementCombination[1] = new IeQuality(is);
                }
                break;
            }
            case M_ME_TB_1: {
                informationElements = new InformationElement[][]{{new IeScaledValue(is), new IeQuality(is), new IeTime24(is)}};
                break;
            }
            case M_ME_NC_1: {
                for (InformationElement[] informationElementCombination : informationElements = new InformationElement[numberOfSequenceElements][2]) {
                    informationElementCombination[0] = new IeShortFloat(is);
                    informationElementCombination[1] = new IeQuality(is);
                }
                break;
            }
            case M_ME_TC_1: {
                informationElements = new InformationElement[][]{{new IeShortFloat(is), new IeQuality(is), new IeTime24(is)}};
                break;
            }
            case M_IT_NA_1: {
                for (InformationElement[] informationElementCombination : informationElements = new InformationElement[numberOfSequenceElements][1]) {
                    informationElementCombination[0] = IeBinaryCounterReading.decode(is);
                }
                break;
            }
            case M_IT_TA_1: {
                informationElements = new InformationElement[][]{{IeBinaryCounterReading.decode(is), new IeTime24(is)}};
                break;
            }
            case M_EP_TA_1: {
                informationElements = new InformationElement[][]{{new IeSingleProtectionEvent(is), new IeTime16(is), new IeTime24(is)}};
                break;
            }
            case M_EP_TB_1: {
                informationElements = new InformationElement[][]{{new IeProtectionStartEvent(is), new IeProtectionQuality(is), new IeTime16(is), new IeTime24(is)}};
                break;
            }
            case M_EP_TC_1: {
                informationElements = new InformationElement[][]{{new IeProtectionOutputCircuitInformation(is), new IeProtectionQuality(is), new IeTime16(is), new IeTime24(is)}};
                break;
            }
            case M_PS_NA_1: {
                for (InformationElement[] informationElementCombination : informationElements = new InformationElement[numberOfSequenceElements][2]) {
                    informationElementCombination[0] = new IeStatusAndStatusChanges(is);
                    informationElementCombination[1] = new IeQuality(is);
                }
                break;
            }
            case M_ME_ND_1: {
                for (InformationElement[] informationElementCombination : informationElements = new InformationElement[numberOfSequenceElements][1]) {
                    informationElementCombination[0] = new IeNormalizedValue(is);
                }
                break;
            }
            case M_SP_TB_1: {
                informationElements = new InformationElement[][]{{new IeSinglePointWithQuality(is), IeTime56.decode(is)}};
                break;
            }
            case M_DP_TB_1: {
                informationElements = new InformationElement[][]{{new IeDoublePointWithQuality(is), IeTime56.decode(is)}};
                break;
            }
            case M_ST_TB_1: {
                informationElements = new InformationElement[][]{{new IeValueWithTransientState(is), new IeQuality(is), IeTime56.decode(is)}};
                break;
            }
            case M_BO_TB_1: {
                informationElements = new InformationElement[][]{{new IeBinaryStateInformation(is), new IeQuality(is), IeTime56.decode(is)}};
                break;
            }
            case M_ME_TD_1: {
                informationElements = new InformationElement[][]{{new IeNormalizedValue(is), new IeQuality(is), IeTime56.decode(is)}};
                break;
            }
            case M_ME_TE_1: {
                informationElements = new InformationElement[][]{{new IeScaledValue(is), new IeQuality(is), IeTime56.decode(is)}};
                break;
            }
            case M_ME_TF_1: {
                informationElements = new InformationElement[][]{{new IeShortFloat(is), new IeQuality(is), IeTime56.decode(is)}};
                break;
            }
            case M_IT_TB_1: {
                informationElements = new InformationElement[][]{{IeBinaryCounterReading.decode(is), IeTime56.decode(is)}};
                break;
            }
            case M_EP_TD_1: {
                informationElements = new InformationElement[][]{{new IeSingleProtectionEvent(is), new IeTime16(is), IeTime56.decode(is)}};
                break;
            }
            case M_EP_TE_1: {
                informationElements = new InformationElement[][]{{new IeProtectionStartEvent(is), new IeProtectionQuality(is), new IeTime16(is), IeTime56.decode(is)}};
                break;
            }
            case M_EP_TF_1: {
                informationElements = new InformationElement[][]{{new IeProtectionOutputCircuitInformation(is), new IeProtectionQuality(is), new IeTime16(is), IeTime56.decode(is)}};
                break;
            }
            case C_SC_NA_1: {
                informationElements = new InformationElement[][]{{new IeSingleCommand(is)}};
                break;
            }
            case C_DC_NA_1: {
                informationElements = new InformationElement[][]{{new IeDoubleCommand(is)}};
                break;
            }
            case C_RC_NA_1: {
                informationElements = new InformationElement[][]{{new IeRegulatingStepCommand(is)}};
                break;
            }
            case C_SE_NA_1: {
                informationElements = new InformationElement[][]{{new IeNormalizedValue(is), new IeQualifierOfSetPointCommand(is)}};
                break;
            }
            case C_SE_NB_1: {
                informationElements = new InformationElement[][]{{new IeScaledValue(is), new IeQualifierOfSetPointCommand(is)}};
                break;
            }
            case C_SE_NC_1: {
                informationElements = new InformationElement[][]{{new IeShortFloat(is), new IeQualifierOfSetPointCommand(is)}};
                break;
            }
            case C_BO_NA_1: {
                informationElements = new InformationElement[][]{{new IeBinaryStateInformation(is)}};
                break;
            }
            case C_SC_TA_1: {
                informationElements = new InformationElement[][]{{new IeSingleCommand(is), IeTime56.decode(is)}};
                break;
            }
            case C_DC_TA_1: {
                informationElements = new InformationElement[][]{{new IeDoubleCommand(is), IeTime56.decode(is)}};
                break;
            }
            case C_RC_TA_1: {
                informationElements = new InformationElement[][]{{new IeRegulatingStepCommand(is), IeTime56.decode(is)}};
                break;
            }
            case C_SE_TA_1: {
                informationElements = new InformationElement[][]{{new IeNormalizedValue(is), new IeQualifierOfSetPointCommand(is), IeTime56.decode(is)}};
                break;
            }
            case C_SE_TB_1: {
                informationElements = new InformationElement[][]{{new IeScaledValue(is), new IeQualifierOfSetPointCommand(is), IeTime56.decode(is)}};
                break;
            }
            case C_SE_TC_1: {
                informationElements = new InformationElement[][]{{new IeShortFloat(is), new IeQualifierOfSetPointCommand(is), IeTime56.decode(is)}};
                break;
            }
            case C_BO_TA_1: {
                informationElements = new InformationElement[][]{{new IeBinaryStateInformation(is), IeTime56.decode(is)}};
                break;
            }
            case M_EI_NA_1: {
                informationElements = new InformationElement[][]{{new IeCauseOfInitialization(is)}};
                break;
            }
            case C_IC_NA_1: {
                informationElements = new InformationElement[][]{{new IeQualifierOfInterrogation(is)}};
                break;
            }
            case C_CI_NA_1: {
                informationElements = new InformationElement[][]{{new IeQualifierOfCounterInterrogation(is)}};
                break;
            }
            case C_RD_NA_1: {
                informationElements = new InformationElement[0][0];
                break;
            }
            case C_CS_NA_1: {
                informationElements = new InformationElement[][]{{IeTime56.decode(is)}};
                break;
            }
            case C_TS_NA_1: {
                informationElements = new InformationElement[][]{{new IeFixedTestBitPattern(is)}};
                break;
            }
            case C_RP_NA_1: {
                informationElements = new InformationElement[][]{{new IeQualifierOfResetProcessCommand(is)}};
                break;
            }
            case C_CD_NA_1: {
                informationElements = new InformationElement[][]{{new IeTime16(is)}};
                break;
            }
            case C_TS_TA_1: {
                informationElements = new InformationElement[][]{{IeTestSequenceCounter.decode(is), IeTime56.decode(is)}};
                break;
            }
            case P_ME_NA_1: {
                informationElements = new InformationElement[][]{{new IeNormalizedValue(is), new IeQualifierOfParameterOfMeasuredValues(is)}};
                break;
            }
            case P_ME_NB_1: {
                informationElements = new InformationElement[][]{{new IeScaledValue(is), new IeQualifierOfParameterOfMeasuredValues(is)}};
                break;
            }
            case P_ME_NC_1: {
                informationElements = new InformationElement[][]{{new IeShortFloat(is), new IeQualifierOfParameterOfMeasuredValues(is)}};
                break;
            }
            case P_AC_NA_1: {
                informationElements = new InformationElement[][]{{IeQualifierOfParameterActivation.decode(is)}};
                break;
            }
            case F_FR_NA_1: {
                informationElements = new InformationElement[][]{{IeNameOfFile.decode(is), IeLengthOfFileOrSection.decode(is), IeFileReadyQualifier.decode(is)}};
                break;
            }
            case F_SR_NA_1: {
                informationElements = new InformationElement[][]{{IeNameOfFile.decode(is), IeNameOfSection.decode(is), IeLengthOfFileOrSection.decode(is), IeSectionReadyQualifier.decode(is)}};
                break;
            }
            case F_SC_NA_1: {
                informationElements = new InformationElement[][]{{IeNameOfFile.decode(is), IeNameOfSection.decode(is), IeSelectAndCallQualifier.decode(is)}};
                break;
            }
            case F_LS_NA_1: {
                return new InformationObject(informationObjectAddress, IeNameOfFile.decode(is), IeNameOfSection.decode(is), IeLastSectionOrSegmentQualifier.decode(is), IeChecksum.decode(is));
            }
            case F_AF_NA_1: {
                return new InformationObject(informationObjectAddress, IeNameOfFile.decode(is), IeNameOfSection.decode(is), IeAckFileOrSectionQualifier.decode(is));
            }
            case F_SG_NA_1: {
                return new InformationObject(informationObjectAddress, IeNameOfFile.decode(is), IeNameOfSection.decode(is), new IeFileSegment(is));
            }
            case F_DR_TA_1: {
                informationElements = new InformationElement[numberOfSequenceElements][];
                for (int i = 0; i < numberOfSequenceElements; ++i) {
                    informationElements[i] = InformationObject.valuesAsArray(IeNameOfFile.decode(is), IeLengthOfFileOrSection.decode(is), IeStatusOfFile.decode(is), IeTime56.decode(is));
                }
                break;
            }
            case F_SC_NB_1: {
                return new InformationObject(informationObjectAddress, IeNameOfFile.decode(is), IeTime56.decode(is), IeTime56.decode(is));
            }
            default: {
                throw new IOException("Unable to parse Information Object because of unknown Type Identification: " + (Object)((Object)aSduType));
            }
        }
        return new InformationObject(informationObjectAddress, informationElements);
    }

    private static InformationElement[] valuesAsArray(InformationElement ... informationElements) {
        return informationElements;
    }

    private static int readInformationObjectAddress(DataInputStream is, int ioaFieldLength) throws IOException {
        int informationObjectAddress = 0;
        for (int i = 0; i < ioaFieldLength; ++i) {
            informationObjectAddress |= is.readUnsignedByte() << 8 * i;
        }
        return informationObjectAddress;
    }

    public int encode(byte[] buffer, int i, int ioaFieldLength) {
        int origi = i;
        buffer[i++] = (byte)this.informationObjectAddress;
        if (ioaFieldLength > 1) {
            buffer[i++] = (byte)(this.informationObjectAddress >> 8);
            if (ioaFieldLength > 2) {
                buffer[i++] = (byte)(this.informationObjectAddress >> 16);
            }
        }
        InformationElement[][] informationElementArray = this.informationElements;
        int n = informationElementArray.length;
        for (int j = 0; j < n; ++j) {
            InformationElement[] informationElementCombination;
            for (InformationElement informationElement : informationElementCombination = informationElementArray[j]) {
                i += informationElement.encode(buffer, i);
            }
        }
        return i - origi;
    }

    public int getInformationObjectAddress() {
        return this.informationObjectAddress;
    }

    public InformationElement[][] getInformationElements() {
        return this.informationElements;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("IOA: " + this.informationObjectAddress);
        if (this.informationElements.length > 1) {
            int i = 1;
            for (InformationElement[] informationElementSet : this.informationElements) {
                builder.append("\nInformation Element Set " + i + ":");
                for (InformationElement informationElement : informationElementSet) {
                    builder.append("\n");
                    builder.append(informationElement.toString());
                }
                ++i;
            }
        } else {
            InformationElement[][] informationElementArray = this.informationElements;
            int n = informationElementArray.length;
            for (int i = 0; i < n; ++i) {
                InformationElement[] informationElementSet;
                for (InformationElement informationElement : informationElementSet = informationElementArray[i]) {
                    builder.append("\n");
                    builder.append(informationElement.toString());
                }
            }
        }
        return builder.toString();
    }
}

