/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j60870.internal;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ExtendedDataInputStream
extends DataInputStream {
    private static final int INTEGER_BYTES = 4;
    private static final int SHORT_BYTES = 2;

    public ExtendedDataInputStream(InputStream in) {
        super(in);
    }

    public int readLittleEndianInt() throws IOException {
        return (int)this.readNLittleEndianBytes(4);
    }

    public long readLittleEndianUnsignedInt() throws IOException {
        return (long)this.readLittleEndianInt() & 0xFFFFFFFFL;
    }

    public short readLittleEndianShort() throws IOException {
        return (short)this.readNLittleEndianBytes(2);
    }

    public int readLittleEndianUnsignedShort() throws IOException {
        return this.readLittleEndianShort() & 0xFFFF;
    }

    private long readNLittleEndianBytes(int n) throws IOException {
        long res = 0L;
        for (int i = 0; i < n; ++i) {
            res |= (long)(this.readUnsignedByte() << 8 * i);
        }
        return res;
    }
}

