/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j62056.internal;

public class HexConverter {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static String toHexString(byte b) {
        StringBuilder builder = new StringBuilder();
        HexConverter.appendHexString(b, builder);
        return builder.toString();
    }

    public static String toHexString(byte[] bytes) {
        return HexConverter.toHexString(bytes, 0, bytes.length);
    }

    public static String toHexString(byte[] bytes, int offset, int length) {
        StringBuilder builder = new StringBuilder();
        int l = 1;
        for (int i = offset; i < offset + length; ++i) {
            if (l != 1 && (l - 1) % 8 == 0) {
                builder.append(' ');
            }
            if (l != 1 && (l - 1) % 16 == 0) {
                builder.append('\n');
            }
            ++l;
            HexConverter.appendHexString(bytes[i], builder);
            if (i == offset + length - 1) continue;
            builder.append(' ');
        }
        return builder.toString();
    }

    public static String toShortHexString(int i) {
        byte[] bytes = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        return HexConverter.toShortHexString(bytes);
    }

    public static String toShortHexString(long l) {
        byte[] bytes = new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
        return HexConverter.toShortHexString(bytes);
    }

    public static String toShortHexString(byte b) {
        return HexConverter.toShortHexString(new byte[]{b});
    }

    public static String toShortHexString(byte[] bytes) {
        return HexConverter.toShortHexString(bytes, 0, bytes.length);
    }

    public static String toShortHexString(byte[] bytes, int offset, int length) {
        char[] hexChars = new char[length * 2];
        for (int j = offset; j < offset + length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] fromShortHexString(String shortHexString) throws NumberFormatException {
        HexConverter.validate(shortHexString);
        int length = shortHexString.length();
        byte[] data = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            int firstCharacter = Character.digit(shortHexString.charAt(i), 16);
            int secondCharacter = Character.digit(shortHexString.charAt(i + 1), 16);
            if (firstCharacter == -1 || secondCharacter == -1) {
                throw new NumberFormatException("string is not a legal hex string.");
            }
            data[i / 2] = (byte)((firstCharacter << 4) + secondCharacter);
        }
        return data;
    }

    public static void appendShortHexString(byte b, StringBuilder builder) {
        builder.append(HexConverter.toShortHexString(b));
    }

    public static void appendShortHexString(StringBuilder builder, byte[] bytes, int offset, int length) {
        builder.append(HexConverter.toShortHexString(bytes, offset, length));
    }

    public static void appendHexString(byte b, StringBuilder builder) {
        builder.append("0x");
        HexConverter.appendShortHexString(b, builder);
    }

    public static void appendHexString(StringBuilder builder, byte[] byteArray, int offset, int length) {
        int l = 1;
        for (int i = offset; i < offset + length; ++i) {
            if (l != 1 && (l - 1) % 8 == 0) {
                builder.append(' ');
            }
            if (l != 1 && (l - 1) % 16 == 0) {
                builder.append('\n');
            }
            ++l;
            HexConverter.appendHexString(byteArray[i], builder);
            if (i == offset + length - 1) continue;
            builder.append(' ');
        }
    }

    private static void validate(String s) {
        if (s == null) {
            throw new IllegalArgumentException("string s may not be null");
        }
        if (s.length() == 0 || s.length() % 2 != 0) {
            throw new NumberFormatException("string is not a legal hex string.");
        }
    }

    private HexConverter() {
    }
}

