/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j62056.internal;

import java.io.DataInputStream;
import java.io.IOException;
import org.openmuc.j62056.internal.Helper;
import org.openmuc.j62056.internal.HexConverter;
import org.openmuc.j62056.internal.ProtocolMode;

public class IdentificationMessage {
    private final String manufacturerId;
    private final ProtocolMode protocolMode;
    private final int baudRate;
    private final String meterId;
    private final String enhancedId;

    public IdentificationMessage(DataInputStream is) throws IOException {
        byte b = is.readByte();
        if (b != 47) {
            throw new IOException("Received unexpected identification message start byte: " + HexConverter.toShortHexString(b));
        }
        byte[] manufacturerIdBytes = new byte[3];
        is.readFully(manufacturerIdBytes);
        this.manufacturerId = new String(manufacturerIdBytes, Helper.ASCII_CHARSET);
        byte baudRateByte = is.readByte();
        switch (baudRateByte) {
            case 65: {
                this.baudRate = 600;
                this.protocolMode = ProtocolMode.B;
                break;
            }
            case 66: {
                this.baudRate = 1200;
                this.protocolMode = ProtocolMode.B;
                break;
            }
            case 67: {
                this.baudRate = 2400;
                this.protocolMode = ProtocolMode.B;
                break;
            }
            case 68: {
                this.baudRate = 4800;
                this.protocolMode = ProtocolMode.B;
                break;
            }
            case 69: {
                this.baudRate = 9600;
                this.protocolMode = ProtocolMode.B;
                break;
            }
            case 70: {
                this.baudRate = 19200;
                this.protocolMode = ProtocolMode.B;
                break;
            }
            case 48: {
                this.baudRate = 300;
                this.protocolMode = ProtocolMode.C;
                break;
            }
            case 49: {
                this.baudRate = 600;
                this.protocolMode = ProtocolMode.C;
                break;
            }
            case 50: {
                this.baudRate = 1200;
                this.protocolMode = ProtocolMode.C;
                break;
            }
            case 51: {
                this.baudRate = 2400;
                this.protocolMode = ProtocolMode.C;
                break;
            }
            case 52: {
                this.baudRate = 4800;
                this.protocolMode = ProtocolMode.C;
                break;
            }
            case 53: {
                this.baudRate = 9600;
                this.protocolMode = ProtocolMode.C;
                break;
            }
            case 54: {
                this.baudRate = 19200;
                this.protocolMode = ProtocolMode.C;
                break;
            }
            default: {
                this.baudRate = -1;
                this.protocolMode = ProtocolMode.A;
            }
        }
        b = is.readByte();
        String tempEnhancedId = "";
        while (b == 92) {
            tempEnhancedId = tempEnhancedId + (char)is.readByte();
            b = is.readByte();
        }
        this.enhancedId = tempEnhancedId;
        byte[] identificationBytes = new byte[16];
        int i = 0;
        while (b != 13) {
            if (i == 16) {
                throw new IOException("Expected carriage return character not received");
            }
            identificationBytes[i] = b;
            ++i;
            b = is.readByte();
        }
        this.meterId = new String(identificationBytes, 0, i, Helper.ASCII_CHARSET);
        b = is.readByte();
        if (b != 10) {
            throw new IOException("Received unexpected identification message end byte: " + HexConverter.toShortHexString(b));
        }
    }

    public String getManufactureId() {
        return this.manufacturerId;
    }

    public String getMeterId() {
        return this.meterId;
    }

    public String getEnhancedId() {
        return this.enhancedId;
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public ProtocolMode getProtocolMode() {
        return this.protocolMode;
    }

    public String toString() {
        return "{\"identification message\": {\"manufacturer ID\": \"" + this.manufacturerId + "\", \"protocol mode\": \"" + (Object)((Object)this.protocolMode) + "\", \"baud rate\": " + this.baudRate + ", \"meter ID\": \"" + this.meterId + "\", \"enhanced ID/capability\": \"" + this.enhancedId + "\"" + IdentificationMessage.getEnhancedIdDescription(this.enhancedId) + "}}";
    }

    public static String getEnhancedIdDescription(String enhancedId) {
        if (enhancedId.equals("2")) {
            return "(HDLC)";
        }
        return "";
    }
}

