/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j62056;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.openmuc.j62056.DataMessage;
import org.openmuc.j62056.ModeDListener;
import org.openmuc.j62056.internal.AcknowledgeMessage;
import org.openmuc.j62056.internal.AcknowledgeMode;
import org.openmuc.j62056.internal.Helper;
import org.openmuc.j62056.internal.IdentificationMessage;
import org.openmuc.j62056.internal.ProtocolControlCharacter;
import org.openmuc.j62056.internal.ProtocolMode;
import org.openmuc.j62056.internal.RequestMessage;
import org.openmuc.j62056.internal.SelectMessage;
import org.openmuc.j62056.internal.SelectReplyMessage;
import org.openmuc.jrxtx.DataBits;
import org.openmuc.jrxtx.Parity;
import org.openmuc.jrxtx.SerialPort;
import org.openmuc.jrxtx.SerialPortBuilder;
import org.openmuc.jrxtx.StopBits;

public class Iec21Port {
    private static final String SENDING = "Sending ";
    private static final String CHANGING_BAUD_RATE_FROM = "Changing baud rate from ";
    private final int baudRateChangeDelay;
    private final int initialBaudRateModeABC;
    private final int initialBaudRateModeD;
    private final int timeout;
    private final boolean verbose;
    private final boolean fixedBaudRate;
    private final SerialPort serialPort;
    private final DataOutputStream os;
    private final DataInputStream is;
    private final RequestMessage requestMessage;
    private final SelectMessage selectMessage;
    private final String selectExpect;
    private final AcknowledgeMode acknowledgeMode;
    private ModeDListener listener = null;
    private boolean closed = false;

    private Iec21Port(Builder builder) throws IOException {
        if (builder.initialBaudrate == -1) {
            this.initialBaudRateModeABC = 300;
            this.initialBaudRateModeD = 2400;
        } else {
            this.initialBaudRateModeABC = builder.initialBaudrate;
            this.initialBaudRateModeD = builder.initialBaudrate;
        }
        this.baudRateChangeDelay = builder.baudRateChangeDelay;
        this.timeout = builder.timeout;
        this.verbose = builder.verbose;
        this.requestMessage = new RequestMessage(builder.deviceAddress, builder.requestStartCharacters);
        this.fixedBaudRate = builder.fixedBaudRate;
        this.selectMessage = new SelectMessage(builder.selectManufacturerData);
        this.selectExpect = builder.selectExpectData;
        this.acknowledgeMode = builder.acknowledgeMode;
        this.serialPort = SerialPortBuilder.newBuilder((String)builder.serialPortName).setDataBits(DataBits.DATABITS_7).setStopBits(StopBits.STOPBITS_1).setParity(Parity.EVEN).setBaudRate(this.initialBaudRateModeABC).build();
        this.serialPort.setSerialPortTimeout(this.timeout);
        this.is = new DataInputStream(this.serialPort.getInputStream());
        this.os = new DataOutputStream(new BufferedOutputStream(this.serialPort.getOutputStream()));
    }

    public final SerialPort getSerialPort() {
        return this.serialPort;
    }

    public final DataOutputStream getOutputStream() {
        return this.os;
    }

    public final DataInputStream getInputStream() {
        return this.is;
    }

    public void close() {
        this.closed = true;
        try {
            this.serialPort.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public DataMessage read() throws IOException {
        if (this.isClosed()) {
            throw new IOException("Port is closed");
        }
        this.setInitialBaudrate();
        this.clearInputStream();
        this.selectMessage();
        this.requestMessage.send(this.os);
        if (this.verbose) {
            Helper.debug(SENDING, this.requestMessage.toString());
        }
        IdentificationMessage identificationMessage = new IdentificationMessage(this.is);
        if (this.verbose) {
            Helper.debug("Received ", identificationMessage.toString());
        }
        this.handleModeC(identificationMessage);
        this.changeBaudrate(identificationMessage);
        DataMessage dataMessage = DataMessage.readModeAbcDataMessage(this.is, identificationMessage);
        if (this.verbose) {
            Helper.debug("Received data message.");
        }
        this.setInitialBaudrate();
        return dataMessage;
    }

    private void clearInputStream() throws IOException {
        int numBytesInStream = this.is.available();
        if (numBytesInStream > 0) {
            byte[] bytesInStream = new byte[numBytesInStream];
            int numBytes = this.is.read(bytesInStream);
            if (this.verbose) {
                Helper.debug("Cleared input stream. " + numBytes + " bytes read from stream: ", bytesInStream);
            }
        }
    }

    private void selectMessage() throws IOException {
        if (!this.selectMessage.isEmpty()) {
            this.selectMessage.send(this.os);
            if (this.verbose) {
                Helper.debug(SENDING, this.selectMessage.toString());
            }
            SelectReplyMessage replyMessage = new SelectReplyMessage(this.is);
            if (this.verbose) {
                Helper.debug("Received ", replyMessage.toString());
            }
            if (!replyMessage.getReplyMessage().equals(this.selectExpect)) {
                throw new IOException("Received unexpected select reply message: " + replyMessage.getReplyMessage());
            }
        }
    }

    private void setInitialBaudrate() throws IOException {
        if (this.serialPort.getBaudRate() != this.initialBaudRateModeABC) {
            if (this.verbose) {
                Helper.debug(CHANGING_BAUD_RATE_FROM, this.serialPort.getBaudRate(), " to ", this.initialBaudRateModeABC);
            }
            this.serialPort.setBaudRate(this.initialBaudRateModeABC);
        }
    }

    private void changeBaudrate(IdentificationMessage identificationMessage) throws IOException {
        if (identificationMessage.getProtocolMode() == ProtocolMode.B || identificationMessage.getProtocolMode() == ProtocolMode.C && !this.fixedBaudRate) {
            if (this.verbose) {
                Helper.debug(CHANGING_BAUD_RATE_FROM, this.serialPort.getBaudRate(), " to ", identificationMessage.getBaudRate());
            }
            this.serialPort.setBaudRate(identificationMessage.getBaudRate());
        }
    }

    private void handleModeC(IdentificationMessage identificationMessage) throws IOException {
        if (identificationMessage.getProtocolMode() == ProtocolMode.C) {
            int baudRate = identificationMessage.getBaudRate();
            if (this.fixedBaudRate) {
                baudRate = this.serialPort.getBaudRate();
            }
            AcknowledgeMessage acknowledgeMessage = new AcknowledgeMessage(baudRate, ProtocolControlCharacter.NORMAL, this.acknowledgeMode);
            if (this.verbose) {
                Helper.debug(SENDING, acknowledgeMessage.toString());
            }
            acknowledgeMessage.send(this.os);
            if (!this.fixedBaudRate && this.baudRateChangeDelay > 0) {
                if (this.verbose) {
                    Helper.debug("Sleeping for : ", this.baudRateChangeDelay, "ms before changing the baud rate");
                }
                try {
                    Thread.sleep(this.baudRateChangeDelay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void listen(ModeDListener listener) throws IOException {
        this.serialPort.setSerialPortTimeout(0);
        if (this.serialPort.getBaudRate() != this.initialBaudRateModeD) {
            if (this.verbose) {
                Helper.debug(CHANGING_BAUD_RATE_FROM, this.serialPort.getBaudRate(), " to ", this.initialBaudRateModeD);
            }
            this.serialPort.setBaudRate(this.initialBaudRateModeD);
        }
        this.listener = listener;
        if (this.verbose) {
            Helper.debug("Starting to listen for mode D messages");
        }
        new ModeDReceiver().start();
    }

    public static class Builder {
        private int baudRateChangeDelay = 0;
        private int initialBaudrate = -1;
        private int timeout = 5000;
        private boolean verbose = false;
        private String deviceAddress = "";
        private boolean fixedBaudRate = false;
        private String requestStartCharacters = null;
        private String selectManufacturerData = null;
        private String selectExpectData = null;
        private AcknowledgeMode acknowledgeMode = AcknowledgeMode.DATA_READOUT;
        private final String serialPortName;

        public Builder(String serialPortName) {
            if (serialPortName == null) {
                throw new IllegalArgumentException("serialPort may not be NULL");
            }
            this.serialPortName = serialPortName;
        }

        public Builder setBaudRateChangeDelay(int baudRateChangeDelay) {
            this.baudRateChangeDelay = baudRateChangeDelay;
            return this;
        }

        public Builder setInitialBaudrate(int initialBaudrate) {
            this.initialBaudrate = initialBaudrate;
            return this;
        }

        public Builder setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder setDeviceAddress(String deviceAddress) {
            this.deviceAddress = deviceAddress;
            return this;
        }

        public Builder setRequestStartCharacters(String requestStartCharacters) {
            this.requestStartCharacters = requestStartCharacters;
            return this;
        }

        public Builder setSelectManufacturerData(String selectManufacturerData) {
            this.selectManufacturerData = selectManufacturerData;
            return this;
        }

        public Builder setSelectExpectData(String selectExpectData) {
            this.selectExpectData = selectExpectData;
            return this;
        }

        public Builder setAcknowledgeMode(char acknowledgeMode) {
            this.acknowledgeMode = AcknowledgeMode.valueOf(acknowledgeMode);
            return this;
        }

        public Builder enableVerboseMode(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder enableFixedBaudrate(boolean fixedBaudRate) {
            this.fixedBaudRate = fixedBaudRate;
            return this;
        }

        public Iec21Port buildAndOpen() throws IOException {
            return new Iec21Port(this);
        }
    }

    private class ModeDReceiver
    extends Thread {
        private ModeDReceiver() {
        }

        @Override
        public void run() {
            while (!Iec21Port.this.isClosed()) {
                try {
                    IdentificationMessage identificationMessage = new IdentificationMessage(Iec21Port.this.is);
                    Iec21Port.this.listener.newDataMessage(DataMessage.readModeDDataMessage(Iec21Port.this.is, identificationMessage, Iec21Port.this.serialPort));
                }
                catch (Exception e) {
                    if (Iec21Port.this.isClosed()) break;
                    Iec21Port.this.listener.exceptionWhileListening(e);
                    this.clearInputStream();
                }
            }
        }

        private void clearInputStream() {
            try {
                int numBytesInStream = Iec21Port.this.is.available();
                if (numBytesInStream > 0) {
                    byte[] bytesInStream = new byte[numBytesInStream];
                    int numBytes = Iec21Port.this.is.read(bytesInStream);
                    if (Iec21Port.this.verbose) {
                        Helper.debug("Cleared input stream because of exception. " + numBytes + "bytes read from stream: ", bytesInStream);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

