/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j62056.app;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.openmuc.j62056.DataMessage;
import org.openmuc.j62056.Iec21Port;
import org.openmuc.j62056.ModeDListener;
import org.openmuc.j62056.app.ConsoleLineParser;
import org.openmuc.j62056.internal.cli.CliParseException;

public class Reader {
    public static void main(String[] args) {
        ConsoleLineParser cliParser = new ConsoleLineParser();
        try {
            cliParser.parse(args);
        }
        catch (CliParseException e) {
            Reader.printLnErr(e.getMessage());
            cliParser.printUsage();
            System.exit(1);
        }
        Iec21Port iec21Port = null;
        try {
            iec21Port = new Iec21Port.Builder(cliParser.serialPortName.getValue()).setBaudRateChangeDelay(cliParser.baudRateChangeDelay.getValue()).setTimeout(cliParser.timeout.getValue()).setInitialBaudrate(cliParser.initialBaudRate.getValue()).enableVerboseMode(cliParser.verbose.isSelected()).enableFixedBaudrate(cliParser.fixedBaudRate.isSelected()).setDeviceAddress(cliParser.deviceAddress.getValue()).setRequestStartCharacters(cliParser.requestStartCharacters.getValue()).buildAndOpen();
        }
        catch (IllegalArgumentException e) {
            Reader.printLnErr("Illegal parameter value: ", e.getMessage());
            cliParser.printUsage();
            System.exit(1);
        }
        catch (IOException e) {
            Reader.printLnErr("Failed to open serial port: ", e.getMessage());
            System.exit(1);
        }
        final Iec21Port iec21PortFinalRef = iec21Port;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                iec21PortFinalRef.close();
            }
        });
        DataMessage dataMessage = null;
        if (cliParser.listen.isSelected()) {
            try {
                iec21Port.listen(new ModeDListenerImpl());
            }
            catch (IOException e) {
                Reader.printLnErr("IOException while starting to listen: ", e.getMessage());
                System.exit(1);
            }
            return;
        }
        try {
            dataMessage = iec21Port.read();
        }
        catch (InterruptedIOException e) {
            Reader.printLnErr("Read attempt timed out.");
            System.exit(1);
        }
        catch (IOException e) {
            Reader.printLnErr("IOException while trying to read: ", e.getMessage());
            System.exit(1);
        }
        Reader.printLn(dataMessage.toString());
    }

    private static void printLnErr(String ... text) {
        System.err.print(Reader.conCat(text));
    }

    private static void printLn(String ... text) {
        System.out.print(Reader.conCat(text));
    }

    private static String conCat(String ... text) {
        StringBuilder sb = new StringBuilder();
        for (String s : text) {
            sb.append(s);
        }
        sb.append('\n');
        return sb.toString();
    }

    private static class ModeDListenerImpl
    implements ModeDListener {
        private ModeDListenerImpl() {
        }

        @Override
        public void newDataMessage(DataMessage dataMessage) {
            Reader.printLn(new String[]{"Received ", dataMessage.toString()});
        }

        @Override
        public void exceptionWhileListening(Exception e) {
            Reader.printLnErr(new String[]{"IOException while listening for messages: ", e.getMessage()});
        }
    }
}

