/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j62056.internal;

import java.io.DataInputStream;
import java.io.IOException;
import org.openmuc.j62056.internal.Helper;
import org.openmuc.j62056.internal.HexConverter;
import org.openmuc.j62056.internal.ProtocolMode;

public class IdentificationMessage {
    private final String manufacturerId;
    private ProtocolMode protocolMode;
    private int baudRate;
    private final String meterId;
    private final String enhancedId;

    public IdentificationMessage(DataInputStream is) throws IOException {
        byte b = is.readByte();
        this.checkIdentificationMessageStartByte(b);
        this.manufacturerId = this.getManufactureId(is);
        this.parseMode(is);
        b = is.readByte();
        StringBuilder sbEnhancedId = new StringBuilder();
        while (b == 92) {
            sbEnhancedId.append((char)is.readByte());
            b = is.readByte();
        }
        this.enhancedId = sbEnhancedId.toString();
        this.meterId = this.getMeterId(is, b);
        this.checkEndOfMessage(is);
    }

    private void checkIdentificationMessageStartByte(byte b) throws IOException {
        if (b != 47) {
            throw new IOException("Received unexpected identification message start byte: " + HexConverter.toShortHexString(b));
        }
    }

    private String getManufactureId(DataInputStream is) throws IOException {
        byte[] manufacturerIdBytes = new byte[3];
        is.readFully(manufacturerIdBytes);
        return new String(manufacturerIdBytes, Helper.ASCII_CHARSET);
    }

    private String getMeterId(DataInputStream is, byte b) throws IOException {
        byte[] identificationBytes = new byte[32];
        int i = 0;
        while (b != 13) {
            if (i == 32) {
                throw new IOException("Expected carriage return character not received");
            }
            identificationBytes[i] = b;
            ++i;
            b = is.readByte();
        }
        return new String(identificationBytes, 0, i, Helper.ASCII_CHARSET);
    }

    private void checkEndOfMessage(DataInputStream is) throws IOException {
        byte b = is.readByte();
        if (b != 10) {
            throw new IOException("Received unexpected identification message end byte: " + HexConverter.toShortHexString(b));
        }
    }

    private void parseMode(DataInputStream is) throws IOException {
        byte baudRateByte = is.readByte();
        switch (baudRateByte) {
            case 65: {
                this.setModeB(600);
                break;
            }
            case 66: {
                this.setModeB(1200);
                break;
            }
            case 67: {
                this.setModeB(2400);
                break;
            }
            case 68: {
                this.setModeB(4800);
                break;
            }
            case 69: {
                this.setModeB(9600);
                break;
            }
            case 70: {
                this.setModeB(19200);
                break;
            }
            case 48: {
                this.setModeC(300);
                break;
            }
            case 49: {
                this.setModeC(600);
                break;
            }
            case 50: {
                this.setModeC(1200);
                break;
            }
            case 51: {
                this.setModeC(2400);
                break;
            }
            case 52: {
                this.setModeC(4800);
                break;
            }
            case 53: {
                this.setModeC(9600);
                break;
            }
            case 54: {
                this.setModeC(19200);
                break;
            }
            default: {
                this.setMode(-1, ProtocolMode.A);
            }
        }
    }

    private void setMode(int baudrate, ProtocolMode protocolMode) {
        this.baudRate = baudrate;
        this.protocolMode = protocolMode;
    }

    private void setModeC(int baudrate) {
        this.setMode(baudrate, ProtocolMode.C);
    }

    private void setModeB(int baudrate) {
        this.setMode(baudrate, ProtocolMode.B);
    }

    public String getManufactureId() {
        return this.manufacturerId;
    }

    public String getMeterId() {
        return this.meterId;
    }

    public String getEnhancedId() {
        return this.enhancedId;
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public ProtocolMode getProtocolMode() {
        return this.protocolMode;
    }

    public String toString() {
        return "{\"identification message\": {\"manufacturer ID\": \"" + this.manufacturerId + "\", \"protocol mode\": \"" + (Object)((Object)this.protocolMode) + "\", \"baud rate\": " + this.baudRate + ", \"meter ID\": \"" + this.meterId + "\", \"enhanced ID/capability\": \"" + this.enhancedId + "\"" + IdentificationMessage.getEnhancedIdDescription(this.enhancedId) + "}}";
    }

    public static String getEnhancedIdDescription(String enhancedId) {
        if (enhancedId.equals("2")) {
            return "(HDLC)";
        }
        return "";
    }
}

