/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j62056.internal;

import java.io.DataOutputStream;
import java.io.IOException;
import org.openmuc.j62056.internal.Helper;

public class RequestMessage {
    private final byte[] requestMessageBytes;
    private final String deviceAddress;

    public RequestMessage(String deviceAddress) {
        this(deviceAddress, null);
    }

    public RequestMessage(String deviceAddress, String startCharacters) {
        if (deviceAddress.length() > 32) {
            throw new IllegalArgumentException("Device address is longer than 32 characters");
        }
        if (startCharacters == null || startCharacters.isEmpty()) {
            startCharacters = "/?";
        }
        this.deviceAddress = deviceAddress;
        this.requestMessageBytes = (startCharacters + deviceAddress + "!\r\n").getBytes(Helper.ASCII_CHARSET);
    }

    public void send(DataOutputStream os) throws IOException {
        os.write(this.requestMessageBytes);
        os.flush();
    }

    public String toString() {
        return "{\"request message\": {\"device address\": \"" + this.deviceAddress + "\"}}";
    }
}

