/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.compiler;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.openmuc.jasn1.ber.BerTag;
import org.openmuc.jasn1.ber.types.BerObjectIdentifier;
import org.openmuc.jasn1.compiler.CompileException;
import org.openmuc.jasn1.compiler.HexConverter;
import org.openmuc.jasn1.compiler.model.AsnAny;
import org.openmuc.jasn1.compiler.model.AsnBitString;
import org.openmuc.jasn1.compiler.model.AsnBoolean;
import org.openmuc.jasn1.compiler.model.AsnCharacterString;
import org.openmuc.jasn1.compiler.model.AsnChoice;
import org.openmuc.jasn1.compiler.model.AsnClassNumber;
import org.openmuc.jasn1.compiler.model.AsnConstructedType;
import org.openmuc.jasn1.compiler.model.AsnDefinedType;
import org.openmuc.jasn1.compiler.model.AsnElementType;
import org.openmuc.jasn1.compiler.model.AsnEmbeddedPdv;
import org.openmuc.jasn1.compiler.model.AsnEnum;
import org.openmuc.jasn1.compiler.model.AsnInformationObjectClass;
import org.openmuc.jasn1.compiler.model.AsnInteger;
import org.openmuc.jasn1.compiler.model.AsnModule;
import org.openmuc.jasn1.compiler.model.AsnNull;
import org.openmuc.jasn1.compiler.model.AsnObjectIdentifier;
import org.openmuc.jasn1.compiler.model.AsnOctetString;
import org.openmuc.jasn1.compiler.model.AsnParameter;
import org.openmuc.jasn1.compiler.model.AsnReal;
import org.openmuc.jasn1.compiler.model.AsnSequenceOf;
import org.openmuc.jasn1.compiler.model.AsnSequenceSet;
import org.openmuc.jasn1.compiler.model.AsnTag;
import org.openmuc.jasn1.compiler.model.AsnTaggedType;
import org.openmuc.jasn1.compiler.model.AsnType;
import org.openmuc.jasn1.compiler.model.AsnUniversalType;
import org.openmuc.jasn1.compiler.model.AsnValueAssignment;
import org.openmuc.jasn1.compiler.model.SymbolsFromModule;

public class BerClassWriter {
    private static Tag stdSeqTag = new Tag();
    private static Tag stdSetTag = new Tag();
    private static final Set<String> reservedKeywords;
    private AsnModule.TagDefault tagDefault;
    private File outputBaseDir;
    private final String basePackageName;
    private int indentNum = 0;
    BufferedWriter out;
    private final boolean supportIndefiniteLength;
    private final boolean jaxbMode;
    private final HashMap<String, AsnModule> modulesByName;
    private AsnModule module;
    private File outputDirectory;
    private String berTypeInterfaceString = "BerType, ";

    BerClassWriter(HashMap<String, AsnModule> modulesByName, String outputBaseDir, String basePackageName, boolean jaxbMode, boolean supportIndefiniteLength, boolean disableBerTypeInterface) throws IOException {
        this.supportIndefiniteLength = supportIndefiniteLength;
        this.jaxbMode = jaxbMode;
        this.outputBaseDir = new File(outputBaseDir);
        if (disableBerTypeInterface) {
            this.berTypeInterfaceString = "";
        }
        if (basePackageName.isEmpty()) {
            this.basePackageName = "";
        } else {
            this.outputBaseDir = new File(this.outputBaseDir, basePackageName.replace('.', '/'));
            this.basePackageName = basePackageName + ".";
        }
        this.modulesByName = modulesByName;
    }

    public void translate() throws IOException {
        for (AsnModule module : this.modulesByName.values()) {
            for (SymbolsFromModule symbolsFromModule : module.importSymbolFromModuleList) {
                if (this.modulesByName.get(symbolsFromModule.modref) != null) continue;
                throw new IOException("Module \"" + module.moduleIdentifier.name + "\" imports missing module \"" + symbolsFromModule.modref + "\".");
            }
        }
        for (AsnModule module : this.modulesByName.values()) {
            this.translateModule(module);
        }
    }

    int[] toIntArray(List<Integer> list) {
        int[] ret = new int[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    public void translateModule(AsnModule module) throws IOException {
        System.out.println("Generating classes for module \"" + module.moduleIdentifier.name + "\"");
        this.outputDirectory = new File(this.outputBaseDir, this.sanitizeModuleName(module.moduleIdentifier.name).replace('-', '/').toLowerCase());
        this.module = module;
        this.tagDefault = module.tagDefault;
        for (AsnType typeDefinition : module.typesByName.values()) {
            if (typeDefinition instanceof AsnDefinedType && this.getInformationObjectClass(((AsnDefinedType)typeDefinition).typeName, module) != null) continue;
            String typeName = this.cleanUpName(typeDefinition.name);
            this.writeClassHeader(typeName, module);
            if (typeDefinition instanceof AsnTaggedType) {
                AsnTaggedType asnTaggedType = (AsnTaggedType)typeDefinition;
                Tag tag = this.getTag(asnTaggedType);
                if (asnTaggedType.definedType != null) {
                    this.writeRetaggingTypeClass(typeName, asnTaggedType.definedType.typeName, typeDefinition, tag);
                } else {
                    AsnType assignedAsnType = asnTaggedType.typeReference;
                    if (assignedAsnType instanceof AsnConstructedType) {
                        this.writeConstructedTypeClass(typeName, assignedAsnType, tag, false, null);
                    } else {
                        this.writeRetaggingTypeClass(typeName, this.getBerType(assignedAsnType), typeDefinition, tag);
                    }
                }
            } else if (typeDefinition instanceof AsnDefinedType) {
                this.writeRetaggingTypeClass(typeName, ((AsnDefinedType)typeDefinition).typeName, typeDefinition, null);
            } else if (typeDefinition instanceof AsnConstructedType) {
                this.writeConstructedTypeClass(typeName, typeDefinition, null, false, null);
            } else {
                this.writeRetaggingTypeClass(typeName, this.getBerType(typeDefinition), typeDefinition, null);
            }
            this.out.close();
        }
        this.writeOidValues(module);
    }

    private void writeOidValues(AsnModule module) throws IOException {
        boolean first = true;
        ArrayList<String> values = new ArrayList<String>(module.asnValueAssignmentsByName.keySet());
        Collections.sort(values);
        for (String valueName : values) {
            BerObjectIdentifier oid;
            if (!(module.asnValueAssignmentsByName.get((Object)valueName).type instanceof AsnObjectIdentifier)) continue;
            try {
                oid = this.parseObjectIdentfierValue(valueName, module);
            }
            catch (IllegalStateException e) {
                System.out.println("Warning: could not parse object identifier value: " + e.getMessage());
                continue;
            }
            StringBuilder sb = new StringBuilder("public static final BerObjectIdentifier " + this.cleanUpName(valueName) + " = new BerObjectIdentifier(new int[]{");
            if (first) {
                first = false;
                this.writeClassHeader("OidValues", module);
                this.write("public final class OidValues {");
            }
            boolean firstOidComponent = true;
            for (int i : oid.value) {
                if (firstOidComponent) {
                    firstOidComponent = false;
                } else {
                    sb.append(", ");
                }
                sb.append(i);
            }
            sb.append("});");
            this.write(sb.toString());
        }
        if (!first) {
            this.write("}");
            this.out.close();
        }
    }

    private String sanitizeModuleName(String name) {
        String[] moduleParts = name.split("-");
        String toReturn = "";
        for (String part : moduleParts) {
            toReturn = toReturn + this.sanitize(part.toLowerCase()) + "-";
        }
        if (!toReturn.isEmpty()) {
            toReturn = toReturn.substring(0, toReturn.length() - 1);
        }
        return toReturn;
    }

    private BerObjectIdentifier parseObjectIdentfierValue(String name, AsnModule module) throws IOException {
        AsnValueAssignment valueAssignment = module.asnValueAssignmentsByName.get(name);
        if (valueAssignment == null || !(valueAssignment.type instanceof AsnObjectIdentifier)) {
            return null;
        }
        if (!valueAssignment.value.isValueInBraces) {
            throw new IllegalStateException("value of object identifier \"" + valueAssignment.name + "\" is not defined in braces.");
        }
        ArrayList<Integer> oidComponents = new ArrayList<Integer>();
        List<String> tokens = valueAssignment.value.valueInBracesTokens;
        for (int i = 0; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            if (Character.isDigit(token.charAt(0))) {
                oidComponents.add(Integer.parseInt(token));
                continue;
            }
            if (!Character.isLetter(token.charAt(0)) || tokens.size() != i + 1 && tokens.get(i + 1).equals("(") || this.parseRegisteredOidComponentName(oidComponents, token)) continue;
            BerObjectIdentifier oid = this.parseObjectIdentfierValue(token, module);
            if (oid == null) {
                for (SymbolsFromModule symbolsFromModule : module.importSymbolFromModuleList) {
                    for (String importedTypeName : symbolsFromModule.symbolList) {
                        if (!token.equals(importedTypeName)) continue;
                        oid = this.parseObjectIdentfierValue(token, this.modulesByName.get(symbolsFromModule.modref));
                    }
                }
            }
            if (oid == null) {
                throw new IllegalStateException("AsnValueAssigment \"" + token + "\" was not found in module \"" + module.moduleIdentifier.name + "\"");
            }
            for (Object element : (Object)oid.value) {
                oidComponents.add((int)element);
            }
        }
        return new BerObjectIdentifier(this.toIntArray(oidComponents));
    }

    private boolean parseRegisteredOidComponentName(List<Integer> oidComponents, String token) throws IOException {
        if (oidComponents.size() == 0) {
            switch (token) {
                case "itu-t": 
                case "ccitt": {
                    oidComponents.add(0);
                    return true;
                }
                case "iso": {
                    oidComponents.add(1);
                    return true;
                }
                case "joint-iso-itu-t": 
                case "joint-iso-ccitt": {
                    oidComponents.add(2);
                    return true;
                }
            }
        } else if (oidComponents.size() == 1) {
            switch (oidComponents.get(0)) {
                case 0: {
                    switch (token) {
                        case "recommendation": {
                            oidComponents.add(0);
                            return true;
                        }
                        case "question": {
                            oidComponents.add(1);
                            return true;
                        }
                        case "administration": {
                            oidComponents.add(2);
                            return true;
                        }
                        case "network-operator": {
                            oidComponents.add(3);
                            return true;
                        }
                        case "identified-organization": {
                            oidComponents.add(4);
                            return true;
                        }
                    }
                }
                case 1: {
                    switch (token) {
                        case "standard": {
                            oidComponents.add(0);
                            return true;
                        }
                        case "registration-authority": {
                            oidComponents.add(1);
                            return true;
                        }
                        case "member-body": {
                            oidComponents.add(2);
                            return true;
                        }
                        case "identified-organization": {
                            oidComponents.add(3);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private Tag getTag(AsnTaggedType asnTaggedType) throws IOException {
        AsnTag asnTag = asnTaggedType.tag;
        if (asnTag == null) {
            return null;
        }
        Tag tag = new Tag();
        String tagClassString = asnTag.clazz;
        if (tagClassString.isEmpty() || "CONTEXT".equals(tagClassString)) {
            tag.tagClass = TagClass.CONTEXT;
        } else if ("APPLICATION".equals(tagClassString)) {
            tag.tagClass = TagClass.APPLICATION;
        } else if ("PRIVATE".equals(tagClassString)) {
            tag.tagClass = TagClass.PRIVATE;
        } else if ("UNIVERSAL".equals(tagClassString)) {
            tag.tagClass = TagClass.UNIVERSAL;
        } else {
            throw new IllegalStateException("unknown tag class: " + tagClassString);
        }
        String tagTypeString = asnTaggedType.tagType;
        if (tagTypeString.isEmpty()) {
            tag.type = this.tagDefault == AsnModule.TagDefault.EXPLICIT ? TagType.EXPLICIT : TagType.IMPLICIT;
        } else if (tagTypeString.equals("IMPLICIT")) {
            tag.type = TagType.IMPLICIT;
        } else if (tagTypeString.equals("EXPLICIT")) {
            tag.type = TagType.EXPLICIT;
        } else {
            throw new IllegalStateException("unexpected tag type: " + tagTypeString);
        }
        if (tag.type == TagType.IMPLICIT && this.isDirectAnyOrChoice(asnTaggedType)) {
            tag.type = TagType.EXPLICIT;
        }
        tag.typeStructure = tag.type == TagType.IMPLICIT && this.isPrimitive(asnTaggedType) ? TypeStructure.PRIMITIVE : TypeStructure.CONSTRUCTED;
        tag.value = asnTaggedType.tag.classNumber.num;
        return tag;
    }

    private String cleanUpName(String name) {
        name = this.replaceCharByCamelCase(name, '-');
        name = this.replaceCharByCamelCase(name, '_');
        return this.sanitize(name);
    }

    private String sanitize(String name) {
        String result = this.replaceCharByCamelCase(name, '.');
        if (reservedKeywords.contains(result)) {
            result = result + "_";
        }
        return result;
    }

    private String replaceCharByCamelCase(String name, char charToBeReplaced) {
        StringBuilder nameSb = new StringBuilder(name);
        int index = name.indexOf(charToBeReplaced);
        while (index != -1 && index != name.length() - 1) {
            if (!Character.isUpperCase(name.charAt(index + 1))) {
                nameSb.setCharAt(index + 1, Character.toUpperCase(name.charAt(index + 1)));
            }
            index = name.indexOf(charToBeReplaced, index + 1);
        }
        name = nameSb.toString();
        name = name.replace("" + charToBeReplaced, "");
        return name;
    }

    private void writeConstructedTypeClass(String className, AsnType asnType, Tag tag, boolean asInternalClass, List<String> listOfSubClassNames) throws IOException {
        if (listOfSubClassNames == null) {
            listOfSubClassNames = new ArrayList<String>();
        }
        String isStaticStr = "";
        if (asInternalClass) {
            isStaticStr = " static";
        }
        if (asnType instanceof AsnSequenceSet) {
            this.writeSequenceOrSetClass(className, (AsnSequenceSet)asnType, tag, isStaticStr, listOfSubClassNames);
        } else if (asnType instanceof AsnSequenceOf) {
            this.writeSequenceOfClass(className, (AsnSequenceOf)asnType, tag, isStaticStr, listOfSubClassNames);
        } else if (asnType instanceof AsnChoice) {
            this.writeChoiceClass(className, (AsnChoice)asnType, tag, isStaticStr, listOfSubClassNames);
        }
    }

    private void writeChoiceClass(String className, AsnChoice asn1TypeElement, Tag tag, String isStaticStr, List<String> listOfSubClassNames) throws IOException {
        this.write("public" + isStaticStr + " class " + className + " implements " + this.berTypeInterfaceString + "Serializable {\n");
        this.write("private static final long serialVersionUID = 1L;\n");
        this.write("public byte[] code = null;");
        if (tag != null) {
            this.write("public static final BerTag tag = new BerTag(" + BerClassWriter.getBerTagParametersString(tag) + ");\n");
        }
        List<AsnElementType> componentTypes = asn1TypeElement.componentTypes;
        this.addAutomaticTagsIfNeeded(componentTypes);
        if (asn1TypeElement.parameters != null) {
            List parameters = asn1TypeElement.parameters;
            this.replaceParamtersByAnyTypes(componentTypes, parameters);
        }
        for (AsnElementType componentType : componentTypes) {
            if (componentType.typeReference == null || !(componentType.typeReference instanceof AsnConstructedType)) continue;
            listOfSubClassNames.add(this.getClassNameOfComponent(componentType));
        }
        for (AsnElementType componentType : componentTypes) {
            if (!this.isInnerType(componentType)) continue;
            String subClassName = this.getClassNameOfComponent(componentType);
            this.writeConstructedTypeClass(subClassName, componentType.typeReference, null, true, listOfSubClassNames);
        }
        this.setClassNamesOfComponents(listOfSubClassNames, componentTypes);
        this.writePublicMembers(componentTypes);
        this.writeEmptyConstructor(className);
        if (!this.jaxbMode) {
            this.writeEncodeConstructor(className, componentTypes);
        }
        if (this.jaxbMode) {
            this.writeGetterAndSetter(componentTypes);
        }
        this.writeChoiceEncodeFunction(componentTypes, tag != null);
        this.writeChoiceDecodeFunction(componentTypes, tag != null);
        this.writeEncodeAndSaveFunction(tag == null);
        this.writeChoiceToStringFunction(componentTypes);
        this.write("}\n");
    }

    private void setClassNamesOfComponents(List<String> listOfSubClassNames, List<AsnElementType> componentTypes) {
        for (AsnElementType element : componentTypes) {
            element.className = this.getClassNameOfComponent(listOfSubClassNames, element);
        }
    }

    private String getClassNameOfComponent(AsnElementType asnElementType) throws IOException {
        if (asnElementType.className != "") {
            return asnElementType.className;
        }
        return this.getClassNameOfComponent(null, asnElementType);
    }

    private String getClassNameOfComponent(List<String> listOfSubClassNames, AsnTaggedType element) {
        if (listOfSubClassNames == null) {
            listOfSubClassNames = new ArrayList<String>();
        }
        if (element.typeReference == null) {
            if (element.definedType.isObjectClassField) {
                AsnInformationObjectClass informationObjectClass = this.getInformationObjectClass(element.definedType.moduleOrObjectClassReference, this.module);
                if (informationObjectClass == null) {
                    throw new CompileException("no information object class of name \"" + element.definedType.moduleOrObjectClassReference + "\" found");
                }
                for (AsnElementType elementType : informationObjectClass.elementList) {
                    if (!elementType.name.equals(element.definedType.typeName)) continue;
                    return this.getClassNameOfComponent(listOfSubClassNames, elementType);
                }
                throw new IllegalStateException("Could not find field \"" + element.definedType.typeName + "\" of information object class \"" + element.definedType.moduleOrObjectClassReference + "\"");
            }
            String cleanedUpClassName = this.cleanUpName(element.definedType.typeName);
            for (String subClassName : listOfSubClassNames) {
                if (!subClassName.equals(cleanedUpClassName)) continue;
                String moduleName = this.module.moduleIdentifier.name;
                for (SymbolsFromModule syms : this.module.importSymbolFromModuleList) {
                    if (!syms.symbolList.contains(element.definedType.typeName)) continue;
                    moduleName = syms.modref;
                    break;
                }
                return this.basePackageName + this.sanitizeModuleName(moduleName).replace('-', '.').toLowerCase() + "." + cleanedUpClassName;
            }
            return cleanedUpClassName;
        }
        AsnType typeDefinition = element.typeReference;
        if (typeDefinition instanceof AsnConstructedType) {
            return this.cleanUpName(this.capitalizeFirstCharacter(element.name));
        }
        return this.getBerType(typeDefinition);
    }

    private AsnInformationObjectClass getInformationObjectClass(String objectClassReference, AsnModule module) {
        AsnInformationObjectClass ioClass = module.objectClassesByName.get(objectClassReference);
        if (ioClass == null) {
            AsnType asnType = module.typesByName.get(objectClassReference);
            if (asnType == null) {
                return null;
            }
            if (asnType instanceof AsnDefinedType) {
                return this.getInformationObjectClass(((AsnDefinedType)asnType).typeName, module);
            }
        }
        return ioClass;
    }

    private void writeSequenceOrSetClass(String className, AsnSequenceSet asnSequenceSet, Tag tag, String isStaticStr, List<String> listOfSubClassNames) throws IOException {
        this.write("public" + isStaticStr + " class " + className + " implements " + this.berTypeInterfaceString + "Serializable {\n");
        this.write("private static final long serialVersionUID = 1L;\n");
        List<AsnElementType> componentTypes = asnSequenceSet.componentTypes;
        this.addAutomaticTagsIfNeeded(componentTypes);
        if (asnSequenceSet.parameters != null) {
            Iterator<AsnElementType> parameters = asnSequenceSet.parameters;
            this.replaceParamtersByAnyTypes(componentTypes, (List<AsnParameter>)((Object)parameters));
        }
        for (AsnElementType componentType : componentTypes) {
            if (componentType.typeReference == null || !(componentType.typeReference instanceof AsnConstructedType)) continue;
            listOfSubClassNames.add(this.getClassNameOfComponent(componentType));
        }
        for (AsnElementType componentType : componentTypes) {
            if (!this.isInnerType(componentType)) continue;
            String subClassName = this.getClassNameOfComponent(componentType);
            this.writeConstructedTypeClass(subClassName, componentType.typeReference, null, true, listOfSubClassNames);
        }
        Tag mainTag = tag == null ? (asnSequenceSet.isSequence ? stdSeqTag : stdSetTag) : tag;
        this.write("public static final BerTag tag = new BerTag(" + BerClassWriter.getBerTagParametersString(mainTag) + ");\n");
        this.write("public byte[] code = null;");
        this.setClassNamesOfComponents(listOfSubClassNames, componentTypes);
        this.writePublicMembers(componentTypes);
        this.writeEmptyConstructor(className);
        if (!this.jaxbMode) {
            this.writeEncodeConstructor(className, componentTypes);
        }
        if (this.jaxbMode) {
            this.writeGetterAndSetter(componentTypes);
        }
        boolean hasExplicitTag = tag != null && tag.type == TagType.EXPLICIT;
        this.writeSimpleEncodeFunction();
        this.writeSequenceOrSetEncodeFunction(componentTypes, hasExplicitTag, asnSequenceSet.isSequence);
        this.writeSimpleDecodeFunction("true");
        if (asnSequenceSet.isSequence) {
            this.writeSequenceDecodeFunction(componentTypes, hasExplicitTag);
        } else {
            this.writeSetDecodeFunction(componentTypes);
        }
        this.writeEncodeAndSaveFunction();
        this.writeSequenceOrSetToStringFunction(componentTypes);
        this.write("}\n");
    }

    private void replaceParamtersByAnyTypes(List<AsnElementType> componentTypes, List<AsnParameter> parameters) {
        for (AsnParameter parameter : parameters) {
            if (parameter.paramGovernor != null) continue;
            for (AsnElementType componentType : componentTypes) {
                if (componentType.definedType == null || !componentType.definedType.typeName.equals(parameter.dummyReference)) continue;
                componentType.typeReference = new AsnAny();
                componentType.definedType = null;
                componentType.isDefinedType = false;
            }
        }
    }

    private void writeSimpleDecodeFunction(String param) throws IOException {
        this.write("public int decode(InputStream is) throws IOException {");
        this.write("return decode(is, " + param + ");");
        this.write("}\n");
    }

    private void writeSimpleEncodeFunction() throws IOException {
        this.write("public int encode(OutputStream reverseOS) throws IOException {");
        this.write("return encode(reverseOS, true);");
        this.write("}\n");
    }

    private void writeSequenceOfClass(String className, AsnSequenceOf asnSequenceOf, Tag tag, String isStaticStr, List<String> listOfSubClassNames) throws IOException {
        this.write("public" + isStaticStr + " class " + className + " implements " + this.berTypeInterfaceString + "Serializable {\n");
        this.write("private static final long serialVersionUID = 1L;\n");
        AsnElementType componentType = asnSequenceOf.componentType;
        String referencedTypeName = this.getClassNameOfSequenceOfElement(componentType, listOfSubClassNames);
        if (this.isInnerType(componentType)) {
            this.writeConstructedTypeClass(referencedTypeName, componentType.typeReference, null, true, listOfSubClassNames);
        }
        Tag mainTag = tag == null ? (asnSequenceOf.isSequenceOf ? stdSeqTag : stdSetTag) : tag;
        this.write("public static final BerTag tag = new BerTag(" + BerClassWriter.getBerTagParametersString(mainTag) + ");");
        this.write("public byte[] code = null;");
        if (this.jaxbMode) {
            this.write("private List<" + referencedTypeName + "> seqOf = null;\n");
        } else {
            this.write("public List<" + referencedTypeName + "> seqOf = null;\n");
        }
        this.write("public " + className + "() {");
        this.write("seqOf = new ArrayList<" + referencedTypeName + ">();");
        this.write("}\n");
        this.write("public " + className + "(byte[] code) {");
        this.write("this.code = code;");
        this.write("}\n");
        if (!this.jaxbMode) {
            this.write("public " + className + "(List<" + referencedTypeName + "> seqOf) {");
            this.write("this.seqOf = seqOf;");
            this.write("}\n");
        }
        if (this.jaxbMode) {
            this.writeGetterForSeqOf(referencedTypeName);
        }
        boolean hasExplicitTag = tag != null && tag.type == TagType.EXPLICIT;
        this.writeSimpleEncodeFunction();
        this.writeSequenceOfEncodeFunction(componentType, hasExplicitTag, asnSequenceOf.isSequenceOf);
        this.writeSimpleDecodeFunction("true");
        this.writeSequenceOrSetOfDecodeFunction(componentType, referencedTypeName, hasExplicitTag, asnSequenceOf.isSequenceOf);
        this.writeEncodeAndSaveFunction();
        this.writeSequenceOrSetOfToStringFunction(referencedTypeName, componentType);
        this.write("}\n");
    }

    private void writeRetaggingTypeClass(String typeName, String assignedTypeName, AsnType typeDefinition, Tag tag) throws IOException {
        this.write("public class " + typeName + " extends " + this.cleanUpName(assignedTypeName) + " {\n");
        this.write("private static final long serialVersionUID = 1L;\n");
        if (tag != null) {
            this.write("public static final BerTag tag = new BerTag(" + BerClassWriter.getBerTagParametersString(tag) + ");\n");
            if (tag.type == TagType.EXPLICIT) {
                this.write("public byte[] code = null;\n");
            }
        }
        this.write("public " + typeName + "() {");
        this.write("}\n");
        String[] constructorParameters = this.getConstructorParameters(this.getUniversalType(typeDefinition));
        if (constructorParameters.length != 2 || constructorParameters[0] != "byte[]") {
            this.write("public " + typeName + "(byte[] code) {");
            this.write("super(code);");
            this.write("}\n");
        }
        if ((!this.jaxbMode || this.isPrimitiveOrRetaggedPrimitive(typeDefinition)) && constructorParameters.length != 0) {
            String constructorParameterString = "";
            String superCallParameterString = "";
            for (int i = 0; i < constructorParameters.length; i += 2) {
                if (i > 0) {
                    constructorParameterString = constructorParameterString + ", ";
                    superCallParameterString = superCallParameterString + ", ";
                }
                constructorParameterString = constructorParameterString + constructorParameters[i] + " " + constructorParameters[i + 1];
                superCallParameterString = superCallParameterString + constructorParameters[i + 1];
            }
            this.write("public " + typeName + "(" + constructorParameterString + ") {");
            this.write("super(" + superCallParameterString + ");");
            this.write("}\n");
            if (constructorParameters[0].equals("BigInteger")) {
                this.write("public " + typeName + "(long value) {");
                this.write("super(value);");
                this.write("}\n");
            } else if (constructorParameters.length == 4 && constructorParameters[3].equals("numBits")) {
                this.write("public " + typeName + "(boolean[] value) {");
                this.write("super(value);");
                this.write("}\n");
            }
        }
        if (tag != null) {
            if (this.isDirectAnyOrChoice((AsnTaggedType)typeDefinition)) {
                this.writeSimpleEncodeFunction();
            }
            this.write("public int encode(OutputStream reverseOS, boolean withTag) throws IOException {\n");
            if (constructorParameters.length != 2 || constructorParameters[0] != "byte[]") {
                this.write("if (code != null) {");
                this.write("for (int i = code.length - 1; i >= 0; i--) {");
                this.write("reverseOS.write(code[i]);");
                this.write("}");
                this.write("if (withTag) {");
                this.write("return tag.encode(reverseOS) + code.length;");
                this.write("}");
                this.write("return code.length;");
                this.write("}\n");
            }
            this.write("int codeLength;\n");
            if (tag.type == TagType.EXPLICIT) {
                if (this.isDirectAnyOrChoice((AsnTaggedType)typeDefinition)) {
                    this.write("codeLength = super.encode(reverseOS);");
                } else {
                    this.write("codeLength = super.encode(reverseOS, true);");
                }
                this.write("codeLength += BerLength.encodeLength(reverseOS, codeLength);");
            } else {
                this.write("codeLength = super.encode(reverseOS, false);");
            }
            this.write("if (withTag) {");
            this.write("codeLength += tag.encode(reverseOS);");
            this.write("}\n");
            this.write("return codeLength;");
            this.write("}\n");
            if (this.isDirectAnyOrChoice((AsnTaggedType)typeDefinition)) {
                this.writeSimpleDecodeFunction("true");
            }
            this.write("public int decode(InputStream is, boolean withTag) throws IOException {\n");
            this.write("int codeLength = 0;\n");
            this.write("if (withTag) {");
            this.write("codeLength += tag.decodeAndCheck(is);");
            this.write("}\n");
            if (tag.type == TagType.EXPLICIT) {
                this.write("BerLength length = new BerLength();");
                this.write("codeLength += length.decode(is);\n");
                if (this.isDirectAnyOrChoice((AsnTaggedType)typeDefinition)) {
                    this.write("codeLength += super.decode(is, null);\n");
                } else {
                    this.write("codeLength += super.decode(is, true);\n");
                }
            } else {
                this.write("codeLength += super.decode(is, false);\n");
            }
            this.write("return codeLength;");
            this.write("}\n");
        }
        this.write("}");
    }

    private void writeChoiceEncodeFunction(List<AsnElementType> componentTypes, boolean hasExplicitTag) throws IOException {
        int j;
        if (hasExplicitTag) {
            this.writeSimpleEncodeFunction();
            this.write("public int encode(OutputStream reverseOS, boolean withTag) throws IOException {\n");
        } else {
            this.write("public int encode(OutputStream reverseOS) throws IOException {\n");
        }
        this.write("if (code != null) {");
        this.write("for (int i = code.length - 1; i >= 0; i--) {");
        this.write("reverseOS.write(code[i]);");
        this.write("}");
        if (hasExplicitTag) {
            this.write("if (withTag) {");
            this.write("return tag.encode(reverseOS) + code.length;");
            this.write("}");
        }
        this.write("return code.length;");
        this.write("}\n");
        this.write("int codeLength = 0;");
        for (j = componentTypes.size() - 1; j >= 0; --j) {
            if (!this.isExplicit(this.getTag(componentTypes.get(j)))) continue;
            this.write("int sublength;\n");
            break;
        }
        for (j = componentTypes.size() - 1; j >= 0; --j) {
            AsnElementType componentType = componentTypes.get(j);
            Tag componentTag = this.getTag(componentType);
            this.write("if (" + this.getName(componentType) + " != null) {");
            String explicitEncoding = this.getExplicitEncodingParameter(componentType);
            if (this.isExplicit(componentTag)) {
                this.write("sublength = " + this.getName(componentType) + ".encode(reverseOS" + explicitEncoding + ");");
                this.write("codeLength += sublength;");
                this.write("codeLength += BerLength.encodeLength(reverseOS, sublength);");
            } else {
                this.write("codeLength += " + this.getName(componentType) + ".encode(reverseOS" + explicitEncoding + ");");
            }
            if (componentTag != null) {
                this.writeEncodeTag(componentTag);
            }
            if (hasExplicitTag) {
                this.write("codeLength += BerLength.encodeLength(reverseOS, codeLength);");
                this.write("if (withTag) {");
                this.write("codeLength += tag.encode(reverseOS);");
                this.write("}");
            }
            this.write("return codeLength;");
            this.write("}");
            this.write("");
        }
        this.write("throw new IOException(\"Error encoding CHOICE: No element of CHOICE was selected.\");");
        this.write("}\n");
    }

    private void writeSequenceOrSetEncodeFunction(List<AsnElementType> componentTypes, boolean hasExplicitTag, boolean isSequence) throws IOException {
        int j;
        this.write("public int encode(OutputStream reverseOS, boolean withTag) throws IOException {\n");
        this.write("if (code != null) {");
        this.write("for (int i = code.length - 1; i >= 0; i--) {");
        this.write("reverseOS.write(code[i]);");
        this.write("}");
        this.write("if (withTag) {");
        this.write("return tag.encode(reverseOS) + code.length;");
        this.write("}");
        this.write("return code.length;");
        this.write("}\n");
        this.write("int codeLength = 0;");
        for (j = componentTypes.size() - 1; j >= 0; --j) {
            if (!this.isExplicit(this.getTag(componentTypes.get(j)))) continue;
            this.write("int sublength;\n");
            break;
        }
        for (j = componentTypes.size() - 1; j >= 0; --j) {
            AsnElementType componentType = componentTypes.get(j);
            Tag componentTag = this.getTag(componentType);
            if (this.isOptional(componentType)) {
                this.write("if (" + this.getName(componentType) + " != null) {");
            }
            String explicitEncoding = this.getExplicitEncodingParameter(componentType);
            if (this.isExplicit(componentTag)) {
                this.write("sublength = " + this.getName(componentType) + ".encode(reverseOS" + explicitEncoding + ");");
                this.write("codeLength += sublength;");
                this.write("codeLength += BerLength.encodeLength(reverseOS, sublength);");
            } else {
                this.write("codeLength += " + this.getName(componentType) + ".encode(reverseOS" + explicitEncoding + ");");
            }
            if (componentTag != null) {
                this.writeEncodeTag(componentTag);
            }
            if (this.isOptional(componentType)) {
                this.write("}");
            }
            this.write("");
        }
        if (hasExplicitTag) {
            this.write("codeLength += BerLength.encodeLength(reverseOS, codeLength);");
            if (isSequence) {
                this.write("reverseOS.write(0x30);");
            } else {
                this.write("reverseOS.write(0x31);");
            }
            this.write("codeLength++;\n");
        }
        this.write("codeLength += BerLength.encodeLength(reverseOS, codeLength);\n");
        this.write("if (withTag) {");
        this.write("codeLength += tag.encode(reverseOS);");
        this.write("}\n");
        this.write("return codeLength;\n");
        this.write("}\n");
    }

    private void writeSequenceOfEncodeFunction(AsnElementType componentType, boolean hasExplicitTag, boolean isSequence) throws IOException {
        this.write("public int encode(OutputStream reverseOS, boolean withTag) throws IOException {\n");
        this.write("if (code != null) {");
        this.write("for (int i = code.length - 1; i >= 0; i--) {");
        this.write("reverseOS.write(code[i]);");
        this.write("}");
        this.write("if (withTag) {");
        this.write("return tag.encode(reverseOS) + code.length;");
        this.write("}");
        this.write("return code.length;");
        this.write("}\n");
        this.write("int codeLength = 0;");
        this.write("for (int i = (seqOf.size() - 1); i >= 0; i--) {");
        Tag componentTag = this.getTag(componentType);
        String explicitEncoding = this.getExplicitEncodingParameter(componentType);
        if (componentTag != null) {
            if (componentTag.type == TagType.EXPLICIT) {
                this.write("int sublength = seqOf.get(i).encode(reverseOS" + explicitEncoding + ");");
                this.write("codeLength += sublength;");
                this.write("codeLength += BerLength.encodeLength(reverseOS, sublength);");
            } else {
                this.write("codeLength += seqOf.get(i).encode(reverseOS" + explicitEncoding + ");");
            }
            if (componentTag != null) {
                this.writeEncodeTag(componentTag);
            }
        } else if (this.isDirectAnyOrChoice(componentType)) {
            this.write("codeLength += seqOf.get(i).encode(reverseOS);");
        } else {
            this.write("codeLength += seqOf.get(i).encode(reverseOS, true);");
        }
        this.write("}\n");
        if (hasExplicitTag) {
            this.write("codeLength += BerLength.encodeLength(reverseOS, codeLength);");
            if (isSequence) {
                this.write("reverseOS.write(0x30);");
            } else {
                this.write("reverseOS.write(0x31);");
            }
            this.write("codeLength++;\n");
        }
        this.write("codeLength += BerLength.encodeLength(reverseOS, codeLength);\n");
        this.write("if (withTag) {");
        this.write("codeLength += tag.encode(reverseOS);");
        this.write("}\n");
        this.write("return codeLength;");
        this.write("}\n");
    }

    private String getExplicitEncodingParameter(AsnTaggedType componentType) throws IOException {
        Tag tag = this.getTag(componentType);
        if (tag != null && tag.type == TagType.IMPLICIT) {
            return ", false";
        }
        if (this.isDirectAnyOrChoice(componentType)) {
            return "";
        }
        return ", true";
    }

    private void writeChoiceDecodeFunction(List<AsnElementType> componentTypes, boolean hasExplicitTag) throws IOException {
        if (hasExplicitTag) {
            this.writeSimpleDecodeFunction("true");
            this.write("public int decode(InputStream is, boolean withTag) throws IOException {");
            this.write("int codeLength = 0;");
            this.write("BerLength length = new BerLength();");
            this.write("BerTag berTag = new BerTag();\n");
            this.write("if (withTag) {");
            this.write("codeLength += tag.decodeAndCheck(is);");
            this.write("}\n");
            this.write("codeLength += length.decode(is);");
            this.write("codeLength += berTag.decode(is);\n");
        } else {
            this.writeSimpleDecodeFunction("null");
            this.write("public int decode(InputStream is, BerTag berTag) throws IOException {\n");
            this.write("int codeLength = 0;");
            this.write("BerTag passedTag = berTag;\n");
            this.write("if (berTag == null) {");
            this.write("berTag = new BerTag();");
            this.write("codeLength += berTag.decode(is);");
            this.write("}\n");
        }
        String initChoiceDecodeLength = "int ";
        for (int j = 0; j < componentTypes.size(); ++j) {
            AsnElementType componentType = componentTypes.get(j);
            String explicitEncoding = this.getExplicitDecodingParameter(componentType);
            Tag componentTag = this.getTag(componentType);
            if (componentTag != null) {
                this.write("if (berTag.equals(" + BerClassWriter.getBerTagParametersString(componentTag) + ")) {");
                if (componentTag.type == TagType.EXPLICIT) {
                    this.write("codeLength += BerLength.skip(is);");
                }
                this.write(this.getName(componentType) + " = new " + this.getClassNameOfComponent(componentType) + "();");
                this.write("codeLength += " + this.getName(componentType) + ".decode(is" + explicitEncoding + ");");
                this.write("return codeLength;");
                this.write("}\n");
                continue;
            }
            if (this.isDirectAnyOrChoice(componentType)) {
                this.write(this.getName(componentType) + " = new " + this.getClassNameOfComponent(componentType) + "();");
                this.write(initChoiceDecodeLength + "choiceDecodeLength = " + this.getName(componentType) + ".decode(is" + explicitEncoding + ");");
                initChoiceDecodeLength = "";
                this.write("if (choiceDecodeLength != 0) {");
                this.write("return codeLength + choiceDecodeLength;");
                this.write("}");
                this.write("else {");
                this.write(this.getName(componentType) + " = null;");
                this.write("}\n");
                continue;
            }
            this.write("if (berTag.equals(" + this.getClassNameOfComponent(componentType) + ".tag)) {");
            this.write(this.getName(componentType) + " = new " + this.getClassNameOfComponent(componentType) + "();");
            this.write("codeLength += " + this.getName(componentType) + ".decode(is" + explicitEncoding + ");");
            this.write("return codeLength;");
            this.write("}\n");
        }
        if (!hasExplicitTag) {
            this.write("if (passedTag != null) {");
            this.write("return 0;");
            this.write("}\n");
        }
        this.write("throw new IOException(\"Error decoding CHOICE: Tag \" + berTag + \" matched to no item.\");");
        this.write("}\n");
    }

    private void writeSequenceDecodeFunction(List<AsnElementType> componentTypes, boolean hasExplicitTag) throws IOException {
        this.write("public int decode(InputStream is, boolean withTag) throws IOException {");
        this.write("int codeLength = 0;");
        this.write("int subCodeLength = 0;");
        this.write("BerTag berTag = new BerTag();\n");
        this.write("if (withTag) {");
        this.write("codeLength += tag.decodeAndCheck(is);");
        this.write("}\n");
        this.write("BerLength length = new BerLength();");
        this.write("codeLength += length.decode(is);\n");
        this.write("int totalLength = length.val;");
        if (this.supportIndefiniteLength) {
            this.writeSequenceDecodeIndefiniteLenghtPart(componentTypes);
        }
        this.write("codeLength += totalLength;\n");
        if (hasExplicitTag) {
            this.write("int nextByte = is.read();");
            this.write("if (nextByte == -1) {");
            this.write("throw new EOFException(\"Unexpected end of input stream.\");");
            this.write("}");
            this.write("if (nextByte != (0x30)) {");
            this.write("throw new IOException(\"Tag does not match!\");");
            this.write("}");
            this.write("length.decode(is);");
            this.write("totalLength = length.val;\n");
        }
        int lastNoneOptionalFieldIndex = -1;
        for (int j = 0; j < componentTypes.size(); ++j) {
            AsnElementType componentType = componentTypes.get(componentTypes.size() - 1 - j);
            if (this.isOptional(componentType)) continue;
            lastNoneOptionalFieldIndex = componentTypes.size() - 1 - j;
            break;
        }
        if (lastNoneOptionalFieldIndex == -1) {
            this.write("if (totalLength == 0) {");
            this.write("return codeLength;");
            this.write("}");
        }
        this.write("subCodeLength += berTag.decode(is);");
        String initChoiceDecodeLength = "int ";
        for (int j = 0; j < componentTypes.size(); ++j) {
            AsnElementType componentType = componentTypes.get(j);
            String explicitEncoding = this.getExplicitDecodingParameter(componentType);
            Tag componentTag = this.getTag(componentType);
            if (componentTag != null) {
                this.write("if (berTag.equals(" + BerClassWriter.getBerTagParametersString(componentTag) + ")) {");
                if (this.isExplicit(componentTag)) {
                    this.write("subCodeLength += length.decode(is);");
                }
                this.write(this.getName(componentType) + " = new " + this.getClassNameOfComponent(componentType) + "();");
                this.write("subCodeLength += " + this.getName(componentType) + ".decode(is" + explicitEncoding + ");");
                if (lastNoneOptionalFieldIndex <= j) {
                    this.write("if (subCodeLength == totalLength) {");
                    this.write("return codeLength;");
                    this.write("}");
                }
                if (j != componentTypes.size() - 1) {
                    this.write("subCodeLength += berTag.decode(is);");
                }
                this.write("}");
                if (j == componentTypes.size() - 1) {
                    this.write("throw new IOException(\"Unexpected end of sequence, length tag: \" + totalLength + \", actual sequence length: \" + subCodeLength);\n");
                } else if (!this.isOptional(componentType)) {
                    this.write("else {");
                    this.write("throw new IOException(\"Tag does not match the mandatory sequence element tag.\");");
                    this.write("}");
                }
            } else if (this.isDirectAnyOrChoice(componentType)) {
                this.write(this.getName(componentType) + " = new " + this.getClassNameOfComponent(componentType) + "();");
                if (this.isOptional(componentType)) {
                    this.write(initChoiceDecodeLength + "choiceDecodeLength = " + this.getName(componentType) + ".decode(is" + explicitEncoding + ");");
                    initChoiceDecodeLength = "";
                    if (j != componentTypes.size() - 1) {
                        this.write("if (choiceDecodeLength != 0) {");
                        this.write("subCodeLength += choiceDecodeLength;");
                        if (lastNoneOptionalFieldIndex <= j) {
                            this.write("if (subCodeLength == totalLength) {");
                            this.write("return codeLength;");
                            this.write("}");
                        }
                        this.write("subCodeLength += berTag.decode(is);");
                        this.write("}");
                        this.write("else {");
                        this.write(this.getName(componentType) + " = null;");
                        this.write("}");
                    } else {
                        this.write("subCodeLength += choiceDecodeLength;");
                        this.write("if (subCodeLength == totalLength) {");
                        this.write("return codeLength;");
                        this.write("}");
                    }
                } else {
                    this.write("subCodeLength += " + this.getName(componentType) + ".decode(is" + explicitEncoding + ");");
                    if (j != componentTypes.size() - 1) {
                        if (lastNoneOptionalFieldIndex <= j) {
                            this.write("if (subCodeLength == totalLength) {");
                            this.write("return codeLength;");
                            this.write("}");
                        }
                        this.write("subCodeLength += berTag.decode(is);");
                    } else {
                        this.write("if (subCodeLength == totalLength) {");
                        this.write("return codeLength;");
                        this.write("}");
                    }
                }
                if (j == componentTypes.size() - 1) {
                    this.write("throw new IOException(\"Unexpected end of sequence, length tag: \" + totalLength + \", actual sequence length: \" + subCodeLength);\n");
                }
            } else {
                this.write("if (berTag.equals(" + this.getClassNameOfComponent(componentType) + ".tag)) {");
                this.write(this.getName(componentType) + " = new " + this.getClassNameOfComponent(componentType) + "();");
                this.write("subCodeLength += " + this.getName(componentType) + ".decode(is" + explicitEncoding + ");");
                if (lastNoneOptionalFieldIndex <= j) {
                    this.write("if (subCodeLength == totalLength) {");
                    this.write("return codeLength;");
                    this.write("}");
                }
                if (j != componentTypes.size() - 1) {
                    this.write("subCodeLength += berTag.decode(is);");
                }
                this.write("}");
                if (j == componentTypes.size() - 1) {
                    this.write("throw new IOException(\"Unexpected end of sequence, length tag: \" + totalLength + \", actual sequence length: \" + subCodeLength);\n");
                } else if (!this.isOptional(componentType)) {
                    this.write("else {");
                    this.write("throw new IOException(\"Tag does not match the mandatory sequence element tag.\");");
                    this.write("}");
                }
            }
            this.write("");
        }
        if (componentTypes.isEmpty()) {
            this.write("return subCodeLength;");
        }
        this.write("}\n");
    }

    private void writeSequenceOrSetOfDecodeFunction(AsnElementType componentType, String classNameOfSequenceOfElement, boolean hasExplicitTag, boolean isSequence) throws IOException {
        Tag componentTag = this.getTag(componentType);
        this.write("public int decode(InputStream is, boolean withTag) throws IOException {");
        this.write("int codeLength = 0;");
        this.write("int subCodeLength = 0;");
        if (componentTag != null || this.supportIndefiniteLength) {
            this.write("BerTag berTag = new BerTag();");
        }
        this.write("if (withTag) {");
        this.write("codeLength += tag.decodeAndCheck(is);");
        this.write("}\n");
        this.write("BerLength length = new BerLength();");
        this.write("codeLength += length.decode(is);");
        this.write("int totalLength = length.val;\n");
        if (this.supportIndefiniteLength) {
            this.writeSequenceOfDecodeIndefiniteLenghtPart(componentType, classNameOfSequenceOfElement, hasExplicitTag);
        }
        if (hasExplicitTag) {
            this.write("int nextByte = is.read();");
            this.write("if (nextByte == -1) {");
            this.write("throw new EOFException(\"Unexpected end of input stream.\");");
            this.write("}");
            if (isSequence) {
                this.write("if (nextByte != (0x30)) {");
            } else {
                this.write("if (nextByte != (0x31)) {");
            }
            this.write("throw new IOException(\"Tag does not match!\");");
            this.write("}");
            this.write("length.decode(is);");
            this.write("totalLength = length.val;\n");
        }
        this.write("while (subCodeLength < totalLength) {");
        this.write(classNameOfSequenceOfElement + " element = new " + classNameOfSequenceOfElement + "();");
        String explicitEncoding = this.getExplicitDecodingParameter(componentType);
        if (componentTag != null) {
            if (componentTag.type == TagType.EXPLICIT) {
                this.write("subCodeLength += berTag.decode(is);");
                this.write("subCodeLength += length.decode(is);");
                explicitEncoding = ", true";
            } else {
                this.write("subCodeLength += berTag.decode(is);");
                explicitEncoding = this.isDirectAnyOrChoice(componentType) ? ", berTag" : ", false";
            }
            this.write("subCodeLength += element.decode(is" + explicitEncoding + ");");
        } else if (this.isDirectAnyOrChoice(componentType)) {
            this.write("subCodeLength += element.decode(is, null);");
        } else {
            this.write("subCodeLength += element.decode(is, true);");
        }
        this.write("seqOf.add(element);");
        this.write("}");
        this.write("if (subCodeLength != totalLength) {");
        this.write("throw new IOException(\"Decoded SequenceOf or SetOf has wrong length. Expected \" + totalLength + \" but has \" + subCodeLength);\n");
        this.write("}");
        this.write("codeLength += subCodeLength;\n");
        this.write("return codeLength;");
        this.write("}\n");
    }

    private static String getBerTagParametersString(Tag tag) {
        return "BerTag." + (Object)((Object)tag.tagClass) + "_CLASS, BerTag." + tag.typeStructure.toString() + ", " + tag.value;
    }

    private void writeToStringFunction() throws IOException {
        this.write("public String toString() {");
        this.write("StringBuilder sb = new StringBuilder();");
        this.write("appendAsString(sb, 0);");
        this.write("return sb.toString();");
        this.write("}\n");
    }

    private void writeChoiceToStringFunction(List<AsnElementType> componentTypes) throws IOException {
        this.writeToStringFunction();
        this.write("public void appendAsString(StringBuilder sb, int indentLevel) {\n");
        for (int j = 0; j < componentTypes.size(); ++j) {
            AsnElementType componentType = componentTypes.get(j);
            this.write("if (" + this.getName(componentType) + " != null) {");
            if (!this.isPrimitive(this.getUniversalType(componentType))) {
                this.write("sb.append(\"" + this.getName(componentType) + ": \");");
                this.write(this.getName(componentType) + ".appendAsString(sb, indentLevel + 1);");
            } else {
                this.write("sb.append(\"" + this.getName(componentType) + ": \").append(" + this.getName(componentType) + ");");
            }
            this.write("return;");
            this.write("}\n");
        }
        this.write("sb.append(\"<none>\");");
        this.write("}\n");
    }

    private void writeSequenceOrSetToStringFunction(List<AsnElementType> componentTypes) throws IOException {
        this.writeToStringFunction();
        this.write("public void appendAsString(StringBuilder sb, int indentLevel) {\n");
        this.write("sb.append(\"{\");");
        boolean checkIfFirstSelectedElement = componentTypes.size() > 1;
        int j = 0;
        for (AsnElementType componentType : componentTypes) {
            if (this.isOptional(componentType)) {
                if (j == 0 && componentTypes.size() > 1) {
                    this.write("boolean firstSelectedElement = true;");
                }
                this.write("if (" + this.getName(componentType) + " != null) {");
            }
            if (j != 0) {
                if (checkIfFirstSelectedElement) {
                    this.write("if (!firstSelectedElement) {");
                }
                this.write("sb.append(\",\\n\");");
                if (checkIfFirstSelectedElement) {
                    this.write("}");
                }
            } else {
                this.write("sb.append(\"\\n\");");
            }
            this.write("for (int i = 0; i < indentLevel + 1; i++) {");
            this.write("sb.append(\"\\t\");");
            this.write("}");
            if (!this.isOptional(componentType)) {
                this.write("if (" + this.getName(componentType) + " != null) {");
            }
            if (!this.isPrimitive(this.getUniversalType(componentType))) {
                this.write("sb.append(\"" + this.getName(componentType) + ": \");");
                this.write(this.getName(componentType) + ".appendAsString(sb, indentLevel + 1);");
            } else {
                this.write("sb.append(\"" + this.getName(componentType) + ": \").append(" + this.getName(componentType) + ");");
            }
            if (!this.isOptional(componentType)) {
                this.write("}");
                this.write("else {");
                this.write("sb.append(\"" + this.getName(componentType) + ": <empty-required-field>\");");
                this.write("}");
            }
            if (this.isOptional(componentType)) {
                if (checkIfFirstSelectedElement) {
                    this.write("firstSelectedElement = false;");
                }
                this.write("}");
            } else {
                checkIfFirstSelectedElement = false;
            }
            this.write("");
            ++j;
        }
        this.write("sb.append(\"\\n\");");
        this.write("for (int i = 0; i < indentLevel; i++) {");
        this.write("sb.append(\"\\t\");");
        this.write("}");
        this.write("sb.append(\"}\");");
        this.write("}\n");
    }

    private void writeSequenceOrSetOfToStringFunction(String referencedTypeName, AsnElementType componentType) throws IOException {
        this.writeToStringFunction();
        this.write("public void appendAsString(StringBuilder sb, int indentLevel) {\n");
        this.write("sb.append(\"{\\n\");");
        this.write("for (int i = 0; i < indentLevel + 1; i++) {");
        this.write("sb.append(\"\\t\");");
        this.write("}");
        this.write("if (seqOf == null) {");
        this.write("sb.append(\"null\");");
        this.write("}");
        this.write("else {");
        this.write("Iterator<" + referencedTypeName + "> it = seqOf.iterator();");
        this.write("if (it.hasNext()) {");
        if (!this.isPrimitive(this.getUniversalType(componentType))) {
            this.write("it.next().appendAsString(sb, indentLevel + 1);");
        } else {
            this.write("sb.append(it.next());");
        }
        this.write("while (it.hasNext()) {");
        this.write("sb.append(\",\\n\");");
        this.write("for (int i = 0; i < indentLevel + 1; i++) {");
        this.write("sb.append(\"\\t\");");
        this.write("}");
        if (!this.isPrimitive(this.getUniversalType(componentType))) {
            this.write("it.next().appendAsString(sb, indentLevel + 1);");
        } else {
            this.write("sb.append(it.next());");
        }
        this.write("}");
        this.write("}");
        this.write("}\n");
        this.write("sb.append(\"\\n\");");
        this.write("for (int i = 0; i < indentLevel; i++) {");
        this.write("sb.append(\"\\t\");");
        this.write("}");
        this.write("sb.append(\"}\");");
        this.write("}\n");
    }

    private String getExplicitDecodingParameter(AsnElementType componentType) throws IOException {
        Tag tag = this.getTag(componentType);
        String explicitEncoding = tag != null && tag.type == TagType.EXPLICIT ? (this.isDirectAnyOrChoice(componentType) ? ", null" : ", true") : (this.isDirectAnyOrChoice(componentType) ? ", berTag" : ", false");
        return explicitEncoding;
    }

    private void writeSequenceOfDecodeIndefiniteLenghtPart(AsnElementType componentType, String classNameOfSequenceOfElement, boolean isTagExplicit) throws IOException {
        this.write("if (length.val == -1) {");
        this.write("while (true) {");
        this.write("subCodeLength += berTag.decode(is);\n");
        this.write("if (berTag.tagNumber == 0 && berTag.tagClass == 0 && berTag.primitive == 0) {");
        this.write("int nextByte = is.read();");
        this.write("if (nextByte != 0) {");
        this.write("if (nextByte == -1) {");
        this.write("throw new EOFException(\"Unexpected end of input stream.\");");
        this.write("}");
        this.write("throw new IOException(\"Decoded sequence has wrong end of contents octets\");");
        this.write("}");
        this.write("codeLength += subCodeLength + 1;");
        this.write("return codeLength;");
        this.write("}\n");
        this.write(classNameOfSequenceOfElement + " element = new " + classNameOfSequenceOfElement + "();");
        if (this.isDirectAnyOrChoice(componentType)) {
            this.write("subCodeLength += element.decode(is, berTag);");
        } else {
            this.write("subCodeLength += element.decode(is, false);");
        }
        this.write("seqOf.add(element);");
        this.write("}");
        this.write("}");
    }

    private void addAutomaticTagsIfNeeded(List<AsnElementType> componentTypes) throws IOException {
        if (this.tagDefault != AsnModule.TagDefault.AUTOMATIC) {
            return;
        }
        for (AsnElementType element : componentTypes) {
            if (this.getTag(element) == null) continue;
            return;
        }
        int i = 0;
        for (AsnElementType element : componentTypes) {
            element.tag = new AsnTag();
            element.tag.classNumber = new AsnClassNumber();
            element.tag.classNumber.num = i;
            ++i;
        }
    }

    private void writeEncodeAndSaveFunction() throws IOException {
        this.writeEncodeAndSaveFunction(false);
    }

    private void writeEncodeAndSaveFunction(boolean isTagless) throws IOException {
        this.write("public void encodeAndSave(int encodingSizeGuess) throws IOException {");
        this.write("ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);");
        if (isTagless) {
            this.write("encode(reverseOS);");
        } else {
            this.write("encode(reverseOS, false);");
        }
        this.write("code = reverseOS.getArray();");
        this.write("}\n");
    }

    private void writeSetDecodeFunction(List<AsnElementType> componentTypes) throws IOException {
        this.write("public int decode(InputStream is, boolean withTag) throws IOException {");
        this.write("int codeLength = 0;");
        this.write("int subCodeLength = 0;");
        this.write("BerTag berTag = new BerTag();\n");
        this.write("if (withTag) {");
        this.write("codeLength += tag.decodeAndCheck(is);");
        this.write("}\n");
        this.write("BerLength length = new BerLength();");
        this.write("codeLength += length.decode(is);\n");
        this.write("int totalLength = length.val;");
        if (this.supportIndefiniteLength) {
            this.writeSetDecodeIndefiniteLenghtPart(componentTypes);
        }
        this.write("while (subCodeLength < totalLength) {");
        this.write("subCodeLength += berTag.decode(is);");
        for (int j = 0; j < componentTypes.size(); ++j) {
            AsnElementType componentType = componentTypes.get(j);
            Tag componentTag = this.getTag(componentType);
            String explicitEncoding = ", false";
            String elseString = "";
            if (j != 0) {
                elseString = "else ";
            }
            if (this.isDirectAnyOrChoice(componentType)) {
                if (!this.isExplicit(componentTag)) {
                    throw new IOException("choice or ANY within set has no explicit tag.");
                }
                this.write(elseString + "if (berTag.equals(" + BerClassWriter.getBerTagParametersString(componentTag) + ")) {");
                this.write("subCodeLength += new BerLength().decode(is);");
                explicitEncoding = ", null";
                this.write(this.getName(componentType) + " = new " + this.getClassNameOfComponent(componentType) + "();");
                this.write("subCodeLength += " + this.getName(componentType) + ".decode(is" + explicitEncoding + ");");
                this.write("}");
                continue;
            }
            if (componentTag != null) {
                if (this.isExplicit(componentTag)) {
                    this.write(elseString + "if (berTag.equals(" + BerClassWriter.getBerTagParametersString(componentTag) + ")) {");
                } else {
                    this.write(elseString + "if (berTag.equals(" + BerClassWriter.getBerTagParametersString(componentTag) + ")) {");
                }
                if (this.isExplicit(componentTag)) {
                    this.write("subCodeLength += new BerLength().decode(is);");
                    explicitEncoding = ", true";
                }
            } else {
                this.write(elseString + "if (berTag.equals(" + this.getClassNameOfComponent(componentType) + ".tag)) {");
            }
            this.write(this.getName(componentType) + " = new " + this.getClassNameOfComponent(componentType) + "();");
            if (", null".equals(explicitEncoding)) {
                this.write("BerLength length2 = new BerLength();");
                this.write("subCodeLength += length2.decode(is);");
            }
            this.write("subCodeLength += " + this.getName(componentType) + ".decode(is" + explicitEncoding + ");");
            this.write("}");
        }
        this.write("}");
        this.write("if (subCodeLength != totalLength) {");
        this.write("throw new IOException(\"Length of set does not match length tag, length tag: \" + totalLength + \", actual set length: \" + subCodeLength);\n");
        this.write("}");
        this.write("codeLength += subCodeLength;\n");
        this.write("return codeLength;");
        this.write("}\n");
    }

    private void writeSequenceDecodeIndefiniteLenghtPart(List<AsnElementType> componentTypes) throws IOException {
        this.write("if (totalLength == -1) {");
        this.write("subCodeLength += berTag.decode(is);\n");
        String initChoiceDecodeLength = "int ";
        for (AsnElementType componentType : componentTypes) {
            String explicitEncoding;
            Tag componentTag = this.getTag(componentType);
            this.write("if (berTag.tagNumber == 0 && berTag.tagClass == 0 && berTag.primitive == 0) {");
            this.write("int nextByte = is.read();");
            this.write("if (nextByte != 0) {");
            this.write("if (nextByte == -1) {");
            this.write("throw new EOFException(\"Unexpected end of input stream.\");");
            this.write("}");
            this.write("throw new IOException(\"Decoded sequence has wrong end of contents octets\");");
            this.write("}");
            this.write("codeLength += subCodeLength + 1;");
            this.write("return codeLength;");
            this.write("}");
            if (this.isDirectAnyOrChoice(componentType)) {
                if (this.isExplicit(componentTag)) {
                    this.write("if (berTag.equals(" + BerClassWriter.getBerTagParametersString(componentTag) + ")) {");
                    this.write("subCodeLength += length.decode(is);");
                    explicitEncoding = "null";
                } else {
                    explicitEncoding = "berTag";
                }
                this.write(this.getName(componentType) + " = new " + this.getClassNameOfComponent(componentType) + "();");
                this.write(initChoiceDecodeLength + "choiceDecodeLength = " + this.getName(componentType) + ".decode(is, " + explicitEncoding + ");");
                if (!this.isExplicit(componentTag)) {
                    initChoiceDecodeLength = "";
                }
                this.write("if (choiceDecodeLength != 0) {");
                this.write("subCodeLength += choiceDecodeLength;");
                this.write("subCodeLength += berTag.decode(is);");
                this.write("}");
                this.write("else {");
                this.write(this.getName(componentType) + " = null;");
                this.write("}\n");
                if (!this.isExplicit(componentTag)) continue;
                this.write("}");
                continue;
            }
            explicitEncoding = ", false";
            if (componentTag != null) {
                this.write("if (berTag.equals(" + BerClassWriter.getBerTagParametersString(componentTag) + ")) {");
                if (this.isExplicit(componentTag)) {
                    this.write("codeLength += length.decode(is);");
                    explicitEncoding = ", true";
                }
            } else {
                this.write("if (berTag.equals(" + this.getClassNameOfComponent(componentType) + ".tag)) {");
            }
            this.write(this.getName(componentType) + " = new " + this.getClassNameOfComponent(componentType) + "();");
            this.write("subCodeLength += " + this.getName(componentType) + ".decode(is" + explicitEncoding + ");");
            this.write("subCodeLength += berTag.decode(is);");
            this.write("}");
        }
        this.write("int nextByte = is.read();");
        this.write("if (berTag.tagNumber != 0 || berTag.tagClass != 0 || berTag.primitive != 0");
        this.write("|| nextByte != 0) {");
        this.write("if (nextByte == -1) {");
        this.write("throw new EOFException(\"Unexpected end of input stream.\");");
        this.write("}");
        this.write("throw new IOException(\"Decoded sequence has wrong end of contents octets\");");
        this.write("}");
        this.write("codeLength += subCodeLength + 1;");
        this.write("return codeLength;");
        this.write("}\n");
    }

    private void writeSetDecodeIndefiniteLenghtPart(List<AsnElementType> componentTypes) throws IOException {
        this.write("if (totalLength == -1) {");
        this.write("subCodeLength += berTag.decode(is);\n");
        String initChoiceDecodeLength = "int ";
        for (AsnElementType componentType : componentTypes) {
            String explicitEncoding;
            Tag componentTag = this.getTag(componentType);
            this.write("if (berTag.tagNumber == 0 && berTag.tagClass == 0 && berTag.primitive == 0) {");
            this.write("int nextByte = is.read();");
            this.write("if (nextByte != 0) {");
            this.write("if (nextByte == -1) {");
            this.write("throw new EOFException(\"Unexpected end of input stream.\");");
            this.write("}");
            this.write("throw new IOException(\"Decoded sequence has wrong end of contents octets\");");
            this.write("}");
            this.write("codeLength += subCodeLength + 1;");
            this.write("return codeLength;");
            this.write("}");
            if (this.isDirectAnyOrChoice(componentType)) {
                if (this.isExplicit(componentTag)) {
                    this.write("if (berTag.equals(" + BerClassWriter.getBerTagParametersString(componentTag) + ")) {");
                    this.write("subCodeLength += length.decode(is);");
                    explicitEncoding = "null";
                } else {
                    explicitEncoding = "berTag";
                }
                this.write(this.getName(componentType) + " = new " + this.getClassNameOfComponent(componentType) + "();");
                this.write(initChoiceDecodeLength + "choiceDecodeLength = " + this.getName(componentType) + ".decode(is, " + explicitEncoding + ");");
                if (!this.isExplicit(componentTag)) {
                    initChoiceDecodeLength = "";
                }
                this.write("if (choiceDecodeLength != 0) {");
                this.write("subCodeLength += choiceDecodeLength;");
                this.write("subCodeLength += berTag.decode(is);");
                this.write("}");
                this.write("else {");
                this.write(this.getName(componentType) + " = null;");
                this.write("}\n");
                if (!this.isExplicit(componentTag)) continue;
                this.write("}");
                continue;
            }
            explicitEncoding = ", false";
            if (componentTag != null) {
                this.write("if (berTag.equals(" + BerClassWriter.getBerTagParametersString(componentTag) + ")) {");
                if (this.isExplicit(componentTag)) {
                    this.write("codeLength += length.decode(is);");
                    explicitEncoding = ", true";
                }
            } else {
                this.write("if (berTag.equals(" + this.getClassNameOfComponent(componentType) + ".tag)) {");
            }
            this.write(this.getName(componentType) + " = new " + this.getClassNameOfComponent(componentType) + "();");
            this.write("subCodeLength += " + this.getName(componentType) + ".decode(is" + explicitEncoding + ");");
            this.write("subCodeLength += berTag.decode(is);");
            this.write("}");
        }
        this.write("int nextByte = is.read();");
        this.write("if (berTag.tagNumber != 0 || berTag.tagClass != 0 || berTag.primitive != 0");
        this.write("|| nextByte != 0) {");
        this.write("if (nextByte == -1) {");
        this.write("throw new EOFException(\"Unexpected end of input stream.\");");
        this.write("}");
        this.write("throw new IOException(\"Decoded sequence has wrong end of contents octets\");");
        this.write("}");
        this.write("codeLength += subCodeLength + 1;");
        this.write("return codeLength;");
        this.write("}\n");
    }

    private void writeEncodeTag(Tag tag) throws IOException {
        int typeStructure = tag.typeStructure == TypeStructure.CONSTRUCTED ? 32 : 0;
        BerTag berTag = new BerTag(this.getTagClassId(tag.tagClass.toString()), typeStructure, tag.value);
        this.write("// write tag: " + (Object)((Object)tag.tagClass) + "_CLASS, " + (Object)((Object)tag.typeStructure) + ", " + tag.value);
        for (int i = berTag.tagBytes.length - 1; i >= 0; --i) {
            this.write("reverseOS.write(" + HexConverter.toHexString(berTag.tagBytes[i]) + ");");
        }
        this.write("codeLength += " + berTag.tagBytes.length + ";");
    }

    private int getTagClassId(String tagClass) {
        if (tagClass.equals("UNIVERSAL")) {
            return 0;
        }
        if (tagClass.equals("APPLICATION")) {
            return 64;
        }
        if (tagClass.equals("CONTEXT")) {
            return 128;
        }
        if (tagClass.equals("PRIVATE")) {
            return 192;
        }
        throw new IllegalStateException("unknown tag class: " + tagClass);
    }

    private String getName(AsnElementType componentType) {
        return this.cleanUpName(componentType.name);
    }

    private boolean isOptional(AsnElementType componentType) {
        return componentType.isOptional || componentType.isDefault;
    }

    private boolean isExplicit(Tag tag) {
        return tag != null && tag.type == TagType.EXPLICIT;
    }

    private void writeEncodeConstructor(String className, List<AsnElementType> componentTypes) throws IOException {
        if (componentTypes.isEmpty()) {
            return;
        }
        String line = "public " + className + "(";
        int j = 0;
        for (AsnElementType componentType : componentTypes) {
            if (j != 0) {
                line = line + ", ";
            }
            ++j;
            line = line + this.getClassNameOfComponent(componentType) + " " + this.cleanUpName(componentType.name);
        }
        this.write(line + ") {");
        for (AsnElementType componentType : componentTypes) {
            String elementName = this.cleanUpName(componentType.name);
            this.write("this." + elementName + " = " + elementName + ";");
        }
        this.write("}\n");
    }

    private void writeEmptyConstructor(String className) throws IOException {
        this.write("public " + className + "() {");
        this.write("}\n");
        this.write("public " + className + "(byte[] code) {");
        this.write("this.code = code;");
        this.write("}\n");
    }

    private void writePublicMembers(List<AsnElementType> componentTypes) throws IOException {
        for (AsnElementType element : componentTypes) {
            if (this.jaxbMode) {
                this.write("private " + element.className + " " + this.cleanUpName(element.name) + " = null;");
                continue;
            }
            this.write("public " + element.className + " " + this.cleanUpName(element.name) + " = null;");
        }
        this.write("");
    }

    private boolean isInnerType(AsnElementType element) {
        return element.typeReference != null && element.typeReference instanceof AsnConstructedType;
    }

    private void writeGetterAndSetter(List<AsnElementType> componentTypes) throws IOException {
        for (AsnElementType element : componentTypes) {
            String typeName = this.getClassNameOfComponent(element);
            String getterName = this.cleanUpName("get" + this.capitalizeFirstCharacter(element.name));
            String setterName = this.cleanUpName("set" + this.capitalizeFirstCharacter(element.name));
            String variableName = this.cleanUpName(element.name);
            this.write("public void " + setterName + "(" + typeName + " " + variableName + ") {");
            this.write("this." + variableName + " = " + variableName + ";");
            this.write("}\n");
            this.write("public " + typeName + " " + getterName + "() {");
            this.write("return " + variableName + ";");
            this.write("}\n");
        }
    }

    private void writeGetterForSeqOf(String referencedTypeName) throws IOException {
        this.write("public List<" + referencedTypeName + "> get" + referencedTypeName.substring(referencedTypeName.lastIndexOf(46) + 1) + "() {");
        this.write("if (seqOf == null) {");
        this.write("seqOf = new ArrayList<" + referencedTypeName + ">();");
        this.write("}");
        this.write("return seqOf;");
        this.write("}\n");
    }

    private String getClassNameOfSequenceOfElement(AsnElementType componentType, List<String> listOfSubClassNames) throws IOException {
        String classNameOfSequenceElement = this.getClassNameOfSequenceOfElement(componentType);
        for (String subClassName : listOfSubClassNames) {
            if (!classNameOfSequenceElement.equals(subClassName)) continue;
            String moduleName = this.module.moduleIdentifier.name;
            for (SymbolsFromModule syms : this.module.importSymbolFromModuleList) {
                if (!syms.symbolList.contains(classNameOfSequenceElement)) continue;
                moduleName = syms.modref;
                break;
            }
            return this.basePackageName + this.sanitizeModuleName(moduleName).replace('-', '.').toLowerCase() + "." + classNameOfSequenceElement;
        }
        return classNameOfSequenceElement;
    }

    private String getClassNameOfSequenceOfElement(AsnElementType componentType) throws IOException {
        if (componentType.typeReference == null) {
            return this.cleanUpName(componentType.definedType.typeName);
        }
        AsnType typeDefinition = componentType.typeReference;
        return this.getClassNameOfSequenceOfTypeReference(typeDefinition);
    }

    private String getClassNameOfSequenceOfTypeReference(AsnType typeDefinition) {
        if (typeDefinition instanceof AsnConstructedType) {
            String subClassName = typeDefinition instanceof AsnSequenceSet ? (((AsnSequenceSet)typeDefinition).isSequence ? "SEQUENCE" : "SET") : (typeDefinition instanceof AsnSequenceOf ? (((AsnSequenceOf)typeDefinition).isSequenceOf ? "SEQUENCEOF" : "SETOF") : "CHOICE");
            return subClassName;
        }
        return this.getBerType(typeDefinition);
    }

    private String capitalizeFirstCharacter(String input) {
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    private String getBerType(AsnType asnType) {
        String fullClassName = asnType.getClass().getName();
        String className = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
        if (className.equals("AsnCharacterString")) {
            AsnCharacterString asnCharacterString = (AsnCharacterString)asnType;
            if (asnCharacterString.stringtype.equals("ISO646String")) {
                return "BerVisibleString";
            }
            if (asnCharacterString.stringtype.equals("T61String")) {
                return "BerTeletexString";
            }
            return "Ber" + ((AsnCharacterString)asnType).stringtype;
        }
        return "Ber" + className.substring(3);
    }

    private String[] getConstructorParameters(AsnUniversalType typeDefinition) throws IOException {
        if (typeDefinition instanceof AsnInteger || typeDefinition instanceof AsnEnum) {
            return new String[]{"BigInteger", "value"};
        }
        if (typeDefinition instanceof AsnReal) {
            return new String[]{"double", "value"};
        }
        if (typeDefinition instanceof AsnBoolean) {
            return new String[]{"boolean", "value"};
        }
        if (typeDefinition instanceof AsnObjectIdentifier) {
            return new String[]{"int[]", "value"};
        }
        if (typeDefinition instanceof AsnBitString) {
            return new String[]{"byte[]", "value", "int", "numBits"};
        }
        if (typeDefinition instanceof AsnOctetString || typeDefinition instanceof AsnCharacterString) {
            return new String[]{"byte[]", "value"};
        }
        if (typeDefinition instanceof AsnNull) {
            return new String[0];
        }
        if (typeDefinition instanceof AsnSequenceSet || typeDefinition instanceof AsnChoice) {
            return this.getConstructorParametersFromConstructedElement((AsnConstructedType)typeDefinition);
        }
        if (typeDefinition instanceof AsnSequenceOf) {
            return new String[]{"List<" + this.getClassNameOfSequenceOfElement(((AsnSequenceOf)typeDefinition).componentType) + ">", "seqOf"};
        }
        if (typeDefinition instanceof AsnAny) {
            return new String[]{"byte[]", "value"};
        }
        if (typeDefinition instanceof AsnEmbeddedPdv) {
            return new String[0];
        }
        throw new IllegalStateException("type of unknown class: " + typeDefinition.name);
    }

    private String[] getConstructorParametersFromConstructedElement(AsnConstructedType assignedTypeDefinition) throws IOException {
        List<AsnElementType> componentTypes = assignedTypeDefinition instanceof AsnSequenceSet ? ((AsnSequenceSet)assignedTypeDefinition).componentTypes : ((AsnChoice)assignedTypeDefinition).componentTypes;
        String[] constructorParameters = new String[componentTypes.size() * 2];
        for (int j = 0; j < componentTypes.size(); ++j) {
            AsnElementType componentType = componentTypes.get(j);
            constructorParameters[j * 2] = this.getClassNameOfComponent(componentType);
            constructorParameters[j * 2 + 1] = this.cleanUpName(componentType.name);
        }
        return constructorParameters;
    }

    private AsnType followAndGetNextTaggedOrUniversalType(AsnType asnType, AsnModule module) throws CompileException {
        return this.followAndGetNextTaggedOrUniversalType(asnType, module, true);
    }

    private AsnType followAndGetNextTaggedOrUniversalType(AsnType asnType, AsnModule module, boolean firstCall) throws CompileException {
        if (asnType instanceof AsnTaggedType) {
            if (!firstCall) {
                return asnType;
            }
            AsnTaggedType taggedType = (AsnTaggedType)asnType;
            if (taggedType.definedType != null) {
                return this.followAndGetNextTaggedOrUniversalType(taggedType.definedType, module, false);
            }
            return taggedType.typeReference;
        }
        if (asnType instanceof AsnDefinedType) {
            AsnDefinedType definedType = (AsnDefinedType)asnType;
            if (definedType.isObjectClassField) {
                AsnInformationObjectClass informationObjectClass = this.getInformationObjectClass(definedType.moduleOrObjectClassReference, module);
                if (informationObjectClass == null) {
                    throw new CompileException("no information object class of name \"" + definedType.moduleOrObjectClassReference + "\" found");
                }
                for (AsnElementType elementType : informationObjectClass.elementList) {
                    if (!elementType.name.equals(definedType.typeName)) continue;
                    return this.followAndGetNextTaggedOrUniversalType(elementType, module, true);
                }
                throw new IllegalStateException("Could not find field \"" + definedType.typeName + "\" of information object class \"" + definedType.moduleOrObjectClassReference + "\"");
            }
            return this.followAndGetNextTaggedOrUniversalType(definedType.typeName, module, false);
        }
        if (asnType instanceof AsnUniversalType) {
            return asnType;
        }
        throw new IllegalStateException();
    }

    private AsnType followAndGetNextTaggedOrUniversalType(String typeName, AsnModule module, boolean firstCall) throws CompileException {
        AsnType asnType = module.typesByName.get(typeName);
        if (asnType != null) {
            return this.followAndGetNextTaggedOrUniversalType(asnType, module, false);
        }
        for (SymbolsFromModule symbolsFromModule : module.importSymbolFromModuleList) {
            for (String importedTypeName : symbolsFromModule.symbolList) {
                if (!typeName.equals(importedTypeName)) continue;
                return this.followAndGetNextTaggedOrUniversalType(typeName, this.getAsnModule(symbolsFromModule.modref), false);
            }
        }
        throw new IllegalStateException("Type definition \"" + typeName + "\" was not found in module \"" + module.moduleIdentifier.name + "\"");
    }

    private AsnModule getAsnModule(String moduleName) {
        AsnModule asnModule = this.modulesByName.get(moduleName);
        if (asnModule == null) {
            throw new CompileException("Definition of imported module \"" + moduleName + "\" not found.");
        }
        return asnModule;
    }

    private boolean isDirectAnyOrChoice(AsnTaggedType taggedType) throws CompileException {
        AsnType followedType = this.followAndGetNextTaggedOrUniversalType(taggedType, this.module);
        return followedType instanceof AsnAny || followedType instanceof AsnChoice;
    }

    private AsnUniversalType getUniversalType(AsnType asnType) throws IOException {
        return this.getUniversalType(asnType, this.module);
    }

    private AsnUniversalType getUniversalType(AsnType asnType, AsnModule module) throws IOException {
        while ((asnType = this.followAndGetNextTaggedOrUniversalType(asnType, module)) instanceof AsnTaggedType) {
        }
        return (AsnUniversalType)asnType;
    }

    private boolean isPrimitive(AsnTaggedType asnTaggedType) throws IOException {
        AsnType asnType = asnTaggedType;
        while ((asnType = this.followAndGetNextTaggedOrUniversalType(asnType, this.module)) instanceof AsnTaggedType) {
            if (!this.isExplicit(this.getTag((AsnTaggedType)asnType))) continue;
            return false;
        }
        return this.isPrimitive((AsnUniversalType)asnType);
    }

    private boolean isPrimitiveOrRetaggedPrimitive(AsnType asnType) throws IOException {
        return this.isPrimitive(this.getUniversalType(asnType));
    }

    private boolean isPrimitive(AsnUniversalType asnType) {
        return !(asnType instanceof AsnConstructedType) && !(asnType instanceof AsnEmbeddedPdv);
    }

    private void writeClassHeader(String typeName, AsnModule module) throws IOException {
        this.outputDirectory.mkdirs();
        FileWriter fstream = new FileWriter(new File(this.outputDirectory, typeName + ".java"));
        this.out = new BufferedWriter(fstream);
        this.write("/**");
        this.write(" * This class file was automatically generated by jASN1 v1.10.0 (http://www.openmuc.org)\n */\n");
        this.write("package " + this.basePackageName + this.sanitizeModuleName(module.moduleIdentifier.name).replace('-', '.').toLowerCase() + ";\n");
        this.write("import java.io.IOException;");
        this.write("import java.io.EOFException;");
        this.write("import java.io.InputStream;");
        this.write("import java.io.OutputStream;");
        this.write("import java.util.List;");
        this.write("import java.util.ArrayList;");
        this.write("import java.util.Iterator;");
        this.write("import java.io.UnsupportedEncodingException;");
        this.write("import java.math.BigInteger;");
        this.write("import java.io.Serializable;");
        this.write("import org.openmuc.jasn1.ber.*;");
        this.write("import org.openmuc.jasn1.ber.types.*;");
        this.write("import org.openmuc.jasn1.ber.types.string.*;\n");
        ArrayList<String> importedClassesFromOtherModules = new ArrayList<String>();
        for (SymbolsFromModule symbolsFromModule : module.importSymbolFromModuleList) {
            AsnModule importedModule = this.modulesByName.get(symbolsFromModule.modref);
            for (String importedSymbol : symbolsFromModule.symbolList) {
                if (!Character.isUpperCase(importedSymbol.charAt(0)) || importedModule.typesByName.get(importedSymbol) == null) continue;
                importedClassesFromOtherModules.add(this.sanitizeModuleName(importedModule.moduleIdentifier.name).replace('-', '.').toLowerCase() + "." + this.cleanUpName(importedSymbol) + ";");
            }
        }
        Collections.sort(importedClassesFromOtherModules);
        for (String modulePackage : importedClassesFromOtherModules) {
            this.write("import " + this.basePackageName + modulePackage);
        }
        this.write("");
    }

    private void write(String line) throws IOException {
        if (line.startsWith("}")) {
            --this.indentNum;
        }
        for (int i = 0; i < this.indentNum; ++i) {
            this.out.write("\t");
        }
        this.out.write(line + "\n");
        if (line.endsWith(" {") || line.endsWith(" {\n") || line.endsWith(" {\n\n")) {
            ++this.indentNum;
        }
    }

    static {
        BerClassWriter.stdSeqTag.tagClass = TagClass.UNIVERSAL;
        BerClassWriter.stdSeqTag.value = 16;
        BerClassWriter.stdSeqTag.typeStructure = TypeStructure.CONSTRUCTED;
        BerClassWriter.stdSetTag.tagClass = TagClass.UNIVERSAL;
        BerClassWriter.stdSetTag.value = 17;
        BerClassWriter.stdSetTag.typeStructure = TypeStructure.CONSTRUCTED;
        reservedKeywords = Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList("public", "private", "protected", "final", "void", "int", "short", "float", "double", "long", "byte", "char", "String", "throw", "throws", "new", "static", "volatile", "if", "else", "for", "switch", "case", "enum", "this", "super", "boolean", "class", "abstract", "package", "import", "null", "code", "getClass", "setClass")));
    }

    public static class Tag {
        public int value;
        public TagClass tagClass;
        public TagType type;
        public TypeStructure typeStructure;
    }

    public static enum TypeStructure {
        PRIMITIVE,
        CONSTRUCTED;

    }

    public static enum TagType {
        EXPLICIT,
        IMPLICIT;

    }

    public static enum TagClass {
        UNIVERSAL,
        APPLICATION,
        CONTEXT,
        PRIVATE;

    }
}

