/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jasn1.ber.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.openmuc.jasn1.ber.BerLength;
import org.openmuc.jasn1.ber.BerTag;
import org.openmuc.jasn1.ber.ReverseByteArrayOutputStream;
import org.openmuc.jasn1.ber.types.BerInteger;
import org.openmuc.jasn1.ber.types.BerNull;
import org.openmuc.jasn1.ber.types.BerObjectIdentifier;
import org.openmuc.jasn1.ber.types.BerOctetString;
import org.openmuc.jasn1.ber.types.BerType;
import org.openmuc.jasn1.ber.types.string.BerObjectDescriptor;

public class BerEmbeddedPdv
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final BerTag tag = new BerTag(0, 32, 11);
    public byte[] code = null;
    private Identification identification = null;
    private BerObjectDescriptor dataValueDescriptor = null;
    private BerOctetString dataValue = null;

    public BerEmbeddedPdv() {
    }

    public BerEmbeddedPdv(byte[] code) {
        this.code = code;
    }

    public void setIdentification(Identification identification) {
        this.identification = identification;
    }

    public Identification getIdentification() {
        return this.identification;
    }

    public void setDataValueDescriptor(BerObjectDescriptor dataValueDescriptor) {
        this.dataValueDescriptor = dataValueDescriptor;
    }

    public BerObjectDescriptor getDataValueDescriptor() {
        return this.dataValueDescriptor;
    }

    public void setDataValue(BerOctetString dataValue) {
        this.dataValue = dataValue;
    }

    public BerOctetString getDataValue() {
        return this.dataValue;
    }

    @Override
    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        codeLength += this.dataValue.encode(reverseOS, false);
        reverseOS.write(130);
        ++codeLength;
        if (this.dataValueDescriptor != null) {
            codeLength += this.dataValueDescriptor.encode(reverseOS, false);
            reverseOS.write(129);
            ++codeLength;
        }
        int sublength = this.identification.encode(reverseOS);
        codeLength += sublength;
        codeLength += BerLength.encodeLength(reverseOS, sublength);
        reverseOS.write(160);
        ++codeLength;
        codeLength += BerLength.encodeLength(reverseOS, codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        int subCodeLength = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        int totalLength = length.val;
        codeLength += totalLength;
        subCodeLength += berTag.decode(is);
        if (berTag.equals(128, 32, 0)) {
            subCodeLength += length.decode(is);
            this.identification = new Identification();
            subCodeLength += this.identification.decode(is, null);
            subCodeLength += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match the mandatory sequence element tag.");
        }
        if (berTag.equals(128, 0, 1)) {
            this.dataValueDescriptor = new BerObjectDescriptor();
            subCodeLength += this.dataValueDescriptor.decode(is, false);
            subCodeLength += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 2)) {
            this.dataValue = new BerOctetString();
            if ((subCodeLength += this.dataValue.decode(is, false)) == totalLength) {
                return codeLength;
            }
        }
        throw new IOException("Unexpected end of sequence, length tag: " + totalLength + ", actual sequence length: " + subCodeLength);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        sb.append("\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.identification != null) {
            sb.append("identification: ");
            this.identification.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("identification: <empty-required-field>");
        }
        if (this.dataValueDescriptor != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("dataValueDescriptor: ").append(this.dataValueDescriptor);
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.dataValue != null) {
            sb.append("dataValue: ").append(this.dataValue);
        } else {
            sb.append("dataValue: <empty-required-field>");
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class Identification
    implements BerType,
    Serializable {
        private static final long serialVersionUID = 1L;
        public byte[] code = null;
        private Syntaxes syntaxes = null;
        private BerObjectIdentifier syntax = null;
        private BerInteger presentationContextId = null;
        private ContextNegotiation contextNegotiation = null;
        private BerObjectIdentifier transferSyntax = null;
        private BerNull fixed = null;

        public Identification() {
        }

        public Identification(byte[] code) {
            this.code = code;
        }

        public void setSyntaxes(Syntaxes syntaxes) {
            this.syntaxes = syntaxes;
        }

        public Syntaxes getSyntaxes() {
            return this.syntaxes;
        }

        public void setSyntax(BerObjectIdentifier syntax) {
            this.syntax = syntax;
        }

        public BerObjectIdentifier getSyntax() {
            return this.syntax;
        }

        public void setPresentationContextId(BerInteger presentationContextId) {
            this.presentationContextId = presentationContextId;
        }

        public BerInteger getPresentationContextId() {
            return this.presentationContextId;
        }

        public void setContextNegotiation(ContextNegotiation contextNegotiation) {
            this.contextNegotiation = contextNegotiation;
        }

        public ContextNegotiation getContextNegotiation() {
            return this.contextNegotiation;
        }

        public void setTransferSyntax(BerObjectIdentifier transferSyntax) {
            this.transferSyntax = transferSyntax;
        }

        public BerObjectIdentifier getTransferSyntax() {
            return this.transferSyntax;
        }

        public void setFixed(BerNull fixed) {
            this.fixed = fixed;
        }

        public BerNull getFixed() {
            return this.fixed;
        }

        @Override
        public int encode(OutputStream reverseOS) throws IOException {
            if (this.code != null) {
                for (int i = this.code.length - 1; i >= 0; --i) {
                    reverseOS.write(this.code[i]);
                }
                return this.code.length;
            }
            int codeLength = 0;
            if (this.fixed != null) {
                codeLength += this.fixed.encode(reverseOS, false);
                reverseOS.write(133);
                return ++codeLength;
            }
            if (this.transferSyntax != null) {
                codeLength += this.transferSyntax.encode(reverseOS, false);
                reverseOS.write(132);
                return ++codeLength;
            }
            if (this.contextNegotiation != null) {
                codeLength += this.contextNegotiation.encode(reverseOS, false);
                reverseOS.write(163);
                return ++codeLength;
            }
            if (this.presentationContextId != null) {
                codeLength += this.presentationContextId.encode(reverseOS, false);
                reverseOS.write(130);
                return ++codeLength;
            }
            if (this.syntax != null) {
                codeLength += this.syntax.encode(reverseOS, false);
                reverseOS.write(129);
                return ++codeLength;
            }
            if (this.syntaxes != null) {
                codeLength += this.syntaxes.encode(reverseOS, false);
                reverseOS.write(160);
                return ++codeLength;
            }
            throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
        }

        @Override
        public int decode(InputStream is) throws IOException {
            return this.decode(is, null);
        }

        public int decode(InputStream is, BerTag berTag) throws IOException {
            int codeLength = 0;
            BerTag passedTag = berTag;
            if (berTag == null) {
                berTag = new BerTag();
                codeLength += berTag.decode(is);
            }
            if (berTag.equals(128, 32, 0)) {
                this.syntaxes = new Syntaxes();
                return codeLength += this.syntaxes.decode(is, false);
            }
            if (berTag.equals(128, 0, 1)) {
                this.syntax = new BerObjectIdentifier();
                return codeLength += this.syntax.decode(is, false);
            }
            if (berTag.equals(128, 0, 2)) {
                this.presentationContextId = new BerInteger();
                return codeLength += this.presentationContextId.decode(is, false);
            }
            if (berTag.equals(128, 32, 3)) {
                this.contextNegotiation = new ContextNegotiation();
                return codeLength += this.contextNegotiation.decode(is, false);
            }
            if (berTag.equals(128, 0, 4)) {
                this.transferSyntax = new BerObjectIdentifier();
                return codeLength += this.transferSyntax.decode(is, false);
            }
            if (berTag.equals(128, 0, 5)) {
                this.fixed = new BerNull();
                return codeLength += this.fixed.decode(is, false);
            }
            if (passedTag != null) {
                return 0;
            }
            throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode(reverseOS);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            if (this.syntaxes != null) {
                sb.append("syntaxes: ");
                this.syntaxes.appendAsString(sb, indentLevel + 1);
                return;
            }
            if (this.syntax != null) {
                sb.append("syntax: ").append(this.syntax);
                return;
            }
            if (this.presentationContextId != null) {
                sb.append("presentationContextId: ").append(this.presentationContextId);
                return;
            }
            if (this.contextNegotiation != null) {
                sb.append("contextNegotiation: ");
                this.contextNegotiation.appendAsString(sb, indentLevel + 1);
                return;
            }
            if (this.transferSyntax != null) {
                sb.append("transferSyntax: ").append(this.transferSyntax);
                return;
            }
            if (this.fixed != null) {
                sb.append("fixed: ").append(this.fixed);
                return;
            }
            sb.append("<none>");
        }

        public static class ContextNegotiation
        implements BerType,
        Serializable {
            private static final long serialVersionUID = 1L;
            public static final BerTag tag = new BerTag(0, 32, 16);
            public byte[] code = null;
            private BerInteger presentationContextId = null;
            private BerObjectIdentifier transferSyntax = null;

            public ContextNegotiation() {
            }

            public ContextNegotiation(byte[] code) {
                this.code = code;
            }

            public void setPresentationContextId(BerInteger presentationContextId) {
                this.presentationContextId = presentationContextId;
            }

            public BerInteger getPresentationContextId() {
                return this.presentationContextId;
            }

            public void setTransferSyntax(BerObjectIdentifier transferSyntax) {
                this.transferSyntax = transferSyntax;
            }

            public BerObjectIdentifier getTransferSyntax() {
                return this.transferSyntax;
            }

            @Override
            public int encode(OutputStream reverseOS) throws IOException {
                return this.encode(reverseOS, true);
            }

            public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
                if (this.code != null) {
                    for (int i = this.code.length - 1; i >= 0; --i) {
                        reverseOS.write(this.code[i]);
                    }
                    if (withTag) {
                        return tag.encode(reverseOS) + this.code.length;
                    }
                    return this.code.length;
                }
                int codeLength = 0;
                codeLength += this.transferSyntax.encode(reverseOS, false);
                reverseOS.write(129);
                ++codeLength;
                codeLength += this.presentationContextId.encode(reverseOS, false);
                reverseOS.write(128);
                ++codeLength;
                codeLength += BerLength.encodeLength(reverseOS, codeLength);
                if (withTag) {
                    codeLength += tag.encode(reverseOS);
                }
                return codeLength;
            }

            @Override
            public int decode(InputStream is) throws IOException {
                return this.decode(is, true);
            }

            public int decode(InputStream is, boolean withTag) throws IOException {
                int codeLength = 0;
                int subCodeLength = 0;
                BerTag berTag = new BerTag();
                if (withTag) {
                    codeLength += tag.decodeAndCheck(is);
                }
                BerLength length = new BerLength();
                codeLength += length.decode(is);
                int totalLength = length.val;
                codeLength += totalLength;
                subCodeLength += berTag.decode(is);
                if (berTag.equals(128, 0, 0)) {
                    this.presentationContextId = new BerInteger();
                    subCodeLength += this.presentationContextId.decode(is, false);
                    subCodeLength += berTag.decode(is);
                } else {
                    throw new IOException("Tag does not match the mandatory sequence element tag.");
                }
                if (berTag.equals(128, 0, 1)) {
                    this.transferSyntax = new BerObjectIdentifier();
                    if ((subCodeLength += this.transferSyntax.decode(is, false)) == totalLength) {
                        return codeLength;
                    }
                }
                throw new IOException("Unexpected end of sequence, length tag: " + totalLength + ", actual sequence length: " + subCodeLength);
            }

            public void encodeAndSave(int encodingSizeGuess) throws IOException {
                ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
                this.encode(reverseOS, false);
                this.code = reverseOS.getArray();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                this.appendAsString(sb, 0);
                return sb.toString();
            }

            public void appendAsString(StringBuilder sb, int indentLevel) {
                int i;
                sb.append("{");
                sb.append("\n");
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                if (this.presentationContextId != null) {
                    sb.append("presentationContextId: ").append(this.presentationContextId);
                } else {
                    sb.append("presentationContextId: <empty-required-field>");
                }
                sb.append(",\n");
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                if (this.transferSyntax != null) {
                    sb.append("transferSyntax: ").append(this.transferSyntax);
                } else {
                    sb.append("transferSyntax: <empty-required-field>");
                }
                sb.append("\n");
                for (i = 0; i < indentLevel; ++i) {
                    sb.append("\t");
                }
                sb.append("}");
            }
        }

        public static class Syntaxes
        implements BerType,
        Serializable {
            private static final long serialVersionUID = 1L;
            public static final BerTag tag = new BerTag(0, 32, 16);
            public byte[] code = null;
            private BerObjectIdentifier abstract_ = null;
            private BerObjectIdentifier transfer = null;

            public Syntaxes() {
            }

            public Syntaxes(byte[] code) {
                this.code = code;
            }

            public void setAbstract(BerObjectIdentifier abstract_) {
                this.abstract_ = abstract_;
            }

            public BerObjectIdentifier getAbstract() {
                return this.abstract_;
            }

            public void setTransfer(BerObjectIdentifier transfer) {
                this.transfer = transfer;
            }

            public BerObjectIdentifier getTransfer() {
                return this.transfer;
            }

            @Override
            public int encode(OutputStream reverseOS) throws IOException {
                return this.encode(reverseOS, true);
            }

            public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
                if (this.code != null) {
                    for (int i = this.code.length - 1; i >= 0; --i) {
                        reverseOS.write(this.code[i]);
                    }
                    if (withTag) {
                        return tag.encode(reverseOS) + this.code.length;
                    }
                    return this.code.length;
                }
                int codeLength = 0;
                codeLength += this.transfer.encode(reverseOS, false);
                reverseOS.write(129);
                ++codeLength;
                codeLength += this.abstract_.encode(reverseOS, false);
                reverseOS.write(128);
                ++codeLength;
                codeLength += BerLength.encodeLength(reverseOS, codeLength);
                if (withTag) {
                    codeLength += tag.encode(reverseOS);
                }
                return codeLength;
            }

            @Override
            public int decode(InputStream is) throws IOException {
                return this.decode(is, true);
            }

            public int decode(InputStream is, boolean withTag) throws IOException {
                int codeLength = 0;
                int subCodeLength = 0;
                BerTag berTag = new BerTag();
                if (withTag) {
                    codeLength += tag.decodeAndCheck(is);
                }
                BerLength length = new BerLength();
                codeLength += length.decode(is);
                int totalLength = length.val;
                codeLength += totalLength;
                subCodeLength += berTag.decode(is);
                if (berTag.equals(128, 0, 0)) {
                    this.abstract_ = new BerObjectIdentifier();
                    subCodeLength += this.abstract_.decode(is, false);
                    subCodeLength += berTag.decode(is);
                } else {
                    throw new IOException("Tag does not match the mandatory sequence element tag.");
                }
                if (berTag.equals(128, 0, 1)) {
                    this.transfer = new BerObjectIdentifier();
                    if ((subCodeLength += this.transfer.decode(is, false)) == totalLength) {
                        return codeLength;
                    }
                }
                throw new IOException("Unexpected end of sequence, length tag: " + totalLength + ", actual sequence length: " + subCodeLength);
            }

            public void encodeAndSave(int encodingSizeGuess) throws IOException {
                ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
                this.encode(reverseOS, false);
                this.code = reverseOS.getArray();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                this.appendAsString(sb, 0);
                return sb.toString();
            }

            public void appendAsString(StringBuilder sb, int indentLevel) {
                int i;
                sb.append("{");
                sb.append("\n");
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                if (this.abstract_ != null) {
                    sb.append("abstract_: ").append(this.abstract_);
                } else {
                    sb.append("abstract_: <empty-required-field>");
                }
                sb.append(",\n");
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                if (this.transfer != null) {
                    sb.append("transfer: ").append(this.transfer);
                } else {
                    sb.append("transfer: <empty-required-field>");
                }
                sb.append("\n");
                for (i = 0; i < indentLevel; ++i) {
                    sb.append("\t");
                }
                sb.append("}");
            }
        }
    }
}

