/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.server.processor;

import com.google.auto.service.AutoService;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.openmuc.jdlms.CosemAttribute;
import org.openmuc.jdlms.CosemClass;
import org.openmuc.jdlms.CosemMethod;
import org.openmuc.jdlms.CosemSnInterfaceObject;
import org.openmuc.jdlms.datatypes.DataObject;

@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@AutoService(value={Processor.class})
public class JDlmsProcessor
extends AbstractProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        types.add(CosemClass.class.getCanonicalName());
        types.add(CosemMethod.class.getCanonicalName());
        types.add(CosemAttribute.class.getCanonicalName());
        return types;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> cosemObjectss = roundEnv.getElementsAnnotatedWith(CosemClass.class);
        for (Element element : cosemObjectss) {
            this.checkCosemClass(element);
        }
        return true;
    }

    private boolean typeIsSubtypeOfCosemSnInterfaceObject(Element enclosingElement) {
        return this.typeIsOfClass(CosemSnInterfaceObject.class, enclosingElement.asType());
    }

    private boolean typeIsOfClass(Class<?> clazz, TypeMirror type) {
        TypeMirror snType = this.processingEnv.getElementUtils().getTypeElement(clazz.getName()).asType();
        return this.processingEnv.getTypeUtils().isSubtype(type, snType);
    }

    private void checkCosemClass(Element classElement) {
        CosemClass cosemClass = classElement.getAnnotation(CosemClass.class);
        if (cosemClass.id() < 0) {
            this.error(classElement, "COSEM class ID must be positive.", new Object[0]);
        } else if (cosemClass.id() > 65535) {
            this.error(classElement, "COSEM class ID be in range from uint16.", new Object[0]);
        }
        if (cosemClass.version() < 0) {
            this.error(classElement, "COSEM class version must be positive.", new Object[0]);
        }
        List<? extends Element> annotatedElementsInClass = classElement.getEnclosedElements();
        HashSet<Byte> attributes = new HashSet<Byte>();
        HashSet<Byte> methods = new HashSet<Byte>();
        HashSet<Integer> shortNameOffset = new HashSet<Integer>();
        boolean subtypeOfCosemSnInterfaceObject = this.typeIsSubtypeOfCosemSnInterfaceObject(classElement);
        for (Element element : annotatedElementsInClass) {
            CosemAttribute cosemAttribute = element.getAnnotation(CosemAttribute.class);
            CosemMethod cosemMethod = element.getAnnotation(CosemMethod.class);
            if (cosemAttribute != null) {
                this.checkAttributes(attributes, shortNameOffset, subtypeOfCosemSnInterfaceObject, element, cosemAttribute);
                continue;
            }
            if (cosemMethod == null) continue;
            this.checkMethods(methods, shortNameOffset, subtypeOfCosemSnInterfaceObject, element, cosemMethod);
        }
    }

    private void checkMethods(Set<Byte> methods, Set<Integer> shortNameOffset, boolean subtypeOfCosemSnInterfaceObject, Element attributeOrMethod, CosemMethod cosemMethod) {
        List<? extends TypeMirror> parameterTypes;
        boolean rTypeIsVoid;
        if (!methods.add(cosemMethod.id())) {
            this.error(attributeOrMethod, "Method ID not unique in class.", new Object[0]);
        }
        ExecutableType type = (ExecutableType)attributeOrMethod.asType();
        TypeMirror returnType = type.getReturnType();
        boolean rTypeIsDO = this.typeIsOfClass(DataObject.class, returnType);
        boolean bl = rTypeIsVoid = returnType.getKind() == TypeKind.VOID;
        if (!rTypeIsDO && !rTypeIsVoid) {
            this.error(attributeOrMethod, "Return type may only be %s or void.", DataObject.class.getSimpleName());
        }
        if ((parameterTypes = type.getParameterTypes()).isEmpty() && cosemMethod.consumes() != DataObject.Type.DONT_CARE) {
            this.error(attributeOrMethod, "Specify at least one parameter.", new Object[0]);
        } else if (parameterTypes.size() == 1) {
            TypeMirror t = parameterTypes.get(0);
            boolean conIdTypeCorrect = this.typeIsLong(t);
            boolean valTypeCorrect = this.typeIsDataObject(t);
            if (!conIdTypeCorrect && !valTypeCorrect) {
                this.error(attributeOrMethod, "Parameters may only be of type %s and long/Long.", DataObject.class.getSimpleName());
            }
        } else if (parameterTypes.size() == 2) {
            TypeMirror valType = parameterTypes.get(0);
            TypeMirror conIdType = parameterTypes.get(1);
            boolean conIdTypeCorrect = this.typeIsLong(conIdType);
            boolean valTypeCorrect = this.typeIsDataObject(valType);
            if (!valTypeCorrect || !conIdTypeCorrect) {
                this.error(attributeOrMethod, "Parameters may only be of type %s and long/Long.", DataObject.class.getSimpleName());
            }
        } else if (parameterTypes.size() > 2) {
            this.error(attributeOrMethod, "Method has too many parameters.", new Object[0]);
        }
        this.checkSnOffset(shortNameOffset, subtypeOfCosemSnInterfaceObject, cosemMethod.snOffset(), attributeOrMethod);
    }

    private void checkAttributes(Set<Byte> attributes, Set<Integer> shortNameOffset, boolean subtypeOfCosemSnInterfaceObject, Element attributeOrMethod, CosemAttribute cosemAttribute) {
        byte attributeId = cosemAttribute.id();
        if (attributeId == 1) {
            this.error(attributeOrMethod, "COSEM Attribute ID 1 is reserved for the system.", new Object[0]);
        }
        if (!attributes.add(cosemAttribute.id())) {
            this.error(attributeOrMethod, "Attribute ID not unique in class.", new Object[0]);
        }
        TypeMirror fieldType = attributeOrMethod.asType();
        String fullTypeClassName = fieldType.toString();
        if (!DataObject.class.getCanonicalName().equals(fullTypeClassName)) {
            this.error(attributeOrMethod, "Type of a COSEM must be of type %s.", DataObject.class.getSimpleName());
        }
        this.checkSnOffset(shortNameOffset, subtypeOfCosemSnInterfaceObject, cosemAttribute.snOffset(), attributeOrMethod);
    }

    private boolean typeIsDataObject(TypeMirror valType) {
        return this.typeIsOfClass(DataObject.class, valType);
    }

    private boolean typeIsLong(TypeMirror conIdType) {
        return conIdType.getKind() == TypeKind.LONG || this.typeIsOfClass(Long.class, conIdType);
    }

    private void checkSnOffset(Set<Integer> shortNameOffset, boolean subtypeOfCosemSnInterfaceObject, int snOffset, Element element) {
        if (subtypeOfCosemSnInterfaceObject) {
            if (snOffset < 0) {
                this.error(element, "SN offset must be specified.", new Object[0]);
            } else if (snOffset % 8 != 0) {
                this.error(element, "SN offset must be a multiple of 8.", new Object[0]);
            } else if (!shortNameOffset.add(snOffset)) {
                this.error(element, "SN offset duplication: 0x%02x.", snOffset);
            }
        } else if (snOffset != -1) {
            this.error(element, "SN offset must not be specified.", new Object[0]);
        }
    }

    private void error(Element element, String message, Object ... args) {
        this.msg(element, message, Diagnostic.Kind.ERROR, args);
    }

    private void msg(Element element, String message, Diagnostic.Kind level, Object ... args) {
        if (args.length > 0) {
            message = String.format(message, args);
        }
        this.processingEnv.getMessager().printMessage(level, message, element);
    }
}

