/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.openmuc.jdlms.internal.APdu;

class APduBlockingQueue {
    private IOException ioException;
    private final BlockingQueue<APdu> queue = new LinkedBlockingQueue<APdu>();

    public void putError(IOException e) {
        this.ioException = e;
        this.put(new APdu(null, null));
    }

    public void put(APdu aPdu) {
        try {
            this.queue.put(aPdu);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public APdu poll(long timeout, TimeUnit unit) throws InterruptedException, IOException {
        this.throwExIfExists();
        APdu aPdu = null;
        aPdu = timeout == 0L ? this.queue.take() : this.queue.poll(timeout, unit);
        this.throwExIfExists();
        return aPdu;
    }

    private void throwExIfExists() throws IOException {
        if (this.ioException != null) {
            IOException ex = this.ioException;
            this.ioException = null;
            throw ex;
        }
    }

    public void clear() {
        this.queue.clear();
    }
}

