/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import java.util.HashMap;
import java.util.Map;

public enum AuthenticationMechanism {
    NONE(0),
    LOW(1),
    HLS5_GMAC(5);

    private final int id;
    private static final Map<Integer, AuthenticationMechanism> idMap;

    private AuthenticationMechanism(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static AuthenticationMechanism forId(int id) {
        AuthenticationMechanism enumInstance = idMap.get(id);
        if (enumInstance == null) {
            throw new IllegalArgumentException("invalid ID: " + id);
        }
        return enumInstance;
    }

    public boolean isHlsMechanism() {
        switch (this) {
            case HLS5_GMAC: {
                return true;
            }
        }
        return false;
    }

    static {
        idMap = new HashMap<Integer, AuthenticationMechanism>();
        for (AuthenticationMechanism enumInstance : AuthenticationMechanism.values()) {
            if (idMap.put(enumInstance.getId(), enumInstance) == null) continue;
            throw new IllegalArgumentException("duplicate ID: " + enumInstance.getId());
        }
    }
}

