/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import com.beanit.asn1bean.ber.types.BerOctetString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openmuc.jdlms.APduBlockingQueue;
import org.openmuc.jdlms.AuthenticationMechanism;
import org.openmuc.jdlms.BaseConnection;
import org.openmuc.jdlms.ConformanceSetting;
import org.openmuc.jdlms.FatalJDlmsException;
import org.openmuc.jdlms.JDlmsException;
import org.openmuc.jdlms.MethodResult;
import org.openmuc.jdlms.MethodResultCode;
import org.openmuc.jdlms.RawMessageData;
import org.openmuc.jdlms.RawMessageListener;
import org.openmuc.jdlms.ResponseQueue;
import org.openmuc.jdlms.ResponseTimeoutException;
import org.openmuc.jdlms.SecuritySuite;
import org.openmuc.jdlms.datatypes.DataObject;
import org.openmuc.jdlms.internal.APdu;
import org.openmuc.jdlms.internal.ConformanceSettingConverter;
import org.openmuc.jdlms.internal.ContextId;
import org.openmuc.jdlms.internal.ObjectIdentifier;
import org.openmuc.jdlms.internal.PduHelper;
import org.openmuc.jdlms.internal.ReleaseReqReason;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrBoolean;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOctetString;
import org.openmuc.jdlms.internal.asn1.cosem.COSEMpdu;
import org.openmuc.jdlms.internal.asn1.cosem.ConfirmedServiceError;
import org.openmuc.jdlms.internal.asn1.cosem.Conformance;
import org.openmuc.jdlms.internal.asn1.cosem.ExceptionResponse;
import org.openmuc.jdlms.internal.asn1.cosem.InitiateRequest;
import org.openmuc.jdlms.internal.asn1.cosem.InitiateResponse;
import org.openmuc.jdlms.internal.asn1.cosem.Integer8;
import org.openmuc.jdlms.internal.asn1.cosem.InvokeIdAndPriority;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned16;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned8;
import org.openmuc.jdlms.internal.asn1.iso.acse.AAREApdu;
import org.openmuc.jdlms.internal.asn1.iso.acse.AARQApdu;
import org.openmuc.jdlms.internal.asn1.iso.acse.ACSEApdu;
import org.openmuc.jdlms.internal.asn1.iso.acse.ACSERequirements;
import org.openmuc.jdlms.internal.asn1.iso.acse.AEInvocationIdentifier;
import org.openmuc.jdlms.internal.asn1.iso.acse.APTitle;
import org.openmuc.jdlms.internal.asn1.iso.acse.APTitleForm2;
import org.openmuc.jdlms.internal.asn1.iso.acse.ApplicationContextName;
import org.openmuc.jdlms.internal.asn1.iso.acse.AssociationInformation;
import org.openmuc.jdlms.internal.asn1.iso.acse.AuthenticationValue;
import org.openmuc.jdlms.internal.asn1.iso.acse.MechanismName;
import org.openmuc.jdlms.internal.asn1.iso.acse.RLRQApdu;
import org.openmuc.jdlms.internal.asn1.iso.acse.ReleaseRequestReason;
import org.openmuc.jdlms.internal.security.RandomSequenceGenerator;
import org.openmuc.jdlms.internal.security.authentication.HlsProcessorGmac;
import org.openmuc.jdlms.internal.security.authentication.HlsSecretProcessor;
import org.openmuc.jdlms.sessionlayer.client.SessionLayer;
import org.openmuc.jdlms.sessionlayer.client.SessionLayerListener;
import org.openmuc.jdlms.settings.client.ReferencingMethod;
import org.openmuc.jdlms.settings.client.Settings;

abstract class BaseDlmsConnection
implements BaseConnection {
    private static final int HIGH_PRIO_FLAG = 128;
    private static final int CONFIRMED_MODE_FLAG = 64;
    private final SessionLayer sessionLayer;
    private final APduBlockingQueue incomingApduQeue;
    private Set<ConformanceSetting> negotiatedFeatures;
    private final Settings settings;
    private byte[] serverSystemTitle;
    private byte[] buffer;
    private long frameCounter;
    private int invokeId;
    private int maxSendPduSize;
    private final ResponseQueue cosemResponseQ;

    BaseDlmsConnection(Settings settings, SessionLayer sessionLayer) {
        this.settings = settings;
        this.sessionLayer = sessionLayer;
        this.incomingApduQeue = new APduBlockingQueue();
        this.maxSendPduSize = 65535;
        this.buffer = new byte[this.maxSendPduSize];
        this.invokeId = 1;
        this.frameCounter = settings.frameCounter();
        this.cosemResponseQ = new ResponseQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void disconnect() throws IOException {
        try {
            ReleaseReqReason releaseReason = ReleaseReqReason.NORMAL;
            ReleaseRequestReason reason = new ReleaseRequestReason(releaseReason.getCode());
            AssociationInformation userInformation = null;
            RLRQApdu rlrq = new RLRQApdu();
            rlrq.setReason(reason);
            rlrq.setUserInformation(userInformation);
            ACSEApdu acseApdu = new ACSEApdu();
            acseApdu.setRlrq(rlrq);
            COSEMpdu cosemPdu = null;
            APdu aPduOut = new APdu(acseApdu, cosemPdu);
            RawMessageData.RawMessageDataBuilder rawMessageBuilder = this.newRawMessageDataBuilder();
            int length = this.unencryptedEncode(aPduOut, rawMessageBuilder);
            this.incomingApduQeue.clear();
            int offset = this.buffer.length - length;
            this.sessionLayer.send(this.buffer, offset, length, rawMessageBuilder);
            APdu aPdu = null;
            try {
                aPdu = this.incomingApduQeue.poll(this.settings.responseTimeout(), TimeUnit.MILLISECONDS);
                if (aPdu == null) {
                    throw new ResponseTimeoutException("Disconnect timed out.");
                }
                if (aPdu.getAcseAPdu() == null) {
                    throw new FatalJDlmsException(JDlmsException.ExceptionId.CONNECTION_DISCONNECT_ERROR, JDlmsException.Fault.SYSTEM, "Server did not answer on disconnect");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.sessionLayer.close();
    }

    @Override
    public void changeClientGlobalAuthenticationKey(byte[] key) {
        this.settings.updateAuthenticationKey(key);
    }

    @Override
    public void changeClientGlobalEncryptionKey(byte[] key) {
        this.settings.updateGlobalEncryptionKey(key);
    }

    void connect() throws IOException {
        this.sessionLayer.startListening(new SessionLayerListenerImpl());
        ContextId contextId = this.getContextId();
        HlsProcessorGmac hlsSecretProcessor = null;
        byte[] clientToServerChallenge = null;
        SecuritySuite securitySuite = this.settings.securitySuite();
        AEInvocationIdentifier aeInvocationIdentifier = this.aeInvocationIdentifier(this.settings.userId());
        ApplicationContextName applicationContextName = ObjectIdentifier.applicationContextNameFrom(contextId);
        MechanismName mechanismName = ObjectIdentifier.mechanismNameFrom(this.settings.securitySuite().getAuthenticationMechanism());
        AARQApdu aarq = new AARQApdu();
        aarq.setCallingAEInvocationIdentifier(aeInvocationIdentifier);
        aarq.setApplicationContextName(applicationContextName);
        aarq.setMechanismName(mechanismName);
        AuthenticationMechanism authMechanism = securitySuite.getAuthenticationMechanism();
        switch (authMechanism) {
            case LOW: {
                BaseDlmsConnection.setupAarqAuthentication(aarq, securitySuite.getPassword());
                break;
            }
            case NONE: {
                break;
            }
            case HLS5_GMAC: {
                clientToServerChallenge = RandomSequenceGenerator.generateNewChallenge(this.settings.challengeLength());
                BaseDlmsConnection.setupAarqAuthentication(aarq, clientToServerChallenge);
                hlsSecretProcessor = new HlsProcessorGmac();
                APTitle clientApTitle = new APTitle();
                clientApTitle.setApTitleForm2(new APTitleForm2(this.settings.systemTitle()));
                aarq.setCallingAPTitle(clientApTitle);
                aarq.setSenderAcseRequirements(new ACSERequirements(new byte[]{-128}, 1));
                break;
            }
            default: {
                String msg = MessageFormat.format("Authentication {0} mechanism not supported.", new Object[]{authMechanism});
                throw new IllegalArgumentException(msg);
            }
        }
        ACSEApdu aarqAcseAPdu = new ACSEApdu();
        aarqAcseAPdu.setAarq(aarq);
        COSEMpdu xDlmsInitiateRequestPdu = new COSEMpdu();
        xDlmsInitiateRequestPdu.setInitiateRequest(this.newInitReq());
        APdu aarqAPdu = new APdu(aarqAcseAPdu, xDlmsInitiateRequestPdu);
        RawMessageData.RawMessageDataBuilder rawMessageBuilder = this.newRawMessageDataBuilder();
        try {
            int length = this.encodeAPdu(aarqAPdu, rawMessageBuilder);
            this.sessionLayer.send(this.buffer, this.buffer.length - length, length, rawMessageBuilder);
        }
        catch (IOException e) {
            this.closeUnsafe();
            throw e;
        }
        this.processInitResponse(hlsSecretProcessor, clientToServerChallenge, this.waitForServerResponseAPdu());
    }

    private AEInvocationIdentifier aeInvocationIdentifier(int userId) {
        if (userId < 0) {
            return null;
        }
        return new AEInvocationIdentifier(this.settings.userId());
    }

    Settings connectionSettings() {
        return this.settings;
    }

    abstract ContextId getContextId();

    boolean confirmedModeEnabled() {
        return true;
    }

    Set<ConformanceSetting> negotiatedFeatures() {
        return this.negotiatedFeatures;
    }

    int maxSendPduSize() {
        return this.maxSendPduSize;
    }

    InvokeIdAndPriority invokeIdAndPriorityFor(boolean priority) {
        byte[] invokeIdAndPriorityBytes = new byte[]{(byte)(this.invokeId & 0xF)};
        if (this.confirmedModeEnabled()) {
            invokeIdAndPriorityBytes[0] = (byte)(invokeIdAndPriorityBytes[0] | 0x40);
        }
        if (priority) {
            invokeIdAndPriorityBytes[0] = (byte)(invokeIdAndPriorityBytes[0] | 0x80);
        }
        InvokeIdAndPriority result = new InvokeIdAndPriority(invokeIdAndPriorityBytes);
        this.invokeId = (this.invokeId + 1) % 16;
        return result;
    }

    synchronized <T extends AxdrType> T send(COSEMpdu pdu) throws IOException {
        this.cosemResponseQ.clear();
        APdu aPdu = new APdu(null, pdu);
        RawMessageData.RawMessageDataBuilder rawMessageBuilder = RawMessageData.builder().setMessageSource(RawMessageData.MessageSource.CLIENT);
        int length = this.encodeAPdu(aPdu, rawMessageBuilder);
        int offset = this.buffer.length - length;
        this.sessionLayer.send(this.buffer, offset, length, rawMessageBuilder);
        COSEMpdu responsePdu = this.pollValidResponsePdu();
        switch (responsePdu.getChoiceIndex()) {
            case ACTION_RESPONSE: {
                return (T)responsePdu.actionResponse;
            }
            case GET_RESPONSE: {
                return (T)responsePdu.getResponse;
            }
            case SET_RESPONSE: {
                return (T)responsePdu.setResponse;
            }
            case READRESPONSE: {
                return (T)responsePdu.readResponse;
            }
            case WRITERESPONSE: {
                return (T)responsePdu.writeResponse;
            }
        }
        throw new FatalJDlmsException(JDlmsException.ExceptionId.ILLEGAL_RESPONSE, JDlmsException.Fault.SYSTEM, MessageFormat.format("The response type {0} was not expected.", new Object[]{responsePdu.getChoiceIndex()}));
    }

    abstract Set<ConformanceSetting> proposedConformance();

    abstract void validateReferencingMethod() throws IOException;

    abstract MethodResult authenticateViaHls(byte[] var1) throws IOException;

    abstract void processEventPdu(COSEMpdu var1);

    private COSEMpdu pollValidResponsePdu() throws IOException {
        COSEMpdu responsePdu = this.cosemResponseQ.poll(this.settings.responseTimeout(), TimeUnit.MILLISECONDS);
        if (this.settings.referencingMethod() == ReferencingMethod.LOGICAL) {
            for (int i = 0; i < 3; ++i) {
                int invokeIdFromPdu = PduHelper.invokeIdFrom(responsePdu);
                int prevId = (this.invokeId - 1) % 16;
                if (prevId < 0) {
                    prevId += 16;
                }
                if (invokeIdFromPdu == prevId) {
                    return responsePdu;
                }
                responsePdu = this.cosemResponseQ.poll(this.settings.responseTimeout(), TimeUnit.MILLISECONDS);
            }
        } else if (this.settings.referencingMethod() == ReferencingMethod.SHORT) {
            return responsePdu;
        }
        throw new FatalJDlmsException(JDlmsException.ExceptionId.ILLEGAL_RESPONSE, JDlmsException.Fault.SYSTEM, MessageFormat.format("The response {0} was not expected.", responsePdu));
    }

    private InitiateRequest newInitReq() {
        AxdrOctetString dedicatedKey = null;
        AxdrBoolean confirmedMode = new AxdrBoolean(true);
        Integer8 proposedQualityOfService = null;
        Unsigned8 propDlmsVersion = new Unsigned8(6L);
        Conformance proposedConformance = ConformanceSettingConverter.conformanceFor(this.proposedConformance());
        Unsigned16 clientMaxReceivePduSize = new Unsigned16(65535L);
        return new InitiateRequest(dedicatedKey, confirmedMode, proposedQualityOfService, propDlmsVersion, proposedConformance, clientMaxReceivePduSize);
    }

    private RawMessageData.RawMessageDataBuilder newRawMessageDataBuilder() {
        if (this.settings.rawMessageListener() == null) {
            return null;
        }
        return RawMessageData.builder();
    }

    private int encodeAPdu(APdu aPdu, RawMessageData.RawMessageDataBuilder rawMessageBuilder) throws IOException {
        SecuritySuite securitySuite = this.settings.securitySuite();
        if (securitySuite.getEncryptionMechanism() != SecuritySuite.EncryptionMechanism.NONE) {
            return aPdu.encode(this.buffer, this.frameCounter++, this.settings.systemTitle(), securitySuite, rawMessageBuilder);
        }
        return this.unencryptedEncode(aPdu, rawMessageBuilder);
    }

    private int unencryptedEncode(APdu aPdu, RawMessageData.RawMessageDataBuilder rawMessageBuilder) throws IOException {
        return aPdu.encode(this.buffer, rawMessageBuilder);
    }

    private void processInitResponse(HlsSecretProcessor hlsSecretProcessor, byte[] clientToServerChallenge, APdu responseAPdu) throws IOException {
        this.validateConnectConfirm(responseAPdu);
        AAREApdu aare = responseAPdu.getAcseAPdu().getAare();
        if (this.settings.securitySuite().getAuthenticationMechanism().isHlsMechanism()) {
            this.serverSystemTitle = aare.getRespondingAPTitle().getApTitleForm2().value;
        }
        COSEMpdu xDlmsInitResponse = responseAPdu.getCosemPdu();
        InitiateResponse initiateResponse = xDlmsInitResponse.initiateResponse;
        this.maxSendPduSize = (int)initiateResponse.serverMaxReceivePduSize.getValue();
        if (this.maxSendPduSize == 0) {
            this.maxSendPduSize = 65535;
        }
        if (this.buffer.length < this.maxSendPduSize) {
            this.buffer = new byte[this.maxSendPduSize];
        }
        this.negotiatedFeatures = ConformanceSettingConverter.conformanceSettingFor(initiateResponse.negotiatedConformance);
        this.validateReferencingMethod();
        AuthenticationMechanism authenticationMechanism = this.settings.securitySuite().getAuthenticationMechanism();
        switch (authenticationMechanism) {
            case HLS5_GMAC: {
                this.hls5Connect(hlsSecretProcessor, clientToServerChallenge, aare);
                break;
            }
        }
    }

    private void hls5Connect(HlsSecretProcessor hlsSecretProcessor, byte[] cToSChallange, AAREApdu aare) throws IOException {
        int serverFc;
        byte[] processedCtoS;
        byte[] clientSystemTitle;
        byte[] serverToClientChallenge = aare.getRespondingAuthenticationValue().getCharstring().value;
        SecuritySuite securitySuite = this.settings.securitySuite();
        byte[] processedStoC = hlsSecretProcessor.process(serverToClientChallenge, securitySuite, clientSystemTitle = this.settings.systemTitle(), this.frameCounter);
        byte[] remoteProcessedCtoS = this.callHls5Auth(processedStoC);
        if (!Arrays.equals(remoteProcessedCtoS, processedCtoS = hlsSecretProcessor.process(cToSChallange, securitySuite, this.serverSystemTitle, serverFc = ByteBuffer.wrap(remoteProcessedCtoS, 1, 4).getInt()))) {
            String message = "Server could not authenticate itself. Potential 'Man in the Middle' attack.";
            throw new FatalJDlmsException(JDlmsException.ExceptionId.AUTHENTICATION_ERROR, JDlmsException.Fault.SYSTEM, message);
        }
    }

    private byte[] callHls5Auth(byte[] processedChallenge) throws IOException {
        MethodResult remoteResponse;
        try {
            remoteResponse = this.authenticateViaHls(processedChallenge);
        }
        catch (ResponseTimeoutException e) {
            throw new FatalJDlmsException(JDlmsException.ExceptionId.CONNECTION_ESTABLISH_ERROR, JDlmsException.Fault.SYSTEM, "Server replied late in HLS exchange.", e);
        }
        catch (JDlmsException e) {
            throw BaseDlmsConnection.createNewAuthErrorEx(e, e.getAssumedFault());
        }
        catch (IOException e) {
            throw BaseDlmsConnection.createNewAuthErrorEx(e, JDlmsException.Fault.USER);
        }
        if (remoteResponse.getResultCode() != MethodResultCode.SUCCESS || remoteResponse.getResultData().getType() != DataObject.Type.OCTET_STRING) {
            throw new FatalJDlmsException(JDlmsException.ExceptionId.AUTHENTICATION_ERROR, JDlmsException.Fault.USER, "Failed to authenticate to server. HLS authentication step 4.");
        }
        return (byte[])remoteResponse.getResultData().getValue();
    }

    private static FatalJDlmsException createNewAuthErrorEx(IOException e, JDlmsException.Fault assumedFault) {
        return new FatalJDlmsException(JDlmsException.ExceptionId.AUTHENTICATION_ERROR, assumedFault, "Exception during HLS authentication steps 3 and 4", e);
    }

    private APdu waitForServerResponseAPdu() throws IOException {
        try {
            return this.incomingApduQeue.poll(this.settings.responseTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    private void validateConnectConfirm(APdu decodedResponsePdu) throws IOException {
        if (decodedResponsePdu == null) {
            String msg = "Timeout waiting for associate response message (AARE). No further information.";
            throw new FatalJDlmsException(JDlmsException.ExceptionId.CONNECTION_ESTABLISH_ERROR, JDlmsException.Fault.SYSTEM, msg);
        }
        if (decodedResponsePdu.getAcseAPdu() == null || decodedResponsePdu.getAcseAPdu().getAare() == null) {
            String msg = "Did not receive expected associate response (AARE) message.";
            throw new FatalJDlmsException(JDlmsException.ExceptionId.CONNECTION_ESTABLISH_ERROR, JDlmsException.Fault.SYSTEM, msg);
        }
    }

    private void closeUnsafe() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void setupAarqAuthentication(AARQApdu aarq, byte[] clientToServerChallenge) {
        aarq.setSenderAcseRequirements(new ACSERequirements(new byte[]{-128}, 1));
        AuthenticationValue authenticationValue = new AuthenticationValue();
        authenticationValue.setCharstring(new BerOctetString(clientToServerChallenge));
        aarq.setCallingAuthenticationValue(authenticationValue);
    }

    private class SessionLayerListenerImpl
    implements SessionLayerListener {
        private SessionLayerListenerImpl() {
        }

        @Override
        public void dataReceived(byte[] data, RawMessageData.RawMessageDataBuilder rawMessageBuilder) {
            APdu aPdu;
            try {
                aPdu = this.decodeApdu(data, rawMessageBuilder);
                COSEMpdu cosemPdu = aPdu.getCosemPdu();
                if (cosemPdu != null && this.checkForErrors(cosemPdu)) {
                    return;
                }
            }
            catch (IOException e) {
                this.errorOccurred(e);
                return;
            }
            RawMessageListener rawMessageListener = BaseDlmsConnection.this.settings.rawMessageListener();
            if (rawMessageListener != null) {
                RawMessageData rawMessageData = rawMessageBuilder.setMessageSource(RawMessageData.MessageSource.SERVER).build();
                rawMessageListener.messageCaptured(rawMessageData);
            }
            if (aPdu.getAcseAPdu() != null) {
                BaseDlmsConnection.this.incomingApduQeue.put(aPdu);
            } else {
                COSEMpdu cosemPdu = aPdu.getCosemPdu();
                switch (cosemPdu.getChoiceIndex()) {
                    case ACTION_RESPONSE: 
                    case GET_RESPONSE: 
                    case SET_RESPONSE: 
                    case READRESPONSE: 
                    case WRITERESPONSE: {
                        BaseDlmsConnection.this.cosemResponseQ.put(cosemPdu);
                        break;
                    }
                    case EVENT_NOTIFICATION_REQUEST: 
                    case INFORMATIONREPORTREQUEST: {
                        BaseDlmsConnection.this.processEventPdu(cosemPdu);
                        break;
                    }
                }
            }
        }

        private APdu decodeApdu(byte[] data, RawMessageData.RawMessageDataBuilder rawMessageBuilder) throws IOException {
            SecuritySuite securitySuite = BaseDlmsConnection.this.settings.securitySuite();
            APdu aPdu = securitySuite.getEncryptionMechanism() != SecuritySuite.EncryptionMechanism.NONE ? APdu.decode(data, BaseDlmsConnection.this.serverSystemTitle, securitySuite, rawMessageBuilder) : APdu.decode(data, rawMessageBuilder);
            return aPdu;
        }

        @Override
        public void connectionInterrupted(IOException e) {
            this.errorOccurred(e);
        }

        private boolean checkForErrors(COSEMpdu cosemPdu) {
            COSEMpdu.Choices choiceIndex = cosemPdu.getChoiceIndex();
            if (choiceIndex == COSEMpdu.Choices.EXCEPTION_RESPONSE) {
                ExceptionResponse exceptionResponse = cosemPdu.exceptionResponse;
                this.errorOccurred(new IOException(exceptionResponse.toString()));
                return true;
            }
            if (choiceIndex == COSEMpdu.Choices.CONFIRMEDSERVICEERROR) {
                ConfirmedServiceError confirmedServiceError = cosemPdu.confirmedServiceError;
                this.errorOccurred(new IOException(confirmedServiceError.toString()));
                return true;
            }
            return false;
        }

        private void errorOccurred(IOException ex) {
            if (BaseDlmsConnection.this.cosemResponseQ.beingPolled()) {
                BaseDlmsConnection.this.cosemResponseQ.putError(ex);
            } else {
                BaseDlmsConnection.this.incomingApduQeue.putError(ex);
            }
        }
    }
}

