/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openmuc.jdlms.AccessResultCode;
import org.openmuc.jdlms.AccessResultImpl;
import org.openmuc.jdlms.AttributeAddress;
import org.openmuc.jdlms.BaseDlmsConnection;
import org.openmuc.jdlms.ConformanceSetting;
import org.openmuc.jdlms.FatalJDlmsException;
import org.openmuc.jdlms.GetResult;
import org.openmuc.jdlms.JDlmsException;
import org.openmuc.jdlms.MethodParameter;
import org.openmuc.jdlms.MethodResult;
import org.openmuc.jdlms.MethodResultCode;
import org.openmuc.jdlms.NonFatalJDlmsException;
import org.openmuc.jdlms.ResponseTimeoutException;
import org.openmuc.jdlms.SecuritySuite;
import org.openmuc.jdlms.SelectiveAccessDescription;
import org.openmuc.jdlms.SetParameter;
import org.openmuc.jdlms.datatypes.DataObject;
import org.openmuc.jdlms.internal.ContextId;
import org.openmuc.jdlms.internal.DataConverter;
import org.openmuc.jdlms.internal.DlmsEnumFunctions;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.NullOutputStream;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOptional;
import org.openmuc.jdlms.internal.asn1.cosem.ActionRequest;
import org.openmuc.jdlms.internal.asn1.cosem.ActionRequestNextPblock;
import org.openmuc.jdlms.internal.asn1.cosem.ActionRequestNormal;
import org.openmuc.jdlms.internal.asn1.cosem.ActionRequestWithList;
import org.openmuc.jdlms.internal.asn1.cosem.ActionResponse;
import org.openmuc.jdlms.internal.asn1.cosem.ActionResponseWithList;
import org.openmuc.jdlms.internal.asn1.cosem.ActionResponseWithOptionalData;
import org.openmuc.jdlms.internal.asn1.cosem.COSEMpdu;
import org.openmuc.jdlms.internal.asn1.cosem.CosemAttributeDescriptor;
import org.openmuc.jdlms.internal.asn1.cosem.CosemAttributeDescriptorWithSelection;
import org.openmuc.jdlms.internal.asn1.cosem.Data;
import org.openmuc.jdlms.internal.asn1.cosem.GetDataResult;
import org.openmuc.jdlms.internal.asn1.cosem.GetRequest;
import org.openmuc.jdlms.internal.asn1.cosem.GetRequestNext;
import org.openmuc.jdlms.internal.asn1.cosem.GetRequestNormal;
import org.openmuc.jdlms.internal.asn1.cosem.GetRequestWithList;
import org.openmuc.jdlms.internal.asn1.cosem.GetResponse;
import org.openmuc.jdlms.internal.asn1.cosem.GetResponseWithList;
import org.openmuc.jdlms.internal.asn1.cosem.InvokeIdAndPriority;
import org.openmuc.jdlms.internal.asn1.cosem.SelectiveAccessDescriptor;
import org.openmuc.jdlms.internal.asn1.cosem.SetRequest;
import org.openmuc.jdlms.internal.asn1.cosem.SetRequestNormal;
import org.openmuc.jdlms.internal.asn1.cosem.SetRequestWithList;
import org.openmuc.jdlms.internal.asn1.cosem.SetResponse;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned8;
import org.openmuc.jdlms.sessionlayer.client.SessionLayer;
import org.openmuc.jdlms.settings.client.Settings;

class DlmsLnConnectionImpl
extends BaseDlmsConnection {
    DlmsLnConnectionImpl(Settings settings, SessionLayer sessionlayer) throws IOException {
        super(settings, sessionlayer);
    }

    public synchronized List<GetResult> get(boolean priority, List<AttributeAddress> params) throws IOException {
        if (params.isEmpty()) {
            return Collections.emptyList();
        }
        InvokeIdAndPriority id = this.invokeIdAndPriorityFor(priority);
        COSEMpdu pdu = this.createGetPdu(id, params);
        int pduSize = DlmsLnConnectionImpl.pduSizeOf(pdu);
        if (this.maxSendPduSize() != 0 && pduSize > this.maxSendPduSize()) {
            if (params.size() > 1) {
                return this.callEachGetIndividually(priority, params);
            }
            throw new NonFatalJDlmsException(JDlmsException.ExceptionId.GET_REQUEST_TOO_LARGE, JDlmsException.Fault.USER, MessageFormat.format("PDU ({0} byte) is too long for single GET.request. Max send PDU size is {1} byte.", pduSize, this.maxSendPduSize()));
        }
        GetResponse response = (GetResponse)this.send(pdu);
        switch (response.getChoiceIndex()) {
            case GET_RESPONSE_NORMAL: {
                return Arrays.asList(DlmsLnConnectionImpl.convertPduToGetResult(response.getResponseNormal.result));
            }
            case GET_RESPONSE_WITH_DATABLOCK: {
                return this.readDataBlockG(response, params);
            }
            case GET_RESPONSE_WITH_LIST: {
                return DlmsLnConnectionImpl.convertListToDataObject(response.getResponseWithList.result.list());
            }
        }
        String msg = String.format("Unknown response type with Choice Index %s. Please report to developer of the stack.", new Object[]{response.getChoiceIndex()});
        throw new IllegalStateException(msg);
    }

    private List<GetResult> callEachGetIndividually(boolean priority, List<AttributeAddress> params) throws IOException {
        ArrayList<GetResult> res = new ArrayList<GetResult>(params.size());
        for (AttributeAddress param : params) {
            res.add(this.get(priority, Arrays.asList(param)).get(0));
        }
        return res;
    }

    private List<GetResult> readDataBlockG(GetResponse response, List<AttributeAddress> params) throws IOException {
        byte[] byteArray = this.readBlocksGet(response);
        ByteArrayInputStream dataByteStream = new ByteArrayInputStream(byteArray);
        if (params.size() == 1) {
            Data resultPduData = new Data();
            resultPduData.decode(dataByteStream);
            GetDataResult getResult = new GetDataResult();
            getResult.setData(resultPduData);
            return Arrays.asList(DlmsLnConnectionImpl.convertPduToGetResult(getResult));
        }
        GetResponseWithList.SubSeqOfResult subSeqOfResult = new GetResponseWithList.SubSeqOfResult();
        subSeqOfResult.decode(dataByteStream);
        return DlmsLnConnectionImpl.convertListToDataObject(subSeqOfResult.list());
    }

    private byte[] readBlocksGet(GetResponse response) throws IOException {
        InvokeIdAndPriority invokeIdAndPriority = response.getResponseWithDatablock.invokeIdAndPriority;
        ByteArrayOutputStream datablocks = new ByteArrayOutputStream();
        GetRequest getRequest = new GetRequest();
        COSEMpdu pdu = new COSEMpdu();
        GetRequestNext nextBlock = new GetRequestNext();
        GetResponse newRes = response;
        while (!newRes.getResponseWithDatablock.result.lastBlock.getValue()) {
            datablocks.write(newRes.getResponseWithDatablock.result.result.rawData.getValue());
            nextBlock.blockNumber = newRes.getResponseWithDatablock.result.blockNumber;
            nextBlock.invokeIdAndPriority = invokeIdAndPriority;
            getRequest.setGetRequestNext(nextBlock);
            pdu.setGetRequest(getRequest);
            try {
                newRes = (GetResponse)this.send(pdu);
            }
            catch (ResponseTimeoutException e) {
                this.send(pdu);
                throw e;
            }
        }
        datablocks.write(newRes.getResponseWithDatablock.result.result.rawData.getValue());
        return datablocks.toByteArray();
    }

    public synchronized List<AccessResultCode> set(boolean priority, List<SetParameter> params) throws IOException {
        if (params.isEmpty()) {
            return Collections.emptyList();
        }
        InvokeIdAndPriority invokeIdAndPriority = this.invokeIdAndPriorityFor(priority);
        SetResponse response = this.createAndSendSetPdu(invokeIdAndPriority, params);
        switch (response.getChoiceIndex()) {
            case SET_RESPONSE_NORMAL: {
                return DlmsLnConnectionImpl.axdrEnumToAccessResultCode(response.setResponseNormal.result);
            }
            case SET_RESPONSE_WITH_LIST: {
                return DlmsLnConnectionImpl.axdrEnumsToAccessResultCodes(response.setResponseWithList.result.list());
            }
            case SET_RESPONSE_LAST_DATABLOCK: {
                return DlmsLnConnectionImpl.axdrEnumToAccessResultCode(response.setResponseLastDatablock.result);
            }
            case SET_RESPONSE_LAST_DATABLOCK_WITH_LIST: {
                return DlmsLnConnectionImpl.axdrEnumsToAccessResultCodes(response.setResponseLastDatablockWithList.result.list());
            }
        }
        throw new IllegalStateException("Unknown response type");
    }

    private static List<AccessResultCode> axdrEnumToAccessResultCode(AxdrEnum axdrEnum) {
        return Arrays.asList(DlmsEnumFunctions.enumValueFrom(axdrEnum, AccessResultCode.class));
    }

    private static List<AccessResultCode> axdrEnumsToAccessResultCodes(List<AxdrEnum> enums) {
        ArrayList<AccessResultCode> result = new ArrayList<AccessResultCode>(enums.size());
        for (AxdrEnum axdrEnum : enums) {
            result.add(DlmsEnumFunctions.enumValueFrom(axdrEnum, AccessResultCode.class));
        }
        return result;
    }

    public synchronized List<MethodResult> action(boolean priority, List<MethodParameter> params) throws IOException {
        if (params.isEmpty()) {
            return Collections.emptyList();
        }
        InvokeIdAndPriority id = this.invokeIdAndPriorityFor(priority);
        ActionResponse response = this.createAndSendActionPdu(id, params);
        switch (response.getChoiceIndex()) {
            case ACTION_RESPONSE_NORMAL: {
                return this.processActionNormal(response);
            }
            case ACTION_RESPONSE_WITH_LIST: {
                return this.processActionWithList(response);
            }
            case ACTION_RESPONSE_WITH_PBLOCK: {
                return this.processActionWithPblock(response);
            }
        }
        throw new IllegalStateException("Server answered with an illegal response.");
    }

    private List<MethodResult> processActionNormal(ActionResponse response) {
        ActionResponseWithOptionalData resWithOpt = response.actionResponseNormal.singleResponse;
        MethodResult methodResult = DlmsLnConnectionImpl.convertActionResponseToMethodResult(resWithOpt);
        return Arrays.asList(methodResult);
    }

    private List<MethodResult> processActionWithList(ActionResponse response) {
        ActionResponseWithList.SubSeqOfListOfResponses listOfResponses = response.actionResponseWithList.listOfResponses;
        ArrayList<MethodResult> result = new ArrayList<MethodResult>(listOfResponses.size());
        Iterator iter = listOfResponses.iterator();
        while (iter.hasNext()) {
            MethodResult methodResult = DlmsLnConnectionImpl.convertActionResponseToMethodResult((ActionResponseWithOptionalData)iter.next());
            result.add(methodResult);
        }
        return result;
    }

    private List<MethodResult> processActionWithPblock(ActionResponse response) throws IOException {
        ByteArrayOutputStream datablocks = new ByteArrayOutputStream();
        COSEMpdu pdu = new COSEMpdu();
        ActionRequest request = new ActionRequest();
        ActionRequestNextPblock nextBlock = new ActionRequestNextPblock();
        ActionResponse intermediateResponse = response;
        nextBlock.invokeIdAndPriority = intermediateResponse.actionResponseWithPblock.invokeIdAndPriority;
        while (!intermediateResponse.actionResponseWithPblock.pblock.lastBlock.getValue()) {
            datablocks.write(intermediateResponse.actionResponseWithPblock.pblock.rawData.getValue());
            nextBlock.blockNumber = intermediateResponse.actionResponseWithPblock.pblock.blockNumber;
            request.setActionRequestNextPblock(nextBlock);
            pdu.setActionRequest(request);
            intermediateResponse = (ActionResponse)this.send(pdu);
        }
        datablocks.write(intermediateResponse.actionResponseWithPblock.pblock.rawData.getValue());
        ByteArrayInputStream dataByteStream = new ByteArrayInputStream(datablocks.toByteArray());
        return DlmsLnConnectionImpl.decodeAndConvertActionStream(dataByteStream);
    }

    private static List<MethodResult> decodeAndConvertActionStream(InputStream is) throws IOException {
        LinkedList<MethodResult> result = new LinkedList<MethodResult>();
        while (is.available() > 0) {
            GetDataResult dataResult = new GetDataResult();
            dataResult.decode(is);
            DataObject resultData = DataConverter.convertDataToDataObject(dataResult.data);
            result.add(new MethodResult(MethodResultCode.SUCCESS, resultData));
        }
        return result;
    }

    private COSEMpdu createGetPdu(InvokeIdAndPriority id, List<AttributeAddress> params) {
        if (!this.negotiatedFeatures().contains((Object)ConformanceSetting.ATTRIBUTE0_SUPPORTED_WITH_GET)) {
            DlmsLnConnectionImpl.checkAttributeId(params);
        }
        if (!this.negotiatedFeatures().contains((Object)ConformanceSetting.SELECTIVE_ACCESS)) {
            for (AttributeAddress param : params) {
                if (param.getAccessSelection() == null) continue;
                throw new IllegalArgumentException("Selective Access not supported on this connection");
            }
        }
        GetRequest getRequest = new GetRequest();
        if (params.size() == 1) {
            GetRequestNormal requestNormal = new GetRequestNormal();
            requestNormal.invokeIdAndPriority = id;
            AttributeAddress attributeAddress = params.get(0);
            requestNormal.cosemAttributeDescriptor = attributeAddress.toDescriptor();
            SelectiveAccessDescription accessSelection = attributeAddress.getAccessSelection();
            SelectiveAccessDescriptor access = DlmsLnConnectionImpl.selToSelectivAccessDesciptor(accessSelection);
            requestNormal.accessSelection.setValue(access);
            getRequest.setGetRequestNormal(requestNormal);
        } else {
            GetRequestWithList requestList = new GetRequestWithList();
            requestList.invokeIdAndPriority = id;
            requestList.attributeDescriptorList = new GetRequestWithList.SubSeqOfAttributeDescriptorList();
            for (AttributeAddress param : params) {
                SelectiveAccessDescription accessSelection = param.getAccessSelection();
                SelectiveAccessDescriptor access = DlmsLnConnectionImpl.selToSelectivAccessDesciptor(accessSelection);
                CosemAttributeDescriptorWithSelection element = new CosemAttributeDescriptorWithSelection(param.toDescriptor(), access);
                requestList.attributeDescriptorList.add(element);
            }
            getRequest.setGetRequestWithList(requestList);
        }
        COSEMpdu pdu = new COSEMpdu();
        pdu.setGetRequest(getRequest);
        return pdu;
    }

    private SetResponse createAndSendSetPdu(InvokeIdAndPriority id, List<SetParameter> params) throws IOException {
        if (!this.negotiatedFeatures().contains((Object)ConformanceSetting.ATTRIBUTE0_SUPPORTED_WITH_SET)) {
            for (SetParameter param : params) {
                if (param.getAttributeAddress().getId() != 0) continue;
                throw new IllegalArgumentException("No Attribute 0 on set allowed");
            }
        }
        SetRequest request = new SetRequest();
        if (params.size() == 1) {
            SetRequestNormal requestNormal = new SetRequestNormal();
            requestNormal.invokeIdAndPriority = id;
            SetParameter setParameter = params.get(0);
            AttributeAddress attributeAddress = setParameter.getAttributeAddress();
            SelectiveAccessDescription accessSelection = attributeAddress.getAccessSelection();
            SelectiveAccessDescriptor access = DlmsLnConnectionImpl.selToSelectivAccessDesciptor(accessSelection);
            requestNormal.cosemAttributeDescriptor = attributeAddress.toDescriptor();
            requestNormal.value = DataConverter.convertDataObjectToData(setParameter.getData());
            requestNormal.accessSelection.setValue(access);
            request.setSetRequestNormal(requestNormal);
        } else {
            SetRequestWithList requestList = new SetRequestWithList();
            requestList.invokeIdAndPriority = id;
            requestList.attributeDescriptorList = new SetRequestWithList.SubSeqOfAttributeDescriptorList();
            requestList.valueList = new SetRequestWithList.SubSeqOfValueList();
            for (SetParameter param : params) {
                AttributeAddress attributeAddress = param.getAttributeAddress();
                SelectiveAccessDescription accessSelection = attributeAddress.getAccessSelection();
                SelectiveAccessDescriptor access = DlmsLnConnectionImpl.selToSelectivAccessDesciptor(accessSelection);
                CosemAttributeDescriptor desc = attributeAddress.toDescriptor();
                requestList.attributeDescriptorList.add(new CosemAttributeDescriptorWithSelection(desc, access));
                requestList.valueList.add(DataConverter.convertDataObjectToData(param.getData()));
            }
            request.setSetRequestWithList(requestList);
        }
        if (this.maxSendPduSize() == 0 || DlmsLnConnectionImpl.pduSizeOf(request) <= this.maxSendPduSize()) {
            COSEMpdu pdu = new COSEMpdu();
            pdu.setSetRequest(request);
            return (SetResponse)this.send(pdu);
        }
        throw new IOException("Receiving fragments not yet implemented..");
    }

    private static SelectiveAccessDescriptor selToSelectivAccessDesciptor(SelectiveAccessDescription accessSelection) {
        if (accessSelection == null) {
            return null;
        }
        Unsigned8 accessSelector = new Unsigned8(accessSelection.getAccessSelector());
        Data dataObjectToData = DataConverter.convertDataObjectToData(accessSelection.getAccessParameter());
        return new SelectiveAccessDescriptor(accessSelector, dataObjectToData);
    }

    private ActionResponse createAndSendActionPdu(InvokeIdAndPriority invokeIdAndPrio, List<MethodParameter> params) throws IOException {
        for (MethodParameter param : params) {
            if (param.getId() != 0) continue;
            throw new IllegalArgumentException("Method ID 0 not allowed on action");
        }
        ActionRequest request = new ActionRequest();
        if (params.size() == 1) {
            MethodParameter methodParameter = params.get(0);
            ActionRequestNormal requestNormal = new ActionRequestNormal();
            boolean paramIsUsed = !methodParameter.getParameter().isNull();
            requestNormal.invokeIdAndPriority = invokeIdAndPrio;
            requestNormal.cosemMethodDescriptor = methodParameter.toDescriptor();
            AxdrOptional<Data> invocationParam = requestNormal.methodInvocationParameters;
            invocationParam.setUsed(paramIsUsed);
            if (paramIsUsed) {
                Data convertedData = DataConverter.convertDataObjectToData(methodParameter.getParameter());
                invocationParam.setValue(convertedData);
            }
            request.setActionRequestNormal(requestNormal);
        } else {
            ActionRequestWithList requestList = new ActionRequestWithList();
            requestList.invokeIdAndPriority = invokeIdAndPrio;
            requestList.cosemMethodDescriptorList = new ActionRequestWithList.SubSeqOfCosemMethodDescriptorList();
            requestList.methodInvocationParameters = new ActionRequestWithList.SubSeqOfMethodInvocationParameters();
            for (MethodParameter param : params) {
                requestList.cosemMethodDescriptorList.add(param.toDescriptor());
                requestList.methodInvocationParameters.add(DataConverter.convertDataObjectToData(param.getParameter()));
            }
            request.setActionRequestWithList(requestList);
        }
        if (this.maxSendPduSize() == 0 || DlmsLnConnectionImpl.pduSizeOf(request) <= this.maxSendPduSize()) {
            COSEMpdu pdu = new COSEMpdu();
            pdu.setActionRequest(request);
            return (ActionResponse)this.send(pdu);
        }
        throw new IOException("this is not yet implemented..");
    }

    private static void checkAttributeId(List<AttributeAddress> params) {
        for (AttributeAddress param : params) {
            if (param.getId() != 0) continue;
            throw new IllegalArgumentException("No Attribute 0 on get allowed");
        }
    }

    private static int pduSizeOf(AxdrType pdu) throws IOException {
        return pdu.encode(new NullOutputStream());
    }

    private static MethodResult convertActionResponseToMethodResult(ActionResponseWithOptionalData resp) {
        DataObject resultData = null;
        if (resp.returnParameters.isUsed()) {
            resultData = DataConverter.convertDataToDataObject(resp.returnParameters.getValue().data);
        }
        MethodResultCode methodResultCode = DlmsEnumFunctions.enumValueFrom(resp.result, MethodResultCode.class);
        return new MethodResult(methodResultCode, resultData);
    }

    private static List<GetResult> convertListToDataObject(List<GetDataResult> resultList) {
        ArrayList<GetResult> result = new ArrayList<GetResult>(resultList.size());
        for (GetDataResult resultPdu : resultList) {
            GetResult res = DlmsLnConnectionImpl.convertPduToGetResult(resultPdu);
            result.add(res);
        }
        return result;
    }

    private static GetResult convertPduToGetResult(GetDataResult pdu) {
        if (pdu.getChoiceIndex() == GetDataResult.Choices.DATA) {
            return new AccessResultImpl(DataConverter.convertDataToDataObject(pdu.data));
        }
        AccessResultCode resultCode = DlmsEnumFunctions.enumValueFrom(pdu.dataAccessResult, AccessResultCode.class);
        return new AccessResultImpl(resultCode);
    }

    @Override
    void processEventPdu(COSEMpdu pdu) {
    }

    @Override
    Set<ConformanceSetting> proposedConformance() {
        return new HashSet<ConformanceSetting>(Arrays.asList(ConformanceSetting.GET, ConformanceSetting.SET, ConformanceSetting.ACTION, ConformanceSetting.SELECTIVE_ACCESS, ConformanceSetting.PRIORITY_MGMT_SUPPORTED, ConformanceSetting.MULTIPLE_REFERENCES, ConformanceSetting.BLOCK_TRANSFER_WITH_ACTION, ConformanceSetting.BLOCK_TRANSFER_WITH_GET_OR_READ, ConformanceSetting.BLOCK_TRANSFER_WITH_SET_OR_WRITE, ConformanceSetting.ATTRIBUTE0_SUPPORTED_WITH_GET, ConformanceSetting.ATTRIBUTE0_SUPPORTED_WITH_SET));
    }

    @Override
    MethodResult authenticateViaHls(byte[] processedChallenge) throws IOException {
        DataObject param = DataObject.newOctetStringData(processedChallenge);
        MethodParameter authenticate = new MethodParameter(15, "0.0.40.0.0.255", 1, param);
        return this.action(true, Arrays.asList(authenticate)).get(0);
    }

    @Override
    void validateReferencingMethod() throws IOException {
        if (this.negotiatedFeatures().contains((Object)ConformanceSetting.SET) || this.negotiatedFeatures().contains((Object)ConformanceSetting.GET)) {
            return;
        }
        this.close();
        JDlmsException.ExceptionId exceptionId = JDlmsException.ExceptionId.WRONG_REFERENCING_METHOD;
        String msg = "Wrong referencing method. Remote smart meter can't use LN referencing.";
        throw new FatalJDlmsException(exceptionId, JDlmsException.Fault.USER, msg);
    }

    @Override
    ContextId getContextId() {
        if (this.connectionSettings().securitySuite().getEncryptionMechanism() != SecuritySuite.EncryptionMechanism.NONE) {
            return ContextId.LOGICAL_NAME_REFERENCING_WITH_CIPHERING;
        }
        return ContextId.LOGICAL_NAME_REFERENCING_NO_CIPHERING;
    }
}

