/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.openmuc.jdlms.AccessResultCode;
import org.openmuc.jdlms.AccessResultImpl;
import org.openmuc.jdlms.AttributeAddress;
import org.openmuc.jdlms.BaseConnection;
import org.openmuc.jdlms.CosemResourceDescriptor;
import org.openmuc.jdlms.DlmsSnConnectionImpl;
import org.openmuc.jdlms.FatalJDlmsException;
import org.openmuc.jdlms.GetResult;
import org.openmuc.jdlms.JDlmsException;
import org.openmuc.jdlms.LnConnectionWrapper;
import org.openmuc.jdlms.MethodParameter;
import org.openmuc.jdlms.MethodResult;
import org.openmuc.jdlms.MethodResultCode;
import org.openmuc.jdlms.NonFatalJDlmsException;
import org.openmuc.jdlms.ObisCode;
import org.openmuc.jdlms.ReadResult;
import org.openmuc.jdlms.SelectiveAccessDescription;
import org.openmuc.jdlms.SetParameter;
import org.openmuc.jdlms.SnAddressSpec;
import org.openmuc.jdlms.SnClassInfo;
import org.openmuc.jdlms.SnClassVersion;
import org.openmuc.jdlms.SnObjectInfo;
import org.openmuc.jdlms.SnWriteParameter;
import org.openmuc.jdlms.datatypes.DataObject;
import org.openmuc.jdlms.sessionlayer.client.SessionLayer;
import org.openmuc.jdlms.settings.client.Settings;

class DlmsLnToSnConnectionWrapper
extends LnConnectionWrapper {
    private static final short ASSOCIATION_OBJECT_LIST = -1528;
    private Map<ObisCode, SnObjectInfo> lnSnMapping;
    private volatile boolean mapIsInitialized;
    private final Map<SnClassVersion, SnClassInfo> snClassInfos;
    private final DlmsSnConnectionImpl snConnection;

    DlmsLnToSnConnectionWrapper(Settings settings, SessionLayer transportLayerCon, Map<ObisCode, SnObjectInfo> lnSnMapping, Map<SnClassVersion, SnClassInfo> snClassInfos) {
        this.snConnection = new DlmsSnConnectionImpl(settings, transportLayerCon);
        this.snClassInfos = snClassInfos;
        this.mapIsInitialized = false;
        this.lnSnMapping = lnSnMapping != null && !lnSnMapping.isEmpty() ? lnSnMapping : new HashMap<ObisCode, SnObjectInfo>();
    }

    @Override
    protected void connect() throws IOException {
        this.snConnection.connect();
    }

    @Override
    public synchronized List<GetResult> get(boolean highPriority, List<AttributeAddress> params) throws IOException {
        if (DlmsLnToSnConnectionWrapper.nullableListIsEmpty(params)) {
            return Collections.emptyList();
        }
        Object[] res = new GetResult[params.size()];
        ArrayList<SnAddressSpec> addressSpecs = new ArrayList<SnAddressSpec>(params.size());
        ListIterator<AttributeAddress> addrIter = params.listIterator();
        while (addrIter.hasNext()) {
            int nextIndex = addrIter.nextIndex();
            AttributeAddress next = addrIter.next();
            try {
                addressSpecs.add(this.buildAddressSpec(next));
            }
            catch (AccessNotAllowedException e) {
                res[nextIndex] = new AccessResultImpl(AccessResultCode.OBJECT_UNDEFINED);
            }
        }
        ListIterator<ReadResult> iter = this.snConnection.read(addressSpecs).listIterator();
        int index = 0;
        while (iter.hasNext()) {
            GetResult r = (GetResult)((Object)iter.next());
            index = DlmsLnToSnConnectionWrapper.nextFreeResultIndex(res, index);
            res[index] = r;
        }
        return Arrays.asList(res);
    }

    @Override
    public synchronized List<AccessResultCode> set(boolean highPriority, List<SetParameter> params) throws IOException {
        if (DlmsLnToSnConnectionWrapper.nullableListIsEmpty(params)) {
            return Collections.emptyList();
        }
        Object[] finalResList = new AccessResultCode[params.size()];
        ArrayList<SnWriteParameter> addressSpecs = new ArrayList<SnWriteParameter>(params.size());
        ListIterator<SetParameter> addrIter = params.listIterator();
        while (addrIter.hasNext()) {
            int nextIndex = addrIter.nextIndex();
            SetParameter setParam = addrIter.next();
            try {
                SnAddressSpec addressSpec = this.buildAddressSpec(setParam.getAttributeAddress());
                addressSpecs.add(SnWriteParameter.newAttributeWriteParameter(addressSpec, setParam.getData()));
            }
            catch (AccessNotAllowedException e) {
                finalResList[nextIndex] = AccessResultCode.OBJECT_UNDEFINED;
            }
        }
        ListIterator<AccessResultCode> iter = this.snConnection.write(addressSpecs).listIterator();
        int index = 0;
        while (iter.hasNext()) {
            AccessResultCode resultCode = iter.next();
            index = DlmsLnToSnConnectionWrapper.nextFreeResultIndex(finalResList, index);
            finalResList[index++] = resultCode;
        }
        return Arrays.asList(finalResList);
    }

    @Override
    public synchronized List<MethodResult> action(boolean priority, List<MethodParameter> params) throws IOException {
        if (DlmsLnToSnConnectionWrapper.nullableListIsEmpty(params)) {
            return Collections.emptyList();
        }
        MethodResult[] finalResult = new MethodResult[params.size()];
        ListIterator<MethodParameter> paramsIter = params.listIterator();
        ArrayList<SnAddressSpec> readParameter = new ArrayList<SnAddressSpec>(params.size());
        while (paramsIter.hasNext()) {
            SnObjectInfo snObjectInfo;
            int index = paramsIter.nextIndex();
            MethodParameter param = paramsIter.next();
            try {
                snObjectInfo = this.accessSnObjectInfo(param);
            }
            catch (AccessNotAllowedException e) {
                finalResult[index] = new MethodResult(MethodResultCode.OBJECT_UNDEFINED);
                continue;
            }
            SnClassInfo classInfo = this.snClassInfos.get(snObjectInfo.getSnClassVersion());
            if (classInfo == null) {
                finalResult[index] = new MethodResult(MethodResultCode.OBJECT_UNDEFINED);
                continue;
            }
            int snOffset = classInfo.computeMethodSnOffsetFor(param.getId());
            if (snOffset == -1) {
                finalResult[index] = new MethodResult(MethodResultCode.OBJECT_UNDEFINED);
                continue;
            }
            int variableName = snObjectInfo.getBaseName() + snOffset;
            SnAddressSpec snAddress = SnAddressSpec.newMethodAddress(variableName, param.getParameter());
            readParameter.add(snAddress);
        }
        List<ReadResult> readResults = this.snConnection.read(readParameter);
        return DlmsLnToSnConnectionWrapper.convertAndMergeActionResults(finalResult, readResults);
    }

    private static List<MethodResult> convertAndMergeActionResults(MethodResult[] finalResult, List<ReadResult> readResults) {
        int index = 0;
        for (ReadResult readResult : readResults) {
            index = DlmsLnToSnConnectionWrapper.nextFreeResultIndex(finalResult, index);
            MethodResultCode resultCode = readResult.getResultCode() == AccessResultCode.SUCCESS ? MethodResultCode.SUCCESS : MethodResultCode.OTHER_REASON;
            finalResult[index++] = new MethodResult(resultCode, readResult.getResultData());
        }
        return Arrays.asList(finalResult);
    }

    private static int nextFreeResultIndex(Object[] result, int resId) {
        int startIndex;
        for (startIndex = resId; startIndex < result.length && result[startIndex] != null; ++startIndex) {
        }
        return startIndex;
    }

    private SnAddressSpec buildAddressSpec(AttributeAddress attributeAddress) throws IOException, AccessNotAllowedException {
        SnObjectInfo objectInfo = this.accessSnObjectInfo(attributeAddress);
        SnClassInfo classInfo = this.snClassInfos.get(objectInfo.getSnClassVersion());
        int snOffset = classInfo == null ? (attributeAddress.getId() - 1) * 8 : classInfo.computeAttributeSnOffsetFor(attributeAddress.getId());
        int variableName = snOffset + objectInfo.getBaseName();
        return SnAddressSpec.newAttributeAddress(variableName, attributeAddress.getAccessSelection());
    }

    private SnObjectInfo accessSnObjectInfo(CosemResourceDescriptor cosemResourceDescriptor) throws IOException, AccessNotAllowedException {
        ObisCode instanceId = cosemResourceDescriptor.getInstanceId();
        SnObjectInfo snObjectInfo = this.lnSnMapping.get(instanceId);
        if (snObjectInfo == null && !this.mapIsInitialized) {
            try {
                snObjectInfo = this.retrieveVariableInfoFor(cosemResourceDescriptor);
                this.lnSnMapping.put(instanceId, snObjectInfo);
            }
            catch (IOException e) {
                this.initializeLnMap();
                snObjectInfo = this.lnSnMapping.get(instanceId);
            }
        }
        if (snObjectInfo != null) {
            return snObjectInfo;
        }
        String msg = "Object " + instanceId + " unknown to the smart meter. Try an other address.";
        throw new AccessNotAllowedException(msg);
    }

    private static boolean nullableListIsEmpty(List<?> params) {
        return params == null || params.isEmpty();
    }

    private SnObjectInfo retrieveVariableInfoFor(CosemResourceDescriptor resourceDescriptor) throws IOException {
        int selector = 2;
        DataObject filter = DataObject.newStructureData(DataObject.newUInteger16Data(resourceDescriptor.getClassId()), DataObject.newOctetStringData(resourceDescriptor.getInstanceId().bytes()));
        SnAddressSpec params = SnAddressSpec.newAttributeAddress(-1528, new SelectiveAccessDescription(selector, filter));
        ReadResult res = this.snConnection.read(params);
        if (res.getResultCode() != AccessResultCode.SUCCESS) {
            throw new NonFatalJDlmsException(JDlmsException.ExceptionId.UNKNOWN, JDlmsException.Fault.SYSTEM, "Could not load variable info.");
        }
        List objectListElement = (List)res.getResultData().getValue();
        Number baseName = (Number)((DataObject)objectListElement.get(0)).getValue();
        Number classId = (Number)((DataObject)objectListElement.get(1)).getValue();
        Number version = (Number)((DataObject)objectListElement.get(2)).getValue();
        SnClassVersion classVersion = new SnClassVersion(classId.intValue(), version.intValue());
        return new SnObjectInfo(baseName.intValue(), resourceDescriptor.getInstanceId(), classVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<ObisCode, SnObjectInfo> getLnSnInfoMapping() throws IOException {
        Map<ObisCode, SnObjectInfo> map = this.lnSnMapping;
        synchronized (map) {
            this.initializeLnMap();
            return new HashMap<ObisCode, SnObjectInfo>(this.lnSnMapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLnMap() throws IOException {
        Map<ObisCode, SnObjectInfo> map = this.lnSnMapping;
        synchronized (map) {
            if (this.mapIsInitialized) {
                return;
            }
            ReadResult readResult = this.snConnection.read(SnAddressSpec.newAttributeAddress(-1528));
            if (readResult.getResultCode() != AccessResultCode.SUCCESS) {
                throw new FatalJDlmsException(JDlmsException.ExceptionId.CONNECTION_ESTABLISH_ERROR, JDlmsException.Fault.SYSTEM, "Could not access the mapping list.");
            }
            List resultData = (List)readResult.getResultData().getValue();
            for (DataObject object : resultData) {
                List objectStructur = (List)object.getValue();
                Number baseName = (Number)((DataObject)objectStructur.get(0)).getValue();
                Number classId = (Number)((DataObject)objectStructur.get(1)).getValue();
                Number version = (Number)((DataObject)objectStructur.get(2)).getValue();
                byte[] instancIdBytes = (byte[])((DataObject)objectStructur.get(3)).getValue();
                ObisCode instanceId = new ObisCode(instancIdBytes);
                SnObjectInfo oldV = this.lnSnMapping.get(instanceId);
                if (oldV != null && oldV.getBaseName() == baseName.intValue()) continue;
                SnClassVersion snClassVersion = new SnClassVersion(classId.intValue(), version.intValue());
                SnObjectInfo value = new SnObjectInfo(baseName.intValue(), instanceId, snClassVersion);
                this.lnSnMapping.put(instanceId, value);
            }
            this.mapIsInitialized = true;
        }
    }

    @Override
    protected BaseConnection getWrappedConnection() {
        return this.snConnection;
    }

    private class AccessNotAllowedException
    extends Exception {
        public AccessNotAllowedException(String message) {
            super(message);
        }
    }
}

