/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmuc.jdlms.ConformanceSetting;
import org.openmuc.jdlms.CosemInterfaceObject;
import org.openmuc.jdlms.SecuritySuite;

public class LogicalDevice {
    private static final int LD_NAME_MAX_LENGTH = 16;
    private final int logicalDeviceId;
    private final List<CosemInterfaceObject> cosemObjects;
    private final String logicalDeviceName;
    private final Map<Integer, SecuritySuite> restrictions;
    private Set<ConformanceSetting> conformance;
    private final String manufacturerId;
    private final long deviceId;
    private byte[] systemTitle;
    private byte[] masterKey;

    public LogicalDevice(int logicalDeviceId, String logicalDeviceName, String manufacturerId, long deviceId) {
        this.manufacturerId = manufacturerId;
        this.deviceId = deviceId;
        if (logicalDeviceName.length() > 16) {
            String message = MessageFormat.format("Logical device name length is greater than {0}.", 16);
            throw new IllegalArgumentException(message);
        }
        if (logicalDeviceId < 1) {
            String message = "Logical Device ID must be greater than one.";
            throw new IllegalArgumentException(message);
        }
        this.logicalDeviceId = logicalDeviceId;
        this.logicalDeviceName = logicalDeviceName;
        this.cosemObjects = new LinkedList<CosemInterfaceObject>();
        this.restrictions = new HashMap<Integer, SecuritySuite>();
        this.setSystemTitle(manufacturerId, deviceId);
        this.setConformance(ConformanceSetting.GET, ConformanceSetting.SET, ConformanceSetting.ACTION, ConformanceSetting.BLOCK_TRANSFER_WITH_GET_OR_READ, ConformanceSetting.BLOCK_TRANSFER_WITH_SET_OR_WRITE, ConformanceSetting.BLOCK_TRANSFER_WITH_ACTION, ConformanceSetting.MULTIPLE_REFERENCES, ConformanceSetting.READ, ConformanceSetting.WRITE, ConformanceSetting.SELECTIVE_ACCESS, ConformanceSetting.PARAMETERIZED_ACCESS);
    }

    private void setSystemTitle(String manufacturerId, long deviceId) {
        int i;
        int manIdLength = 3;
        if (manufacturerId.length() != 3) {
            throw new IllegalArgumentException("Manufacterer ID must be three charactes long.");
        }
        this.systemTitle = new byte[8];
        byte[] manufacturerIdBytes = manufacturerId.getBytes(StandardCharsets.US_ASCII);
        for (i = 0; i < 3; ++i) {
            this.systemTitle[i] = manufacturerIdBytes[i];
        }
        for (i = 0; i < 5; ++i) {
            int shift = (4 - i) * 8;
            long v = deviceId >> shift;
            this.systemTitle[i + 3] = (byte)(0xFFL & v);
        }
    }

    public String getLogicalDeviceName() {
        return this.logicalDeviceName;
    }

    public String getManufacturerId() {
        return this.manufacturerId;
    }

    public int getLogicalDeviceId() {
        return this.logicalDeviceId;
    }

    public byte[] getMasterKey() {
        return this.masterKey;
    }

    public LogicalDevice setMasterKey(byte[] masterKey) {
        int numOfBits = masterKey.length << 3;
        if (numOfBits != 128) {
            throw new IllegalArgumentException("Key length not 128 bits.");
        }
        this.masterKey = masterKey;
        return this;
    }

    public boolean addRestriction(int clientId, SecuritySuite securitySuite) {
        if (clientId < 1) {
            throw new IllegalArgumentException("Client ID must be grater than zero.");
        }
        if (securitySuite == null) {
            throw new IllegalArgumentException("Authentication object must not be null.");
        }
        return this.restrictions.put(clientId, securitySuite) != null;
    }

    public LogicalDevice registerCosemObject(CosemInterfaceObject ... cosemObject) {
        return this.registerCosemObject(Arrays.asList(cosemObject));
    }

    public LogicalDevice registerCosemObject(List<CosemInterfaceObject> cosemObject) {
        this.cosemObjects.addAll(cosemObject);
        return this;
    }

    public Map<Integer, SecuritySuite> getRestrictions() {
        return this.restrictions;
    }

    List<CosemInterfaceObject> getCosemObjects() {
        return this.cosemObjects;
    }

    public Set<ConformanceSetting> getConformance() {
        return this.conformance;
    }

    public byte[] getSystemTitle() {
        return this.systemTitle;
    }

    public LogicalDevice setConformance(ConformanceSetting ... conformanceSetting) {
        ConformanceSetting[] cs = conformanceSetting;
        if (conformanceSetting.length == 0) {
            cs = ConformanceSetting.values();
        }
        this.conformance = new HashSet<ConformanceSetting>(Arrays.asList(cs));
        return this;
    }
}

