/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.openmuc.jdlms.internal.asn1.cosem.COSEMpdu;

class ResponseQueue {
    private final BlockingQueue<COSEMpdu> queue = new ArrayBlockingQueue<COSEMpdu>(1);
    private volatile boolean polled;
    private IOException lastError;

    ResponseQueue() {
    }

    public void put(COSEMpdu data) {
        try {
            this.queue.put(data);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void putError(IOException ex) {
        this.lastError = ex;
        this.put(new COSEMpdu());
    }

    public synchronized COSEMpdu poll(long timeout, TimeUnit unit) throws IOException {
        this.polled = true;
        try {
            COSEMpdu cosemPdu = null;
            cosemPdu = timeout == 0L ? this.queue.take() : this.queue.poll(timeout, unit);
            if (this.lastError != null) {
                IOException le = this.lastError;
                this.lastError = null;
                throw le;
            }
            COSEMpdu cOSEMpdu = cosemPdu;
            return cOSEMpdu;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for incoming response");
        }
        finally {
            this.polled = false;
        }
    }

    public boolean beingPolled() {
        return this.polled;
    }

    public void clear() {
        this.queue.clear();
        this.lastError = null;
    }
}

