/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.RFC3394WrapEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.openmuc.jdlms.MethodParameter;
import org.openmuc.jdlms.ObisCode;
import org.openmuc.jdlms.SecuritySuite;
import org.openmuc.jdlms.datatypes.DataObject;
import org.openmuc.jdlms.datatypes.DlmsEnumeration;

public class SecurityUtils {
    public static MethodParameter keyChangeMethodParamFor(byte[] masterKey, byte[] newKey, KeyId keyId) {
        boolean instance = false;
        ObisCode obisCode = new ObisCode(0, 0, 43, 0, 0, 255);
        byte[] wrappedKey = SecurityUtils.wrapAesRFC3394Key(masterKey, newKey);
        List<DataObject> keyDataList = Arrays.asList(DataObject.newEnumerateData(keyId.id), DataObject.newOctetStringData(wrappedKey));
        DataObject keyData = DataObject.newStructureData(keyDataList);
        DataObject methodParameter = DataObject.newArrayData(Arrays.asList(keyData));
        return new MethodParameter(64, obisCode, 2, methodParameter);
    }

    public static MethodParameter securityActivateMethodParamFor(SecuritySuite.SecurityPolicy securityPolicy) {
        boolean instance = false;
        ObisCode instanceId = new ObisCode(0, 0, 43, 0, 0, 255);
        return new MethodParameter(64, instanceId, 1, DataObject.newEnumerateData(securityPolicy.getId()));
    }

    public static byte[] cipherWithAes128(byte[] masterKey, byte[] iv, byte[] bytesToCipher) throws GeneralSecurityException {
        SecretKeySpec secretkeySpec = new SecretKeySpec(masterKey, "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
        cipher.init(1, (Key)secretkeySpec, ivSpec);
        return cipher.doFinal(bytesToCipher);
    }

    public static byte[] wrapAesRFC3394Key(byte[] kek, byte[] key) {
        RFC3394WrapEngine rfc3394WrapEngine = new RFC3394WrapEngine((BlockCipher)new AESEngine());
        rfc3394WrapEngine.init(true, (CipherParameters)new KeyParameter(kek));
        return rfc3394WrapEngine.wrap(key, 0, key.length);
    }

    public static byte[] unwrapAesRFC3394Key(byte[] kek, byte[] wrappedKey) throws InvalidCipherTextException {
        RFC3394WrapEngine rfc3394WrapEngine = new RFC3394WrapEngine((BlockCipher)new AESEngine());
        rfc3394WrapEngine.init(false, (CipherParameters)new KeyParameter(kek));
        return rfc3394WrapEngine.unwrap(wrappedKey, 0, wrappedKey.length);
    }

    public static byte[] generateAES128Key() {
        byte[] key = new byte[16];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(key);
        return key;
    }

    private SecurityUtils() {
    }

    public static enum KeyId implements DlmsEnumeration
    {
        GLOBAL_UNICAST_ENCRYPTION_KEY(0),
        GLOBAL_BROADCAST_ENCRYPTION_KEY(1),
        AUTHENTICATION_KEY(2);

        private final int id;

        private KeyId(int id) {
            this.id = id;
        }

        public int keyId() {
            return this.id;
        }

        @Override
        public long getCode() {
            return this.keyId();
        }
    }
}

