/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openmuc.jdlms.AttributeAccessMode;
import org.openmuc.jdlms.CosemAttribute;
import org.openmuc.jdlms.CosemClass;
import org.openmuc.jdlms.CosemInterfaceObject;
import org.openmuc.jdlms.CosemMethod;
import org.openmuc.jdlms.CosemSnInterfaceObject;
import org.openmuc.jdlms.DataDirectory;
import org.openmuc.jdlms.DlmsServer;
import org.openmuc.jdlms.IllegalAttributeAccessException;
import org.openmuc.jdlms.IllegalMethodAccessException;
import org.openmuc.jdlms.IllegalPametrizationError;
import org.openmuc.jdlms.LogicalDevice;
import org.openmuc.jdlms.ObisCode;
import org.openmuc.jdlms.SecuritySuite;
import org.openmuc.jdlms.SelectiveAccessDescription;
import org.openmuc.jdlms.ServerConnectionListener;
import org.openmuc.jdlms.datatypes.DataObject;
import org.openmuc.jdlms.internal.Accessor;
import org.openmuc.jdlms.internal.AttributeAccessor;
import org.openmuc.jdlms.internal.BaseNameRange;
import org.openmuc.jdlms.internal.BaseNameRangeSet;
import org.openmuc.jdlms.internal.DataDirectoryImpl;
import org.openmuc.jdlms.internal.MethodAccessor;
import org.openmuc.jdlms.internal.systemclasses.AssociationLnClass;
import org.openmuc.jdlms.internal.systemclasses.AssociationSnClass;
import org.openmuc.jdlms.internal.systemclasses.CosemDataDirectory;
import org.openmuc.jdlms.internal.systemclasses.ReadOnlyOctetStrData;
import org.openmuc.jdlms.internal.systemclasses.SapAssignment;
import org.openmuc.jdlms.internal.systemclasses.SecuritySetup;
import org.openmuc.jdlms.settings.client.ReferencingMethod;
import org.openmuc.jdlms.settings.server.ServerSettings;
import org.openmuc.jdlms.transportlayer.server.ServerTransportLayer;

public abstract class ServerBuilder<T extends ServerBuilder<T>> {
    private static final CosemAttribute LOGICAL_NAME_ATTRIBUTE = new CosemAttribute(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return CosemAttribute.class;
        }

        @Override
        public DataObject.Type type() {
            return DataObject.Type.OCTET_STRING;
        }

        @Override
        public byte id() {
            return 1;
        }

        @Override
        public AttributeAccessMode accessMode() {
            return AttributeAccessMode.READ_ONLY;
        }

        @Override
        public int[] selector() {
            return new int[0];
        }

        @Override
        public int snOffset() {
            return 0;
        }
    };
    private static final int MANAGEMENT_LOGICAL_DEVICE_ID = 1;
    private final List<LogicalDevice> logicalDevices = new LinkedList<LogicalDevice>();
    private LogicalDevice managementLd;
    private int inactivityTimeout = 0;
    private int responseTimeout = 0;
    private int maxClients = 0;
    private ServerConnectionListener connectionListener = null;
    private ReferencingMethod referencingMethod = ReferencingMethod.LOGICAL;

    public abstract DlmsServer build() throws IOException;

    public final T registerLogicalDevice(LogicalDevice ... logicalDevice) {
        return this.registerLogicalDevice(Arrays.asList(logicalDevice));
    }

    public T registerLogicalDevice(List<LogicalDevice> newlogicalDevices) {
        for (LogicalDevice logicalDevice : newlogicalDevices) {
            if (logicalDevice.getLogicalDeviceId() == 1) {
                this.managementLd = logicalDevice;
            }
            if (logicalDevice.getMasterKey() == null) {
                ServerBuilder.checkIfKeyIsRequired(logicalDevice);
            }
            this.logicalDevices.add(logicalDevice);
        }
        return this.self();
    }

    public T setMaxClients(int maxClients) {
        if (maxClients < 0) {
            throw new IllegalArgumentException("max clients can't be negative");
        }
        this.maxClients = maxClients;
        return this.self();
    }

    public T setInactivityTimeout(int inactivityTimeout) {
        if (inactivityTimeout < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.inactivityTimeout = inactivityTimeout;
        return this.self();
    }

    public T setReferencingMethod(ReferencingMethod referencingMethod) {
        this.referencingMethod = referencingMethod;
        return this.self();
    }

    public T setResponseTimeout(int responseTimeout) {
        if (responseTimeout < 0) {
            throw new IllegalArgumentException("Timeout must be >= 0");
        }
        this.responseTimeout = responseTimeout;
        return this.self();
    }

    public T setConnectionListener(ServerConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
        return this.self();
    }

    protected void setPropertiesTo(ServerSettingsImpl settings) {
        settings.inactivityTimeout = this.inactivityTimeout;
        settings.responseTimeout = this.responseTimeout;
        settings.maxClients = this.maxClients;
        settings.connectionListener = this.connectionListener;
        settings.referencingMethod = this.referencingMethod;
    }

    protected final DataDirectory parseLogicalDevices() {
        DataDirectoryImpl attributeDirectory = new DataDirectoryImpl();
        this.registerSystemClassesToManagementLd();
        for (LogicalDevice logicalDevice : this.logicalDevices) {
            this.registerSystemClassesTo(logicalDevice);
            List<CosemInterfaceObject> cosemClasses = logicalDevice.getCosemObjects();
            DataDirectoryImpl.CosemLogicalDevice logicalDeviceD = this.parseLogicalDlmsClasses(logicalDevice, cosemClasses, attributeDirectory);
            int ldId = logicalDevice.getLogicalDeviceId();
            DataDirectoryImpl.CosemLogicalDevice res = attributeDirectory.addLogicalDevice(ldId, logicalDeviceD);
            if (res == null) continue;
            String message = MessageFormat.format("Logical Device with Logical Device ID = {0} was already registered.", ldId);
            throw new IllegalPametrizationError(message);
        }
        return attributeDirectory;
    }

    protected DlmsServer newServer(ServerTransportLayer serverTransportLayer) throws IOException {
        DlmsServer dlmsServer = new DlmsServer(serverTransportLayer);
        dlmsServer.start();
        return dlmsServer;
    }

    private T self() {
        return (T)this;
    }

    private DataDirectoryImpl.CosemLogicalDevice parseLogicalDlmsClasses(LogicalDevice logicalDevice, List<CosemInterfaceObject> cosemObjects, DataDirectoryImpl dataDirectory) {
        BaseNameRangeSet baseNameRanges = new BaseNameRangeSet();
        DataDirectoryImpl.CosemLogicalDevice logicalDeviceD = new DataDirectoryImpl.CosemLogicalDevice(logicalDevice, baseNameRanges);
        for (CosemInterfaceObject instance : cosemObjects) {
            DataDirectoryImpl.CosemClassInstance classInstance;
            Class<?> klass = instance.getClass();
            CosemClass cosemClass = klass.getAnnotation(CosemClass.class);
            ServerBuilder.checkClassAnnotation(klass, cosemClass);
            if (this.referencingMethod == ReferencingMethod.SHORT) {
                if (!CosemSnInterfaceObject.class.isAssignableFrom(klass)) continue;
                classInstance = new DataDirectoryImpl.CosemSnClassInstance(cosemClass, instance);
                this.processCosemClass(logicalDevice, dataDirectory, logicalDeviceD, classInstance);
                ServerBuilder.setupSnObject(baseNameRanges, (DataDirectoryImpl.CosemSnClassInstance)classInstance);
                continue;
            }
            classInstance = new DataDirectoryImpl.CosemClassInstance(cosemClass, instance);
            this.processCosemClass(logicalDevice, dataDirectory, logicalDeviceD, classInstance);
        }
        return logicalDeviceD;
    }

    private void processCosemClass(LogicalDevice logicalDevice, DataDirectoryImpl dataDirectory, DataDirectoryImpl.CosemLogicalDevice logicalDeviceD, DataDirectoryImpl.CosemClassInstance classInstance) {
        ServerBuilder.addClassInstanceToLd(logicalDevice.getLogicalDeviceId(), logicalDeviceD, classInstance);
        this.findCosemFields(dataDirectory, classInstance);
        ServerBuilder.findCosemMethods(classInstance);
    }

    private static void setupSnObject(BaseNameRangeSet baseNameRanges, DataDirectoryImpl.CosemSnClassInstance classInstance) throws IllegalPametrizationError {
        CosemInterfaceObject instance = classInstance.getInstance();
        int baseName = ((CosemSnInterfaceObject)instance).getObjectName();
        if (baseName % 8 != 0) {
            String strPattern = "Basename of object with instance ID: {0} must be a multiple of 0x08.";
            String message = MessageFormat.format(strPattern, instance.getInstanceId());
            throw new IllegalPametrizationError(message);
        }
        Collection<AttributeAccessor> attributeAccessors = classInstance.getAttributes();
        Collection<MethodAccessor> methodAccessors = classInstance.getMethods();
        ServerBuilder.checkSnAttributeAndMethodOffset(attributeAccessors, methodAccessors, instance);
        int lastSnIndex = classInstance.getMaxSnOffset() + baseName;
        BaseNameRange interval = new BaseNameRange(baseName, lastSnIndex, classInstance);
        if (baseNameRanges.add(interval) != null) {
            throw new IllegalPametrizationError("SN error: short names of classes intersect.");
        }
    }

    private static void checkSnAttributeAndMethodOffset(Collection<AttributeAccessor> attributeAccessors, Collection<MethodAccessor> methodAccessors, CosemInterfaceObject instance) throws IllegalPametrizationError {
        int snOffset;
        HashSet<Integer> snOffsets = new HashSet<Integer>();
        for (AttributeAccessor attributeAccessor : attributeAccessors) {
            snOffset = attributeAccessor.getCosemAttribute().snOffset();
            ServerBuilder.checkSnOffset(snOffsets, snOffset, instance);
        }
        for (MethodAccessor methodAccessor : methodAccessors) {
            snOffset = methodAccessor.getCosemMethod().snOffset();
            ServerBuilder.checkSnOffset(snOffsets, snOffset, instance);
        }
    }

    private static void checkSnOffset(Set<Integer> snOffsets, int snOffset, CosemInterfaceObject instance) throws IllegalPametrizationError {
        if (snOffset % 8 != 0) {
            String msg = MessageFormat.format("SN offset in class {0} must be a multiple of 0x08.", instance.getClass().getName());
            throw new IllegalPametrizationError(msg);
        }
        if (!snOffsets.add(snOffset)) {
            String msg = MessageFormat.format("SN offset {0} occurs multiple times in class {1}.", snOffset, instance.getClass().getName());
            throw new IllegalPametrizationError(msg);
        }
    }

    private void registerSystemClassesToManagementLd() {
        if (this.managementLd == null) {
            this.managementLd = new LogicalDevice(1, "ISE-42", "ISE", 424242L);
            this.logicalDevices.add(this.managementLd);
        }
    }

    private void registerSystemClassesTo(LogicalDevice logicalDevice) {
        int ldId = logicalDevice.getLogicalDeviceId();
        DataObject logicalDeviceName = DataObject.newOctetStringData(logicalDevice.getLogicalDeviceName().getBytes(StandardCharsets.US_ASCII));
        int baseName = 64768;
        ReadOnlyOctetStrData logicalDeviceNameData = new ReadOnlyOctetStrData(logicalDeviceName, "0.0.42.0.0.255", 64768);
        CosemInterfaceObject associationObject = this.referencingMethod == ReferencingMethod.LOGICAL ? new AssociationLnClass(ldId) : new AssociationSnClass(ldId);
        logicalDevice.registerCosemObject(associationObject, new SapAssignment(), logicalDeviceNameData, new SecuritySetup(logicalDevice));
    }

    private static String fieldLocationAsString(Class<? extends Object> klass, Field field) {
        return MessageFormat.format("Field {0} in class {1}", field.getName(), klass.getName());
    }

    private void findCosemFields(DataDirectoryImpl dataDirectory, DataDirectoryImpl.CosemClassInstance classInstance) {
        CosemInterfaceObject instance = classInstance.getInstance();
        Class<?> klass = instance.getClass();
        for (Field field : klass.getDeclaredFields()) {
            CosemDataDirectory dlmsDataDirectory = field.getAnnotation(CosemDataDirectory.class);
            if (dlmsDataDirectory != null) {
                ServerBuilder.setDataDirectroyToFiled(instance, field, dataDirectory);
                continue;
            }
            CosemAttribute cosemAttribute = field.getAnnotation(CosemAttribute.class);
            if (cosemAttribute == null) continue;
            this.checkIfAttributeId1Set(klass, field, cosemAttribute);
            ServerBuilder.checkFieldReturnType(klass, field);
            AttributeAccessor accessor = ServerBuilder.buildAttributeAccessor(klass, field, cosemAttribute);
            ServerBuilder.addAccessorToClass(klass, classInstance, cosemAttribute, accessor);
        }
        AttributeAccessor.LogicalNameFakeAccessor accessor = new AttributeAccessor.LogicalNameFakeAccessor(instance.getInstanceId(), LOGICAL_NAME_ATTRIBUTE);
        ServerBuilder.addAccessorToClass(klass, classInstance, LOGICAL_NAME_ATTRIBUTE, accessor);
    }

    private void checkIfAttributeId1Set(Class<? extends Object> klass, Field field, CosemAttribute cosemAttribute) throws IllegalPametrizationError {
        if (cosemAttribute.id() == 1) {
            String message = MessageFormat.format("{0} is not allowed to use attribute ID 1. Reserved for system.", ServerBuilder.fieldLocationAsString(klass, field));
            throw new IllegalPametrizationError(message);
        }
    }

    private static void findCosemMethods(DataDirectoryImpl.CosemClassInstance classInstance) {
        Class<?> klass = classInstance.getInstance().getClass();
        for (Method method : klass.getDeclaredMethods()) {
            CosemMethod cosemMethod = method.getAnnotation(CosemMethod.class);
            if (cosemMethod == null) continue;
            boolean returnTypeIsVoid = method.getReturnType().equals(Void.TYPE);
            if (!method.getReturnType().equals(DataObject.class) && !returnTypeIsVoid) {
                String message = MessageFormat.format("{0} must return a {1} or void.", ServerBuilder.methodLocationToString(klass, method), DataObject.class.getSimpleName());
                throw new IllegalPametrizationError(message);
            }
            DataObject.Type returnType = returnTypeIsVoid ? null : DataObject.Type.DONT_CARE;
            ServerBuilder.verifyIfMethodIsPublic(method);
            ServerBuilder.checkThrowsDeclarations(klass, method);
            DataObject.Type parameterType = ServerBuilder.findAndVerifyParameters(cosemMethod, klass, method);
            MethodAccessor methodAccessor = new MethodAccessor(method, cosemMethod, parameterType, returnType);
            if (classInstance.putMethod(cosemMethod.id(), methodAccessor) == null) continue;
            String message = MessageFormat.format("Method ID = {0} is ambiguous in class {1}.", cosemMethod.id(), klass.getName());
            throw new IllegalPametrizationError(message);
        }
    }

    private static DataObject.Type findAndVerifyParameters(CosemMethod dlmsMethod, Class<?> klass, Method method) {
        DataObject.Type parameterType;
        Class<?>[] parameterTypes = method.getParameterTypes();
        int parameterLength = parameterTypes.length;
        if (parameterLength == 0) {
            parameterType = null;
        } else if (parameterLength == 1) {
            parameterType = ServerBuilder.extractGetParameterType1(dlmsMethod, klass, method, parameterTypes);
        } else if (parameterLength == 2) {
            parameterType = ServerBuilder.extractGetParameterType2(dlmsMethod, klass, method, parameterTypes);
        } else {
            throw new IllegalPametrizationError(ServerBuilder.buildWrongParamExceptionMsg(klass, method));
        }
        return parameterType;
    }

    private static DataObject.Type extractGetParameterType2(CosemMethod dlmsMethod, Class<?> klass, Method method, Class<?>[] parameterTypes) throws IllegalPametrizationError {
        Class<?> param1Class = parameterTypes[0];
        Class<?> param2Class = parameterTypes[1];
        if (!DataObject.class.isAssignableFrom(param1Class) || !Long.class.isAssignableFrom(param2Class)) {
            throw new IllegalPametrizationError(ServerBuilder.buildWrongParamExceptionMsg(klass, method));
        }
        DataObject.Type parameterType = dlmsMethod.consumes();
        return parameterType;
    }

    private static DataObject.Type extractGetParameterType1(CosemMethod dlmsMethod, Class<?> klass, Method method, Class<?>[] parameterTypes) throws IllegalPametrizationError {
        DataObject.Type parameterType;
        Class<?> param1Class = parameterTypes[0];
        if (DataObject.class.isAssignableFrom(param1Class)) {
            parameterType = dlmsMethod.consumes();
        } else if (Long.class.isAssignableFrom(param1Class)) {
            parameterType = null;
        } else {
            throw new IllegalPametrizationError(ServerBuilder.buildWrongParamExceptionMsg(klass, method));
        }
        return parameterType;
    }

    private static String buildWrongParamExceptionMsg(Class<? extends Object> klass, Method method) {
        return MessageFormat.format("{0} is only allowed to take one parameter of class {1} and a parameter of class {2}", ServerBuilder.methodLocationToString(klass, method), DataObject.class.getSimpleName(), Long.class.getSimpleName());
    }

    private static void checkThrowsDeclarations(Class<? extends Object> klass, Method method) {
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        if (exceptionTypes.length > 1 || exceptionTypes.length == 1 && !IllegalMethodAccessException.class.isAssignableFrom(exceptionTypes[0])) {
            String message = MessageFormat.format("{0} can only throw a {1}.", ServerBuilder.methodLocationToString(klass, method), IllegalMethodAccessException.class.getSimpleName());
            throw new IllegalPametrizationError(message);
        }
    }

    private static void setDataDirectroyToFiled(Object object, Field field, DataDirectoryImpl attributeDirectory) {
        if (!DataDirectoryImpl.class.isAssignableFrom(field.getType())) {
            throw new Error("Bug in assignDataDirectroyToFiled System error notify developers");
        }
        try {
            field.setAccessible(true);
            field.set(object, attributeDirectory);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new Error("error can't set field.. System error notify developers", e);
        }
    }

    private static void addAccessorToClass(Class<? extends Object> klass, DataDirectoryImpl.CosemClassInstance classInstance, CosemAttribute dlmsAttribute, AttributeAccessor entry) {
        Accessor res = classInstance.putAttribute(dlmsAttribute.id(), entry);
        if (res != null) {
            String message = MessageFormat.format("Attribute ID = {0} is ambiguous in class {1}.", dlmsAttribute.id(), klass.getName());
            throw new IllegalPametrizationError(message);
        }
    }

    private static void addClassInstanceToLd(int logicalDeviceId, DataDirectoryImpl.CosemLogicalDevice logicalDevice, DataDirectoryImpl.CosemClassInstance classInstance) {
        CosemInterfaceObject instance = classInstance.getInstance();
        ObisCode instanceId = instance.getInstanceId();
        DataDirectoryImpl.CosemClassInstance res = logicalDevice.put(instanceId, classInstance);
        if (res != null) {
            String message = MessageFormat.format("Class {0} and {1} in logical device with ID = {2} have identical instance ID {3}.", instance.getClass().getName(), res.getInstance().getClass().getName(), logicalDeviceId, instanceId);
            throw new IllegalPametrizationError(message);
        }
    }

    private static AttributeAccessor buildAttributeAccessor(Class<?> klass, Field field, CosemAttribute cosemAttribute) {
        Method[] methods = klass.getDeclaredMethods();
        HashSet<Integer> accessSelectors = new HashSet<Integer>();
        for (int accessSel : cosemAttribute.selector()) {
            accessSelectors.add(accessSel);
        }
        Method setMethod = null;
        Method getMethod = null;
        boolean getAccess = false;
        boolean setAccess = false;
        switch (cosemAttribute.accessMode()) {
            case AUTHENTICATED_READ_AND_WRITE: 
            case READ_AND_WRITE: {
                getAccess = true;
                setAccess = true;
                break;
            }
            case AUTHENTICATED_READ_ONLY: 
            case READ_ONLY: {
                getAccess = true;
                break;
            }
            case AUTHENTICATED_WRITE_ONLY: 
            case WRITE_ONLY: {
                setAccess = true;
                break;
            }
            default: {
                return new AttributeAccessor.FieldAccessor(field, cosemAttribute);
            }
        }
        for (Method method : methods) {
            if (method.getAnnotation(CosemMethod.class) != null) continue;
            String methodName = method.getName().toLowerCase();
            if (getAccess && ServerBuilder.methodIsModifierForField(field.getName(), methodName, "get")) {
                ServerBuilder.checkGetMethod(klass, accessSelectors, method);
                getMethod = method;
            } else {
                if (!setAccess || !ServerBuilder.methodIsModifierForField(field.getName(), methodName, "set")) continue;
                ServerBuilder.checkSetMethod(klass, accessSelectors, method);
                setMethod = method;
            }
            ServerBuilder.verifyIfMethodIsPublic(method);
            ServerBuilder.verifyDeclaredExceptions(klass, method);
            if (getMethod != null && setMethod != null) {
                return ServerBuilder.findBuild(klass, field, cosemAttribute, accessSelectors, setMethod, getMethod);
            }
            if (getMethod != null && !setAccess) {
                return ServerBuilder.findBuild(klass, field, cosemAttribute, accessSelectors, setMethod, getMethod);
            }
            if (setMethod == null || getAccess) continue;
            return ServerBuilder.findBuild(klass, field, cosemAttribute, accessSelectors, setMethod, getMethod);
        }
        return ServerBuilder.findBuild(klass, field, cosemAttribute, accessSelectors, setMethod, getMethod);
    }

    private static AttributeAccessor findBuild(Class<?> klass, Field field, CosemAttribute cosemAttribute, Set<Integer> accessSelectors, Method setMethod, Method getMethod) throws IllegalPametrizationError {
        if (!accessSelectors.isEmpty()) {
            ServerBuilder.checkIfSelAccessParamExists(klass, field, cosemAttribute, setMethod, getMethod);
        }
        field.setAccessible(true);
        if (getMethod != null && setMethod != null) {
            return new AttributeAccessor.MethodAttributeAccessor(getMethod, setMethod, cosemAttribute, accessSelectors);
        }
        if (getMethod == null && setMethod == null) {
            return new AttributeAccessor.FieldAccessor(field, cosemAttribute);
        }
        if (getMethod == null) {
            return new AttributeAccessor.MethodSetFieldGetAccessor(field, setMethod, cosemAttribute, accessSelectors);
        }
        return new AttributeAccessor.FieldSetMethodGetAccessor(field, getMethod, cosemAttribute, accessSelectors);
    }

    private static void checkIfSelAccessParamExists(Class<?> klass, Field field, CosemAttribute cosemAttribute, Method setMethod, Method getMethod) throws IllegalPametrizationError {
        boolean failture = false;
        switch (cosemAttribute.accessMode()) {
            case AUTHENTICATED_READ_AND_WRITE: 
            case READ_AND_WRITE: {
                failture = getMethod == null || setMethod == null;
                break;
            }
            case AUTHENTICATED_READ_ONLY: 
            case READ_ONLY: {
                failture = getMethod == null;
                break;
            }
            case AUTHENTICATED_WRITE_ONLY: 
            case WRITE_ONLY: {
                failture = setMethod == null;
                break;
            }
        }
        if (failture) {
            String message = MessageFormat.format("{0} a set/get method for the selective access must be provided!", ServerBuilder.fieldLocationAsString(klass, field));
            throw new IllegalPametrizationError(message);
        }
    }

    private static void checkSetMethod(Class<?> klass, Set<Integer> accessSelectors, Method method) throws IllegalPametrizationError {
        Class<?>[] parameterTypes = method.getParameterTypes();
        int signatureLength = parameterTypes.length;
        if (!method.getReturnType().isAssignableFrom(Void.TYPE)) {
            String location = ServerBuilder.methodLocationToString(klass, method);
            String message = MessageFormat.format("{0} must return void.", location);
            throw new IllegalPametrizationError(message);
        }
        if (signatureLength == 0) {
            String location = ServerBuilder.methodLocationToString(klass, method);
            String message = MessageFormat.format("{0} must take at least one parameter (DataObject).", location);
            throw new IllegalPametrizationError(message);
        }
        if (!parameterTypes[0].isAssignableFrom(DataObject.class)) {
            String location = ServerBuilder.methodLocationToString(klass, method);
            String message = MessageFormat.format("{0} first parameter must be a DataObject.", location);
            throw new IllegalPametrizationError(message);
        }
        if (!accessSelectors.isEmpty()) {
            if (signatureLength < 2) {
                String location = ServerBuilder.methodLocationToString(klass, method);
                String message = MessageFormat.format("{0} must take at least a DataObject and a SelectiveAccessDescription.", location);
                throw new IllegalPametrizationError(message);
            }
            if (!parameterTypes[1].isAssignableFrom(SelectiveAccessDescription.class)) {
                String location = ServerBuilder.methodLocationToString(klass, method);
                String message = MessageFormat.format("{0} second parameter must be a SelectiveAccessDescription.", location);
                throw new IllegalPametrizationError(message);
            }
            if (signatureLength == 3 && !ServerBuilder.paramIsLong(parameterTypes[2])) {
                String location = ServerBuilder.methodLocationToString(klass, method);
                String message = MessageFormat.format("{0} third parameter must be a long/Long.", location);
                throw new IllegalPametrizationError(message);
            }
            if (signatureLength > 3) {
                String location = ServerBuilder.methodLocationToString(klass, method);
                String message = MessageFormat.format("{0} has to many parameters.", location);
                throw new IllegalPametrizationError(message);
            }
            return;
        }
        if (signatureLength == 2 && !ServerBuilder.paramIsLong(parameterTypes[1])) {
            String location = ServerBuilder.methodLocationToString(klass, method);
            String message = MessageFormat.format("{0} second parameter must be a long/Long.", location);
            throw new IllegalPametrizationError(message);
        }
        if (signatureLength > 2) {
            String location = ServerBuilder.methodLocationToString(klass, method);
            String message = MessageFormat.format("{0} has to many parameters.", location);
            throw new IllegalPametrizationError(message);
        }
    }

    private static void checkGetMethod(Class<?> klass, Set<Integer> accessSelectors, Method method) throws IllegalPametrizationError {
        if (!method.getReturnType().isAssignableFrom(DataObject.class)) {
            String location = ServerBuilder.methodLocationToString(klass, method);
            String message = MessageFormat.format("{0} must return a DataObject.", location);
            throw new IllegalPametrizationError(message);
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        int signatureLength = paramTypes.length;
        if (accessSelectors.isEmpty()) {
            if (signatureLength == 0 || signatureLength == 1 && ServerBuilder.paramIsLong(paramTypes[0])) {
                return;
            }
            String location = ServerBuilder.methodLocationToString(klass, method);
            String message = MessageFormat.format("{0} is not allowed to have parameters, beside a long for the connection ID.", location);
            throw new IllegalPametrizationError(message);
        }
        if (signatureLength == 1 && paramTypes[0].isAssignableFrom(SelectiveAccessDescription.class)) {
            return;
        }
        if (signatureLength == 2 && paramTypes[0].isAssignableFrom(SelectiveAccessDescription.class) && ServerBuilder.paramIsLong(paramTypes[1])) {
            return;
        }
        String location = ServerBuilder.methodLocationToString(klass, method);
        String message = MessageFormat.format("{0} must have selective access as parameter.", location);
        throw new IllegalPametrizationError(message);
    }

    private static boolean paramIsLong(Class<?> parameterType) {
        return parameterType.isAssignableFrom(Long.class) || parameterType.isAssignableFrom(Long.TYPE);
    }

    private static boolean methodIsModifierForField(String fieldName, String methodName, String prefix) {
        return methodName.equalsIgnoreCase(prefix + fieldName);
    }

    private static void verifyDeclaredExceptions(Class<?> klass, Method method) throws IllegalPametrizationError {
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        if (exceptionTypes.length > 1) {
            String message = MessageFormat.format("{0} throws more than one exception.", ServerBuilder.methodLocationToString(klass, method));
            throw new IllegalPametrizationError(message);
        }
        if (exceptionTypes.length == 1 && !IllegalAttributeAccessException.class.isAssignableFrom(exceptionTypes[0])) {
            String message = MessageFormat.format("{0} throws an exception, which is not a subtype of {1}.", ServerBuilder.methodLocationToString(klass, method), IllegalAttributeAccessException.class.getSimpleName());
            throw new IllegalPametrizationError(message);
        }
    }

    private static String methodLocationToString(Class<?> klass, Method method) {
        return MessageFormat.format("Method {0} in class {1}", method.getName(), klass.getName());
    }

    private static void checkIfKeyIsRequired(LogicalDevice logicalDevice) throws IllegalPametrizationError {
        for (SecuritySuite sec : logicalDevice.getRestrictions().values()) {
            boolean usesCiphering;
            boolean hlsMechanism = sec.getAuthenticationMechanism().isHlsMechanism();
            boolean bl = usesCiphering = sec.getEncryptionMechanism() != SecuritySuite.EncryptionMechanism.NONE;
            if (!hlsMechanism && !usesCiphering) continue;
            String msg = String.format("Master key for LD with ID=%d is not set, but is required.", logicalDevice.getLogicalDeviceId());
            throw new IllegalPametrizationError(msg);
        }
    }

    private static void verifyIfMethodIsPublic(Method method) {
        if (Modifier.isPublic(method.getModifiers())) {
            return;
        }
        String message = MessageFormat.format("Method {0} must be public.", method);
        throw new IllegalPametrizationError(message);
    }

    private static void checkClassAnnotation(Class<? extends Object> klass, CosemClass dlmsClass) {
        if (dlmsClass != null) {
            return;
        }
        String message = MessageFormat.format("Class {0} was passes as COSEM class, but is not annotated as {1}.", klass.getName(), CosemClass.class.getSimpleName());
        throw new IllegalPametrizationError(message);
    }

    private static void checkFieldReturnType(Class<? extends Object> klass, Field field) {
        if (field.getType().equals(DataObject.class)) {
            return;
        }
        String erroMessage = MessageFormat.format("Field {0} in class {1} was annotated as {2} but does not have the type {3}.", field.getName(), klass.getName(), CosemAttribute.class.getSimpleName(), DataObject.class.getSimpleName());
        throw new IllegalPametrizationError(erroMessage);
    }

    protected static abstract class ServerSettingsImpl
    implements ServerSettings {
        private int inactivityTimeout;
        private int responseTimeout;
        private int maxClients;
        private ServerConnectionListener connectionListener;
        private ReferencingMethod referencingMethod;

        protected ServerSettingsImpl() {
        }

        @Override
        public int getInactivityTimeout() {
            return this.inactivityTimeout;
        }

        @Override
        public int getResponseTimeout() {
            return this.responseTimeout;
        }

        @Override
        public int getMaxClients() {
            return this.maxClients;
        }

        @Override
        public ServerConnectionListener getConnectionListener() {
            return this.connectionListener;
        }

        @Override
        public ReferencingMethod getReferencingMethod() {
            return this.referencingMethod;
        }
    }
}

