/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import java.io.IOException;
import java.util.Map;
import org.openmuc.jdlms.DlmsConnection;
import org.openmuc.jdlms.DlmsLnToSnConnectionWrapper;
import org.openmuc.jdlms.ObisCode;
import org.openmuc.jdlms.SnClassVersion;

public class SnObjectInfo {
    private final int baseName;
    private final ObisCode instanceId;
    private final SnClassVersion snClassVersion;

    public SnObjectInfo(int baseName, ObisCode instanceId, SnClassVersion snClassVersion) {
        this.baseName = baseName;
        this.instanceId = instanceId;
        this.snClassVersion = snClassVersion;
    }

    public SnClassVersion getSnClassVersion() {
        return this.snClassVersion;
    }

    public int getBaseName() {
        return this.baseName;
    }

    public ObisCode getInstanceId() {
        return this.instanceId;
    }

    public String toString() {
        String format = "{\"class-version\": %s, \"instance-id\": %s, \"base-name\": \"0x%02X\"}";
        return String.format(format, this.snClassVersion, this.instanceId, this.baseName);
    }

    public static Map<ObisCode, SnObjectInfo> retrieveLnToSnMappingFrom(DlmsConnection connection) throws IOException {
        if (!(connection instanceof DlmsLnToSnConnectionWrapper)) {
            throw new IOException("This operation in only available if you're using an SN connection.");
        }
        DlmsLnToSnConnectionWrapper snConnection = (DlmsLnToSnConnectionWrapper)connection;
        return snConnection.getLnSnInfoMapping();
    }
}

