/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import org.openmuc.jdlms.AccessResultCode;
import org.openmuc.jdlms.CosemAttribute;
import org.openmuc.jdlms.CosemInterfaceObject;
import org.openmuc.jdlms.CosemResourceDescriptor;
import org.openmuc.jdlms.DlmsAccessException;
import org.openmuc.jdlms.DlmsInterceptor;
import org.openmuc.jdlms.DlmsInvocationContext;
import org.openmuc.jdlms.IllegalAttributeAccessException;
import org.openmuc.jdlms.ObisCode;
import org.openmuc.jdlms.SecuritySuite;
import org.openmuc.jdlms.SelectiveAccessDescription;
import org.openmuc.jdlms.datatypes.DataObject;
import org.openmuc.jdlms.internal.Accessor;
import org.openmuc.jdlms.internal.AttributeInvokationCtx;
import org.openmuc.jdlms.internal.DataDirectoryImpl;

public interface AttributeAccessor
extends Accessor {
    public DataObject get(DataDirectoryImpl.CosemClassInstance var1, SelectiveAccessDescription var2, Long var3, SecuritySuite.SecurityPolicy var4) throws IllegalAttributeAccessException;

    public void set(DataObject var1, DataDirectoryImpl.CosemClassInstance var2, SelectiveAccessDescription var3, Long var4, SecuritySuite.SecurityPolicy var5) throws IllegalAttributeAccessException;

    public CosemAttribute getCosemAttribute();

    public static class MethodAttributeAccessor
    extends BaseAttributeAccessor {
        private final Method getMethod;
        private final Method setMethod;
        private final Set<Integer> accessSelectors;
        private final boolean containsGetId;
        private final boolean containsSetId;

        public MethodAttributeAccessor(Method getMethod, Method setMethod, CosemAttribute cosemAttribute, Set<Integer> accessSelectors) {
            super(cosemAttribute);
            this.getMethod = getMethod;
            this.setMethod = setMethod;
            this.accessSelectors = accessSelectors;
            this.containsGetId = this.methodHasConnectionIdParam(getMethod);
            this.containsSetId = this.methodHasConnectionIdParam(setMethod);
        }

        private boolean methodHasConnectionIdParam(Method method) {
            if (method == null) {
                return false;
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length == 0) {
                return false;
            }
            int lastIndex = parameterTypes.length - 1;
            return Long.class.isAssignableFrom(parameterTypes[lastIndex]);
        }

        @Override
        public DataObject get(DataDirectoryImpl.CosemClassInstance classInstance, SelectiveAccessDescription selectiveAccessDescription, Long connectionId, SecuritySuite.SecurityPolicy securityPolicy) throws IllegalAttributeAccessException {
            DataObject result;
            Object[] parameter = this.buildGetParameter(selectiveAccessDescription, connectionId);
            CosemInterfaceObject instance = classInstance.getInstance();
            DlmsInterceptor interceptor = instance.getInterceptor();
            if (interceptor != null) {
                CosemResourceDescriptor address = AttributeInvokationCtx.toAttributeDesctiptor(classInstance, super.getCosemAttribute(), instance);
                AttributeInvokationCtx ctx = new AttributeInvokationCtx(securityPolicy, DlmsInvocationContext.XDlmsServiceType.GET, address, instance, this.getMethod, super.getCosemAttribute().type(), parameter){

                    @Override
                    public DataObject proceed() throws DlmsAccessException {
                        return MethodAttributeAccessor.this.saveGet(this.getParameters(), this.getTarget());
                    }
                };
                result = AttributeInvokationCtx.saveCallInterceptIntercept(interceptor, ctx);
            } else {
                result = this.saveGet(parameter, instance);
            }
            if (result == null) {
                return DataObject.newNullData();
            }
            return result;
        }

        private DataObject saveGet(Object[] parameter, CosemInterfaceObject instance) throws IllegalAttributeAccessException {
            try {
                return (DataObject)this.getMethod.invoke((Object)instance, parameter);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAttributeAccessException(AccessResultCode.OTHER_REASON);
            }
            catch (InvocationTargetException e) {
                throw this.convert(e);
            }
        }

        private Object[] buildGetParameter(SelectiveAccessDescription selectiveAccessDescription, Long connectionId) throws IllegalAttributeAccessException {
            Object[] parameter = new Object[this.getMethod.getParameterTypes().length];
            this.setSelectiveAcccessDescription(selectiveAccessDescription, parameter, 0);
            if (this.containsGetId) {
                this.setConnectionId(connectionId, parameter);
            }
            return parameter;
        }

        private void setConnectionId(Long connectionId, Object[] parameter) {
            parameter[parameter.length - 1] = connectionId;
        }

        @Override
        public void set(DataObject newVal, DataDirectoryImpl.CosemClassInstance classInstance, SelectiveAccessDescription selectiveAccessDescription, Long connectionId, SecuritySuite.SecurityPolicy securityPolicy) throws IllegalAttributeAccessException {
            Object[] parameter = this.buildSetParameter(newVal, selectiveAccessDescription, connectionId);
            CosemInterfaceObject instance = classInstance.getInstance();
            DlmsInterceptor interceptor = instance.getInterceptor();
            if (interceptor != null) {
                AttributeInvokationCtx ctx = new AttributeInvokationCtx(securityPolicy, DlmsInvocationContext.XDlmsServiceType.SET, null, instance, this.setMethod, super.getCosemAttribute().type(), parameter){

                    @Override
                    public DataObject proceed() throws DlmsAccessException {
                        MethodAttributeAccessor.this.saveSet(this.getTarget(), this.getParameters());
                        return null;
                    }
                };
                AttributeInvokationCtx.saveCallInterceptIntercept(interceptor, ctx);
            } else {
                this.saveSet(instance, parameter);
            }
        }

        private void saveSet(CosemInterfaceObject instance, Object[] parameter) throws IllegalAttributeAccessException {
            try {
                this.setMethod.invoke((Object)instance, parameter);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAttributeAccessException(AccessResultCode.OTHER_REASON);
            }
            catch (InvocationTargetException e) {
                throw this.convert(e);
            }
        }

        private Object[] buildSetParameter(DataObject newVal, SelectiveAccessDescription selectiveAccessDescription, Long connectionId) throws IllegalAttributeAccessException {
            Object[] parameter = new Object[this.setMethod.getParameterTypes().length];
            parameter[0] = newVal;
            this.setSelectiveAcccessDescription(selectiveAccessDescription, parameter, 1);
            if (this.containsSetId) {
                this.setConnectionId(connectionId, parameter);
            }
            return parameter;
        }

        private void setSelectiveAcccessDescription(SelectiveAccessDescription selectiveAccessDescription, Object[] parameter, int indexOfAccess) throws IllegalAttributeAccessException {
            if (selectiveAccessDescription == null) {
                return;
            }
            if (this.accessSelectors.isEmpty()) {
                throw new IllegalAttributeAccessException(AccessResultCode.SCOPE_OF_ACCESS_VIOLATED);
            }
            parameter[indexOfAccess] = selectiveAccessDescription;
        }

        private IllegalAttributeAccessException convert(InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (!(targetException instanceof IllegalAttributeAccessException)) {
                return new IllegalAttributeAccessException(AccessResultCode.OTHER_REASON);
            }
            return (IllegalAttributeAccessException)targetException;
        }
    }

    public static class FieldSetMethodGetAccessor
    extends BaseAttributeAccessor {
        private final FieldAccessor fieldAccessor;
        private final MethodAttributeAccessor methodAccessor;

        public FieldSetMethodGetAccessor(Field field, Method getMethod, CosemAttribute cosemAttribute, Set<Integer> accessSelectors) {
            super(cosemAttribute);
            this.fieldAccessor = new FieldAccessor(field, cosemAttribute);
            this.methodAccessor = new MethodAttributeAccessor(getMethod, null, cosemAttribute, accessSelectors);
        }

        @Override
        public DataObject get(DataDirectoryImpl.CosemClassInstance cosemClassInstance, SelectiveAccessDescription selectiveAccessDescription, Long connectionId, SecuritySuite.SecurityPolicy securityPolicy) throws IllegalAttributeAccessException {
            return this.methodAccessor.get(cosemClassInstance, selectiveAccessDescription, connectionId, securityPolicy);
        }

        @Override
        public void set(DataObject newVal, DataDirectoryImpl.CosemClassInstance cosemClassInstanc, SelectiveAccessDescription selectiveAccessDescription, Long connectionId, SecuritySuite.SecurityPolicy securityPolicy) throws IllegalAttributeAccessException {
            this.fieldAccessor.set(newVal, cosemClassInstanc, selectiveAccessDescription, connectionId, securityPolicy);
        }
    }

    public static class MethodSetFieldGetAccessor
    extends BaseAttributeAccessor {
        private final FieldAccessor fieldAccessor;
        private final MethodAttributeAccessor methodAccessor;

        public MethodSetFieldGetAccessor(Field field, Method setMethod, CosemAttribute cosemAttribute, Set<Integer> accessSelectors) {
            super(cosemAttribute);
            this.fieldAccessor = new FieldAccessor(field, cosemAttribute);
            this.methodAccessor = new MethodAttributeAccessor(null, setMethod, cosemAttribute, accessSelectors);
        }

        @Override
        public DataObject get(DataDirectoryImpl.CosemClassInstance cosemClassInstance, SelectiveAccessDescription selectiveAccessDescription, Long connectionId, SecuritySuite.SecurityPolicy securityPolicy) throws IllegalAttributeAccessException {
            return this.fieldAccessor.get(cosemClassInstance, selectiveAccessDescription, connectionId, securityPolicy);
        }

        @Override
        public void set(DataObject newVal, DataDirectoryImpl.CosemClassInstance dlmsClassInstance, SelectiveAccessDescription selectiveAccessDescription, Long connectionId, SecuritySuite.SecurityPolicy securityPolicy) throws IllegalAttributeAccessException {
            this.methodAccessor.set(newVal, dlmsClassInstance, selectiveAccessDescription, connectionId, securityPolicy);
        }
    }

    public static class FieldAccessor
    extends BaseAttributeAccessor {
        private final Field field;

        public FieldAccessor(Field field, CosemAttribute cosemAttribute) {
            super(cosemAttribute);
            this.field = field;
        }

        @Override
        public DataObject get(DataDirectoryImpl.CosemClassInstance cosemClassInstance, SelectiveAccessDescription selectiveAccessDescription, Long connectionId, SecuritySuite.SecurityPolicy securityPolicy) throws IllegalAttributeAccessException {
            CosemInterfaceObject instance = cosemClassInstance.getInstance();
            DlmsInterceptor interceptor = instance.getInterceptor();
            DataObject result = interceptor != null ? this.callGetViaInterceptor(cosemClassInstance, securityPolicy, instance, interceptor) : this.saveGet(instance);
            return result == null ? DataObject.newNullData() : result;
        }

        private DataObject callGetViaInterceptor(DataDirectoryImpl.CosemClassInstance cosemClassInstance, SecuritySuite.SecurityPolicy securityPolicy, CosemInterfaceObject instance, DlmsInterceptor interceptor) throws IllegalAttributeAccessException {
            CosemResourceDescriptor attributeDesc = AttributeInvokationCtx.toAttributeDesctiptor(cosemClassInstance, super.getCosemAttribute(), instance);
            AttributeInvokationCtx ctx = new AttributeInvokationCtx(securityPolicy, DlmsInvocationContext.XDlmsServiceType.GET, attributeDesc, instance, this.field, super.getCosemAttribute().type(), new Object[0]){

                @Override
                public DataObject proceed() throws DlmsAccessException {
                    return FieldAccessor.this.saveGet(this.getTarget());
                }
            };
            return AttributeInvokationCtx.saveCallInterceptIntercept(interceptor, ctx);
        }

        private DataObject saveGet(CosemInterfaceObject instance) throws IllegalAttributeAccessException {
            try {
                return (DataObject)this.field.get(instance);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAttributeAccessException(AccessResultCode.OTHER_REASON, (Throwable)e);
            }
        }

        @Override
        public void set(DataObject newVal, DataDirectoryImpl.CosemClassInstance cosemClassInstanc, SelectiveAccessDescription selectiveAccessDescription, Long connectionId, SecuritySuite.SecurityPolicy securityPolicy) throws IllegalAttributeAccessException {
            CosemInterfaceObject instance = cosemClassInstanc.getInstance();
            DlmsInterceptor interceptor = instance.getInterceptor();
            if (interceptor != null) {
                CosemResourceDescriptor attributeDesc = AttributeInvokationCtx.toAttributeDesctiptor(cosemClassInstanc, super.getCosemAttribute(), instance);
                AttributeInvokationCtx ctx = new AttributeInvokationCtx(securityPolicy, DlmsInvocationContext.XDlmsServiceType.SET, attributeDesc, instance, this.field, super.getCosemAttribute().type(), new Object[]{newVal}){

                    @Override
                    public DataObject proceed() throws DlmsAccessException {
                        FieldAccessor.this.saveSet((DataObject)this.getParameters()[0], this.getTarget());
                        return null;
                    }
                };
                AttributeInvokationCtx.saveCallInterceptIntercept(interceptor, ctx);
            } else {
                this.saveSet(newVal, instance);
            }
        }

        private void saveSet(DataObject newVal, CosemInterfaceObject instance) throws IllegalAttributeAccessException {
            try {
                this.field.set(instance, newVal);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAttributeAccessException(AccessResultCode.OTHER_REASON, (Throwable)e);
            }
        }
    }

    public static class LogicalNameFakeAccessor
    extends BaseAttributeAccessor {
        private final ObisCode instanceId;

        public LogicalNameFakeAccessor(ObisCode instanceId, CosemAttribute cosemAttribute) {
            super(cosemAttribute);
            this.instanceId = instanceId;
        }

        @Override
        public DataObject get(DataDirectoryImpl.CosemClassInstance cosemClassInstance, SelectiveAccessDescription selectiveAccessDescription, Long connectionId, SecuritySuite.SecurityPolicy securityPolicy) throws IllegalAttributeAccessException {
            return DataObject.newOctetStringData(this.instanceId.bytes());
        }

        @Override
        public void set(DataObject newVal, DataDirectoryImpl.CosemClassInstance dlmsClassInstanc, SelectiveAccessDescription selectiveAccessDescription, Long connectionId, SecuritySuite.SecurityPolicy securityPolicy) throws IllegalAttributeAccessException {
            throw new IllegalAttributeAccessException(AccessResultCode.READ_WRITE_DENIED);
        }
    }

    public static abstract class BaseAttributeAccessor
    implements AttributeAccessor {
        private final CosemAttribute cosemAttribute;

        public BaseAttributeAccessor(CosemAttribute cosemAttribute) {
            this.cosemAttribute = cosemAttribute;
        }

        @Override
        public final Accessor.AccessorType getAccessorType() {
            return Accessor.AccessorType.ATTRIBUTE;
        }

        @Override
        public final CosemAttribute getCosemAttribute() {
            return this.cosemAttribute;
        }
    }
}

