/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openmuc.jdlms.AccessResultCode;
import org.openmuc.jdlms.AttributeAddress;
import org.openmuc.jdlms.AuthenticationMechanism;
import org.openmuc.jdlms.CosemAttribute;
import org.openmuc.jdlms.CosemClass;
import org.openmuc.jdlms.CosemInterfaceObject;
import org.openmuc.jdlms.CosemResourceDescriptor;
import org.openmuc.jdlms.DataDirectory;
import org.openmuc.jdlms.IllegalAttributeAccessException;
import org.openmuc.jdlms.IllegalMethodAccessException;
import org.openmuc.jdlms.LogicalDevice;
import org.openmuc.jdlms.MethodAccessMode;
import org.openmuc.jdlms.MethodParameter;
import org.openmuc.jdlms.MethodResultCode;
import org.openmuc.jdlms.ObisCode;
import org.openmuc.jdlms.SecuritySuite;
import org.openmuc.jdlms.SelectiveAccessDescription;
import org.openmuc.jdlms.SetParameter;
import org.openmuc.jdlms.datatypes.DataObject;
import org.openmuc.jdlms.internal.Accessor;
import org.openmuc.jdlms.internal.AttributeAccessor;
import org.openmuc.jdlms.internal.BaseNameRange;
import org.openmuc.jdlms.internal.BaseNameRangeSet;
import org.openmuc.jdlms.internal.DataConverter;
import org.openmuc.jdlms.internal.MethodAccessor;
import org.openmuc.jdlms.internal.ServerConnectionData;
import org.openmuc.jdlms.internal.asn1.cosem.Data;
import org.openmuc.jdlms.internal.asn1.cosem.ParameterizedAccess;

public class DataDirectoryImpl
implements DataDirectory {
    private final Map<Integer, CosemLogicalDevice> logicalDeviceMap = new HashMap<Integer, CosemLogicalDevice>();
    private final Map<Long, ServerConnectionData> connectionsData = new HashMap<Long, ServerConnectionData>();

    private DataObject invokeMethod(CosemClassInstance dlmsClassInstance, MethodAccessor method, DataObject params, Long connectionId) throws IllegalMethodAccessException {
        SecuritySuite sec = this.getConnectionData(connectionId).getSecuritySuite();
        SecuritySuite.SecurityPolicy securityPolicy = sec.getSecurityPolicy();
        MethodAccessMode accessMode = method.getCosemMethod().accessMode();
        if (accessMode == MethodAccessMode.NO_ACCESS) {
            throw new IllegalMethodAccessException(MethodResultCode.READ_WRITE_DENIED);
        }
        if (accessMode == MethodAccessMode.AUTHENTICATED_ACCESS && !securityPolicy.isAuthenticated()) {
            throw new IllegalMethodAccessException(MethodResultCode.READ_WRITE_DENIED);
        }
        return method.invoke(dlmsClassInstance, params, connectionId, securityPolicy);
    }

    public Set<Integer> getLogicalDeviceIds() {
        return this.logicalDeviceMap.keySet();
    }

    public boolean doesLogicalDeviceExists(int logicalDeviceId) {
        return this.logicalDeviceMap.containsKey(logicalDeviceId);
    }

    public CosemLogicalDevice addLogicalDevice(int logicalDeviceId, CosemLogicalDevice logicalDevice) {
        return this.logicalDeviceMap.put(logicalDeviceId, logicalDevice);
    }

    private AccessResultCode set(CosemClassInstance dlmsClassInstance, AttributeAccessor accessor, DataObject data, SelectiveAccessDescription accessSelection, Long connectionId) {
        CosemAttribute attributeProperties = accessor.getCosemAttribute();
        try {
            this.checkSetAccess(attributeProperties, data.getType());
        }
        catch (IllegalAttributeAccessException e) {
            return e.getAccessResultCode();
        }
        ServerConnectionData connectionData = this.getConnectionData(connectionId);
        try {
            accessor.set(data, dlmsClassInstance, accessSelection, connectionId, connectionData.getSecuritySuite().getSecurityPolicy());
        }
        catch (IllegalAttributeAccessException e) {
            return e.getAccessResultCode();
        }
        return AccessResultCode.SUCCESS;
    }

    private void checkSetAccess(CosemAttribute attributeProperties, DataObject.Type type) throws IllegalAttributeAccessException {
        switch (attributeProperties.accessMode()) {
            case READ_ONLY: 
            case NO_ACCESS: {
                throw new IllegalAttributeAccessException(AccessResultCode.READ_WRITE_DENIED);
            }
        }
        if (attributeProperties.type() == DataObject.Type.DONT_CARE || attributeProperties.type() != type) {
            // empty if block
        }
    }

    public synchronized void snSetOrInvoke(int logicalDeviceId, int variableName, Data data, Long connectionId) throws IllegalAttributeAccessException, IllegalMethodAccessException {
        BaseNameRangeSet rangeSet = this.baseNameRangesFor(logicalDeviceId);
        BaseNameRange range = (BaseNameRange)rangeSet.getIntersectingRange(variableName);
        Accessor accessor = this.accessorFor(variableName, range);
        if (accessor.getAccessorType() != Accessor.AccessorType.ATTRIBUTE) {
            throw new IllegalAttributeAccessException(AccessResultCode.OBJECT_UNDEFINED);
        }
        CosemSnClassInstance classInstance = range.getClassInstance();
        DataObject dataObject = DataDirectoryImpl.convert(data);
        switch (accessor.getAccessorType()) {
            case METHOD: {
                this.invokeMethod(classInstance, (MethodAccessor)accessor, dataObject, connectionId);
                break;
            }
            default: {
                this.set(classInstance, (AttributeAccessor)accessor, dataObject, null, connectionId);
            }
        }
    }

    private static DataObject convert(Data data) {
        if (data != null) {
            return DataConverter.convertDataToDataObject(data);
        }
        return DataObject.newNullData();
    }

    public synchronized DataObject snGetOrInvoke(int logicalDeviceId, int variableName, ParameterizedAccess parameterizedAccess, Long connectionId) throws IllegalAttributeAccessException, IllegalMethodAccessException {
        BaseNameRangeSet rangeSet = this.baseNameRangesFor(logicalDeviceId);
        BaseNameRange range = (BaseNameRange)rangeSet.getIntersectingRange(variableName);
        Accessor accessor = this.accessorFor(variableName, range);
        SelectiveAccessDescription selection = DataDirectoryImpl.convertToAccessDescription(parameterizedAccess);
        CosemSnClassInstance classInstance = range.getClassInstance();
        switch (accessor.getAccessorType()) {
            case METHOD: {
                if (selection == null) {
                    throw new IllegalMethodAccessException(MethodResultCode.READ_WRITE_DENIED);
                }
                DataObject params = selection.getAccessParameter();
                return this.invokeMethod(classInstance, (MethodAccessor)accessor, params, connectionId);
            }
        }
        return this.get(classInstance, (AttributeAccessor)accessor, selection, connectionId);
    }

    private Accessor accessorFor(int variableName, BaseNameRange range) throws IllegalAttributeAccessException {
        if (range == null) {
            throw new IllegalAttributeAccessException(AccessResultCode.OBJECT_UNDEFINED);
        }
        CosemSnClassInstance classInstance = range.getClassInstance();
        if (variableName % 8 != 0) {
            throw new IllegalAttributeAccessException(AccessResultCode.OBJECT_UNDEFINED);
        }
        Accessor accessor = classInstance.accessorFor(variableName - range.getBaseName());
        if (accessor == null) {
            throw new IllegalAttributeAccessException(AccessResultCode.OBJECT_UNDEFINED);
        }
        return accessor;
    }

    private static SelectiveAccessDescription convertToAccessDescription(ParameterizedAccess parameterizedAccess) {
        if (parameterizedAccess == null) {
            return null;
        }
        DataObject parameter = DataConverter.convertDataToDataObject(parameterizedAccess.parameter);
        int selector = (int)(parameterizedAccess.selector.getValue() & 0xFFL);
        return new SelectiveAccessDescription(selector, parameter);
    }

    private DataObject get(CosemClassInstance dlmsClassInstance, AttributeAccessor attributeAccessor, SelectiveAccessDescription accessSelection, Long connectionId) throws IllegalAttributeAccessException {
        ServerConnectionData connectionData = this.connectionsData.get(connectionId);
        this.checkGetAccess(attributeAccessor.getCosemAttribute(), connectionData);
        return attributeAccessor.get(dlmsClassInstance, accessSelection, connectionId, connectionData.getSecuritySuite().getSecurityPolicy());
    }

    public synchronized DataObject invokeMethod(int logicalDeviceId, MethodParameter params, Long connectionId) throws IllegalMethodAccessException {
        CosemClassInstance dlmsClassInstance = this.retrieveDlmsClassInstance(logicalDeviceId, params);
        if (dlmsClassInstance == null) {
            throw new IllegalMethodAccessException(MethodResultCode.OBJECT_UNDEFINED);
        }
        MethodAccessor method = this.findMethodAccessorFor(params.getId(), dlmsClassInstance);
        return this.invokeMethod(dlmsClassInstance, method, params.getParameter(), connectionId);
    }

    public synchronized DataObject get(int logicalDeviceId, AttributeAddress attributeAddress, Long connectionId) throws IllegalAttributeAccessException {
        CosemClassInstance dlmsClassInstance = this.retrieveDlmsClassInstance(logicalDeviceId, attributeAddress);
        if (dlmsClassInstance == null) {
            throw new IllegalAttributeAccessException(AccessResultCode.OBJECT_UNDEFINED);
        }
        AttributeAccessor accessor = this.findAttributeAccessorFor(dlmsClassInstance, attributeAddress.getId());
        return this.get(dlmsClassInstance, accessor, attributeAddress.getAccessSelection(), connectionId);
    }

    public synchronized AccessResultCode set(int logicalDeviceId, SetParameter setParameter, Long connectionId) {
        AttributeAccessor accessor;
        CosemClassInstance dlmsClassInstance;
        AttributeAddress attributeAddress = setParameter.getAttributeAddress();
        try {
            dlmsClassInstance = this.retrieveDlmsClassInstance(logicalDeviceId, attributeAddress);
            if (dlmsClassInstance == null) {
                return AccessResultCode.OBJECT_UNDEFINED;
            }
            accessor = this.findAttributeAccessorFor(dlmsClassInstance, attributeAddress.getId());
        }
        catch (IllegalAttributeAccessException e) {
            return e.getAccessResultCode();
        }
        return this.set(dlmsClassInstance, accessor, setParameter.getData(), attributeAddress.getAccessSelection(), connectionId);
    }

    private MethodAccessor findMethodAccessorFor(long methodId, CosemClassInstance dlmsClassInstance) throws IllegalMethodAccessException {
        if (dlmsClassInstance == null) {
            throw new IllegalMethodAccessException(MethodResultCode.OBJECT_UNDEFINED);
        }
        return dlmsClassInstance.getMethod((byte)methodId);
    }

    private AttributeAccessor findAttributeAccessorFor(CosemClassInstance dlmsClassInstance, int attributeId) throws IllegalAttributeAccessException {
        AttributeAccessor entry = dlmsClassInstance.getAttribute((byte)attributeId);
        if (entry == null) {
            throw new IllegalAttributeAccessException(AccessResultCode.READ_WRITE_DENIED);
        }
        return entry;
    }

    private CosemClassInstance retrieveDlmsClassInstance(int logicalDeviceId, CosemResourceDescriptor cosemResourceDescriptor) {
        CosemLogicalDevice logicalDevice = this.getLogicalDeviceFor(logicalDeviceId);
        CosemClassInstance dlmsClassInstance = logicalDevice.get(cosemResourceDescriptor.getInstanceId());
        if (dlmsClassInstance == null || cosemResourceDescriptor.getClassId() != dlmsClassInstance.getCosemClass().id()) {
            return null;
        }
        return dlmsClassInstance;
    }

    private void checkGetAccess(CosemAttribute attributeProperties, ServerConnectionData connectionData) throws IllegalAttributeAccessException {
        switch (attributeProperties.accessMode()) {
            case NO_ACCESS: 
            case AUTHENTICATED_WRITE_ONLY: 
            case WRITE_ONLY: {
                throw new IllegalAttributeAccessException(AccessResultCode.READ_WRITE_DENIED);
            }
            case AUTHENTICATED_READ_ONLY: 
            case AUTHENTICATED_READ_AND_WRITE: {
                SecuritySuite securitySuite = connectionData.getSecuritySuite();
                if (securitySuite.getAuthenticationMechanism() != AuthenticationMechanism.NONE) break;
                throw new IllegalAttributeAccessException(AccessResultCode.READ_WRITE_DENIED);
            }
        }
    }

    public CosemLogicalDevice getLogicalDeviceFor(Integer logicalDeviceId) {
        return this.logicalDeviceMap.get(logicalDeviceId);
    }

    public ServerConnectionData addConnection(Long connectionId, ServerConnectionData connectionData) {
        return this.connectionsData.put(connectionId, connectionData);
    }

    public ServerConnectionData getConnectionData(Long connectionId) {
        return this.connectionsData.get(connectionId);
    }

    public ServerConnectionData removeConnection(Long connectionId) {
        return this.connectionsData.remove(connectionId);
    }

    public BaseNameRangeSet baseNameRangesFor(Integer logicalDeviceId) {
        return this.logicalDeviceMap.get(logicalDeviceId).getBaseNameRanges();
    }

    public static class CosemClassInstance {
        private final Map<Byte, AttributeAccessor> attributesMap = new HashMap<Byte, AttributeAccessor>();
        private final Map<Byte, MethodAccessor> methodsMap = new HashMap<Byte, MethodAccessor>();
        private final CosemInterfaceObject instance;
        private final CosemClass cosemClass;

        public CosemClassInstance(CosemClass cosemClass, CosemInterfaceObject instance) {
            this.instance = instance;
            this.cosemClass = cosemClass;
        }

        public CosemClass getCosemClass() {
            return this.cosemClass;
        }

        public CosemInterfaceObject getInstance() {
            return this.instance;
        }

        public Accessor putAttribute(Byte attributeId, AttributeAccessor value) {
            return this.attributesMap.put(attributeId, value);
        }

        protected AttributeAccessor getAttribute(Byte attributeId) {
            return this.attributesMap.get(attributeId);
        }

        public Accessor putMethod(Byte methodId, MethodAccessor value) {
            return this.methodsMap.put(methodId, value);
        }

        private MethodAccessor getMethod(Byte methodId) {
            return this.methodsMap.get(methodId);
        }

        public Collection<MethodAccessor> getMethods() {
            return this.methodsMap.values();
        }

        public Collection<AttributeAccessor> getAttributes() {
            return this.attributesMap.values();
        }

        public Collection<MethodAccessor> getSortedMethods() {
            ArrayList<MethodAccessor> sortedEntries = new ArrayList<MethodAccessor>(this.getMethods());
            Collections.sort(sortedEntries, new Comparator<MethodAccessor>(){

                @Override
                public int compare(MethodAccessor o1, MethodAccessor o2) {
                    return Integer.compare(o1.getCosemMethod().id(), o2.getCosemMethod().id());
                }
            });
            return sortedEntries;
        }

        public Collection<AttributeAccessor> getSortedAttributes() {
            ArrayList<AttributeAccessor> sortedEntries = new ArrayList<AttributeAccessor>(this.getAttributes());
            Collections.sort(sortedEntries, new Comparator<AttributeAccessor>(){

                @Override
                public int compare(AttributeAccessor o1, AttributeAccessor o2) {
                    return Integer.compare(o1.getCosemAttribute().id(), o2.getCosemAttribute().id());
                }
            });
            return sortedEntries;
        }
    }

    public static class CosemSnClassInstance
    extends CosemClassInstance {
        private final Map<Integer, Accessor> m = new HashMap<Integer, Accessor>();

        public CosemSnClassInstance(CosemClass cosemClass, CosemInterfaceObject instance) {
            super(cosemClass, instance);
        }

        private Accessor accessorFor(int snOffset) {
            return this.m.get(snOffset);
        }

        public int getMaxSnOffset() {
            return Collections.max(this.m.keySet());
        }

        @Override
        public Accessor putMethod(Byte methodId, MethodAccessor methodAccessor) {
            Accessor accessor = this.m.put(methodAccessor.getCosemMethod().snOffset(), methodAccessor);
            if (accessor != null) {
                return accessor;
            }
            return super.putMethod(methodId, methodAccessor);
        }

        @Override
        public Accessor putAttribute(Byte attributeId, AttributeAccessor value) {
            Accessor accessor = this.m.put(value.getCosemAttribute().snOffset(), value);
            if (accessor != null) {
                return accessor;
            }
            return super.putAttribute(attributeId, value);
        }
    }

    public static class CosemLogicalDevice {
        private final Map<ObisCode, CosemClassInstance> classes;
        private final LogicalDevice logicalDevice;
        private final BaseNameRangeSet baseNameRanges;

        public CosemLogicalDevice(LogicalDevice logicalDevice, BaseNameRangeSet baseNameRanges) {
            this.baseNameRanges = baseNameRanges;
            this.classes = new HashMap<ObisCode, CosemClassInstance>();
            this.logicalDevice = logicalDevice;
        }

        public CosemClassInstance put(ObisCode key, CosemClassInstance classInstance) {
            return this.classes.put(key, classInstance);
        }

        public LogicalDevice getLogicalDevice() {
            return this.logicalDevice;
        }

        public BaseNameRangeSet getBaseNameRanges() {
            return this.baseNameRanges;
        }

        public Set<ObisCode> getInstanceIds() {
            return this.classes.keySet();
        }

        public CosemClassInstance get(ObisCode key) {
            return this.classes.get(key);
        }
    }
}

