/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.openmuc.jdlms.datatypes.DlmsEnumeration;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrInteger;

public class DlmsEnumFunctions {
    public static <T extends Enum<T>> T enumValueFrom(long code, Class<T> enumClass) {
        return DlmsEnumFunctions.enumValueFrom(new AxdrInteger(code), enumClass);
    }

    public static <T extends DlmsEnumeration> AxdrEnum enumToAxdrEnum(T dlmsEnum) {
        return new AxdrEnum(dlmsEnum.getCode());
    }

    public static <T extends Enum<T>, M extends AxdrInteger> T enumValueFrom(M code, Class<T> enumClass) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        long maskedCode = code.getValue() & 0xFFFFFFFFFFFFFFFFL;
        for (Enum constant : enumConstants) {
            if (((DlmsEnumeration)((Object)constant)).getCode() != maskedCode) continue;
            return (T)constant;
        }
        String message = MessageFormat.format("No constant with code {0} in {1}.", maskedCode, enumClass.getSimpleName());
        throw new IllegalArgumentException(message);
    }

    public static <T extends Enum<T>> Map<Long, T> generateEnumMap(Class<T> enumClass) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        HashMap<Long, Enum> map = new HashMap<Long, Enum>(enumConstants.length);
        for (Enum constant : enumConstants) {
            map.put(((DlmsEnumeration)((Object)constant)).getCode(), constant);
        }
        return map;
    }

    public static <T extends Enum<T>> T constantFor(Map<Long, T> mapping, Long code, T defaultValue) {
        Enum constant = (Enum)mapping.get(code);
        if (constant != null) {
            return (T)constant;
        }
        return defaultValue;
    }

    private DlmsEnumFunctions() {
    }
}

