/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal;

import java.io.Serializable;
import java.text.MessageFormat;

public class Range<T extends Serializable & Comparable<T>>
implements Serializable {
    private static final long serialVersionUID = 6560287867950653244L;
    private final T fromInclusive;
    private final T toInclusive;

    protected Range(T fromInclusive, T toInclusive) {
        if (((Comparable)toInclusive).compareTo(fromInclusive) < 0) {
            throw new IllegalArgumentException("Lower bound is greater than upper bound. [" + fromInclusive + "," + toInclusive + "]");
        }
        this.fromInclusive = fromInclusive;
        this.toInclusive = toInclusive;
    }

    public static <T extends Comparable<T> & Serializable> Range<T> between(T fromInclusive, T toInclusive) {
        return new Range<Serializable>(fromInclusive, toInclusive);
    }

    public static <T extends Comparable<T> & Serializable> Range<T> is(T element) {
        return new Range<Serializable>(element, element);
    }

    public boolean intersects(Range<T> other) {
        if (((Comparable)this.fromInclusive).compareTo(other.fromInclusive) > 0) {
            return ((Comparable)other.toInclusive).compareTo(this.fromInclusive) >= 0;
        }
        if (((Comparable)this.fromInclusive).compareTo(other.fromInclusive) < 0) {
            return ((Comparable)this.toInclusive).compareTo(other.fromInclusive) >= 0;
        }
        return true;
    }

    public boolean intersectsWith(T elem) {
        return ((Comparable)this.fromInclusive).compareTo(elem) <= 0 && ((Comparable)this.toInclusive).compareTo(elem) >= 0;
    }

    public T getMinimum() {
        return this.fromInclusive;
    }

    public T getMaximum() {
        return this.toInclusive;
    }

    public String toString() {
        return MessageFormat.format("'{'\"fromInclusive: \"{0,number,#}\", \"toInclusive\": \"{1,number,#}\"'}'", this.fromInclusive, this.toInclusive);
    }
}

