/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.openmuc.jdlms.internal.Range;

public class RangeSet<E extends Comparable<E> & Serializable>
implements Serializable {
    private static final long serialVersionUID = -5099873409745118159L;
    private int size = 0;
    private RangeEntry rootElement = null;
    private RangeEntry smallest;
    private RangeEntry biggest;
    private final List<Range<E>> internalList = new LinkedList<Range<E>>();

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public <T extends Range<E>> List<T> toList() {
        return this.internalList;
    }

    public String toString() {
        return this.toList().toString();
    }

    public <T extends Range<E>> T getIntersectingRange(E elem) {
        RangeEntry curr = this.rootElement;
        while (curr != null) {
            if (curr.value.intersectsWith((Serializable)elem)) {
                return (T)curr.value;
            }
            if (((Comparable)curr.value.getMinimum()).compareTo(elem) < 0) {
                curr = curr.rightChild;
                continue;
            }
            curr = curr.leftChild;
        }
        return null;
    }

    public boolean intersectsWith(Range<E> r) {
        return this.checkIntersects(r, this.rootElement);
    }

    private boolean checkIntersects(Range<E> r, RangeEntry curr) {
        if (curr == null) {
            return false;
        }
        if (curr.value.intersects(r)) {
            return true;
        }
        int c = ((Comparable)curr.value.getMinimum()).compareTo(r.getMinimum());
        if (c < 0) {
            return this.checkIntersects(r, curr.leftChild);
        }
        if (c > 0) {
            return this.checkIntersects(r, curr.rightChild);
        }
        return true;
    }

    public <T extends Range<E>> T add(T entry) {
        RangeEntry newEntry;
        if (this.rootElement != null) {
            return (T)this.addNode(entry, this.rootElement);
        }
        this.biggest = this.rootElement = (newEntry = new RangeEntry(entry));
        this.smallest = this.rootElement;
        ++this.size;
        this.internalList.add(entry);
        return null;
    }

    private Range<E> addNode(Range<E> entry, RangeEntry curr) {
        int comparison = ((Comparable)curr.value.getMinimum()).compareTo(entry.getMinimum());
        if (comparison > 0) {
            return this.handleLeft(entry, curr);
        }
        if (comparison < 0) {
            return this.handleRight(entry, curr);
        }
        return entry;
    }

    private Range<E> handleRight(Range<E> entry, RangeEntry curr) {
        if (curr.rightChild != null) {
            return this.addNode(entry, curr.rightChild);
        }
        return this.addAsPrevRight(entry, curr);
    }

    private Range<E> handleLeft(Range<E> entry, RangeEntry curr) {
        if (curr.leftChild != null) {
            return this.addNode(entry, curr.leftChild);
        }
        return this.addAsPrevLeft(entry, curr);
    }

    private Range<E> addAsPrevRight(Range<E> e, RangeEntry prev) {
        if (prev.value.intersects(e)) {
            return prev.value;
        }
        RangeEntry newEntry = new RangeEntry(e);
        prev.rightChild = newEntry;
        prev.rightChild.parent = prev;
        if (((Comparable)this.biggest.value.getMinimum()).compareTo(e.getMinimum()) < 0) {
            this.biggest = newEntry;
        }
        this.internalList.add(e);
        ++this.size;
        return null;
    }

    private Range<E> addAsPrevLeft(Range<E> e, RangeEntry prev) {
        if (e.intersects(prev.value)) {
            return prev.value;
        }
        RangeEntry newEntry = new RangeEntry(e);
        prev.leftChild = newEntry;
        prev.leftChild.parent = prev;
        if (((Comparable)this.smallest.value.getMinimum()).compareTo(e.getMinimum()) > 0) {
            this.smallest = newEntry;
        }
        this.internalList.add(e);
        ++this.size;
        return null;
    }

    private class RangeEntry
    implements Serializable {
        private static final long serialVersionUID = 7595589083919072971L;
        private final Range<E> value;
        private RangeEntry leftChild;
        private RangeEntry rightChild;
        private RangeEntry parent;

        public RangeEntry(Range<E> value) {
            this.value = value;
            this.leftChild = null;
            this.rightChild = null;
            this.parent = null;
        }
    }
}

