/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal;

import org.openmuc.jdlms.SecuritySuite;
import org.openmuc.jdlms.sessionlayer.server.ServerSessionLayer;

public class ServerConnectionData {
    private byte[] serverToClientChallenge;
    private byte[] clientToServerChallenge;
    private int clientId;
    private byte[] clientSystemTitle;
    private int frameCounter;
    private boolean authenticated;
    private long clientMaxReceivePduSize;
    private SecuritySuite securitySuite;
    private final ServerSessionLayer sessionLayer;
    private final Long connectionId;

    public ServerConnectionData(ServerSessionLayer sessionLayer, Long connectionId) {
        this.sessionLayer = sessionLayer;
        this.connectionId = connectionId;
        this.authenticated = false;
        this.frameCounter = 1;
        this.securitySuite = SecuritySuite.builder().build();
    }

    public SecuritySuite getSecuritySuite() {
        return this.securitySuite;
    }

    public int getClientId() {
        return this.clientId;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setSecuritySuite(SecuritySuite securitySuite) {
        this.securitySuite = securitySuite;
    }

    public Long getConnectionId() {
        return this.connectionId;
    }

    public ServerSessionLayer getSessionLayer() {
        return this.sessionLayer;
    }

    public void setClientId(int clientId) {
        this.clientId = clientId;
    }

    public byte[] getClientSystemTitle() {
        return this.clientSystemTitle;
    }

    public void setClientSystemTitle(byte[] clientSystemTitle) {
        this.clientSystemTitle = clientSystemTitle;
    }

    public int getAndIncrementFc() {
        return this.frameCounter++;
    }

    public int getFrameCounter() {
        return this.frameCounter;
    }

    public long getClientMaxReceivePduSize() {
        return this.clientMaxReceivePduSize;
    }

    public void setClientMaxReceivePduSize(long clientMaxReceivePduSize) {
        this.clientMaxReceivePduSize = clientMaxReceivePduSize;
    }

    public byte[] getClientToServerChallenge() {
        return this.clientToServerChallenge;
    }

    public void setClientToServerChallenge(byte[] clientToServerChallenge) {
        this.clientToServerChallenge = clientToServerChallenge;
    }

    public byte[] getServerToClientChallenge() {
        return this.serverToClientChallenge;
    }

    public void setServerToClientChallenge(byte[] serverToClientChallenge) {
        this.serverToClientChallenge = serverToClientChallenge;
    }

    public void setAuthenticated() {
        this.authenticated = true;
    }
}

