/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.axdr.types;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrLength;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;

public class AxdrBitString
implements AxdrType {
    private byte[] bitString;
    private int numBits = 0;
    private final boolean fixedLength;

    public AxdrBitString() {
        this.fixedLength = false;
    }

    public AxdrBitString(int numBits) {
        this.numBits = numBits;
        this.fixedLength = true;
    }

    public AxdrBitString(byte[] value) {
        this.bitString = value;
        this.fixedLength = true;
    }

    public AxdrBitString(byte[] value, int numBits) {
        if (value == null) {
            throw new NullPointerException("value cannot be null");
        }
        if (numBits < 0) {
            throw new IllegalArgumentException("numBits cannot be negative.");
        }
        if (numBits > value.length * 8) {
            throw new IllegalArgumentException("'value' is too short to hold all bits.");
        }
        this.numBits = numBits;
        this.bitString = value;
        this.fixedLength = false;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength = this.bitString.length;
        for (int i = this.bitString.length - 1; i >= 0; --i) {
            axdrOStream.write(this.bitString[i]);
        }
        if (!this.fixedLength) {
            AxdrLength length = new AxdrLength(this.numBits);
            codeLength += length.encode(axdrOStream);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        if (!this.fixedLength) {
            AxdrLength l = new AxdrLength();
            codeLength += l.decode(iStream);
            this.numBits = l.getValue();
        }
        int byteArrayLength = this.numBits % 8 == 0 ? this.numBits / 8 : this.numBits / 8 + 1;
        codeLength += byteArrayLength;
        this.bitString = new byte[byteArrayLength];
        if (byteArrayLength != 0 && iStream.read(this.bitString, 0, byteArrayLength) < byteArrayLength) {
            throw new IOException("Error Decoding AxdrBitString");
        }
        return codeLength;
    }

    public byte[] getValue() {
        return this.bitString;
    }

    public int getNumBits() {
        return this.numBits;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.numBits; ++i) {
            if ((this.bitString[i / 8] & 0xFF & 128 >> i % 8) == 128 >> i % 8) {
                sb.append('1');
                continue;
            }
            sb.append('0');
        }
        return sb.toString();
    }
}

