/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.axdr.types;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrBoolean;

public class AxdrOptional<T extends AxdrType> {
    private T value;
    private boolean usage;

    public AxdrOptional(T value, boolean usage) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        this.value = value;
        this.usage = usage;
    }

    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength = 0;
        if (this.usage) {
            codeLength += this.value.encode(axdrOStream);
        }
        return codeLength += new AxdrBoolean(this.usage).encode(axdrOStream);
    }

    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        AxdrBoolean axdrUsage = new AxdrBoolean();
        codeLength += axdrUsage.decode(iStream);
        this.usage = axdrUsage.getValue();
        if (this.usage) {
            codeLength += this.value.decode(iStream);
        }
        return codeLength;
    }

    public void setUsed(boolean use) {
        this.usage = use;
    }

    public boolean isUsed() {
        return this.usage;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        boolean bl = this.usage = value != null;
        if (value != null) {
            this.value = value;
        }
    }

    public String toString() {
        if (this.usage) {
            return this.value.toString();
        }
        return "not set";
    }
}

