/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.axdr.types;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrLength;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;

public abstract class AxdrSequenceOf<E extends AxdrType>
implements AxdrType {
    private byte[] code = null;
    private Integer length = null;
    private List<E> seqOf;

    public AxdrSequenceOf() {
        this.seqOf = new LinkedList();
    }

    public AxdrSequenceOf(byte[] code) {
        this.code = code;
        this.seqOf = new LinkedList();
    }

    public AxdrSequenceOf(List<E> seqOf) {
        this.seqOf = seqOf;
    }

    protected AxdrSequenceOf(int length) {
        this.length = length;
        this.seqOf = new ArrayList(length);
    }

    public byte[] getCode() {
        return this.code;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
        } else {
            if (this.length != null && this.length.intValue() != this.seqOf.size()) {
                throw new IOException("Error decoding AxdrSequenceOf: Size of elements does not match.");
            }
            codeLength = 0;
            for (int i = this.seqOf.size() - 1; i >= 0; --i) {
                codeLength += ((AxdrType)this.seqOf.get(i)).encode(axdrOStream);
            }
            if (this.length == null) {
                codeLength += AxdrLength.encodeLength(axdrOStream, this.seqOf.size());
            }
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int numElements;
        int codeLength = 0;
        int n = numElements = this.length == null ? 0 : this.length;
        if (numElements == 0) {
            AxdrLength l = new AxdrLength();
            codeLength += l.decode(iStream);
            numElements = l.getValue();
        }
        this.seqOf = new LinkedList();
        for (int i = 0; i < numElements; ++i) {
            E subElem = this.createListElement();
            codeLength += subElem.decode(iStream);
            this.seqOf.add(subElem);
        }
        return codeLength;
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public void add(E element) {
        if (this.length != null && this.seqOf.size() == this.length.intValue()) {
            throw new IndexOutOfBoundsException();
        }
        this.seqOf.add(element);
    }

    public E get(int index) {
        return (E)((AxdrType)this.seqOf.get(index));
    }

    public int size() {
        return this.seqOf.size();
    }

    public Iterator<E> iterator() {
        return this.seqOf.iterator();
    }

    public List<E> list() {
        return Collections.unmodifiableList(this.seqOf);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SEQUENCE OF{");
        if (this.seqOf == null) {
            sb.append("null");
        } else {
            Iterator<E> it = this.seqOf.iterator();
            if (it.hasNext()) {
                sb.append(it.next());
                while (it.hasNext()) {
                    sb.append(", ").append(it.next());
                }
            }
        }
        return sb.append('}').toString();
    }

    protected abstract E createListElement();
}

