/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrSequenceOf;
import org.openmuc.jdlms.internal.asn1.cosem.CosemMethodDescriptor;
import org.openmuc.jdlms.internal.asn1.cosem.Data;
import org.openmuc.jdlms.internal.asn1.cosem.InvokeIdAndPriority;

public class ActionRequestWithList
implements AxdrType {
    public byte[] code = null;
    public InvokeIdAndPriority invokeIdAndPriority = null;
    public SubSeqOfCosemMethodDescriptorList cosemMethodDescriptorList = null;
    public SubSeqOfMethodInvocationParameters methodInvocationParameters = null;

    public ActionRequestWithList() {
    }

    public ActionRequestWithList(byte[] code) {
        this.code = code;
    }

    public ActionRequestWithList(InvokeIdAndPriority invokeIdAndPriority, SubSeqOfCosemMethodDescriptorList cosemMethodDescriptorList, SubSeqOfMethodInvocationParameters methodInvocationParameters) {
        this.invokeIdAndPriority = invokeIdAndPriority;
        this.cosemMethodDescriptorList = cosemMethodDescriptorList;
        this.methodInvocationParameters = methodInvocationParameters;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
        } else {
            codeLength = 0;
            codeLength += this.methodInvocationParameters.encode(axdrOStream);
            codeLength += this.cosemMethodDescriptorList.encode(axdrOStream);
            codeLength += this.invokeIdAndPriority.encode(axdrOStream);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        this.invokeIdAndPriority = new InvokeIdAndPriority();
        codeLength += this.invokeIdAndPriority.decode(iStream);
        this.cosemMethodDescriptorList = new SubSeqOfCosemMethodDescriptorList();
        codeLength += this.cosemMethodDescriptorList.decode(iStream);
        this.methodInvocationParameters = new SubSeqOfMethodInvocationParameters();
        return codeLength += this.methodInvocationParameters.decode(iStream);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public String toString() {
        return "sequence: {invokeIdAndPriority: " + this.invokeIdAndPriority + ", cosemMethodDescriptorList: " + this.cosemMethodDescriptorList + ", methodInvocationParameters: " + this.methodInvocationParameters + "}";
    }

    public static class SubSeqOfMethodInvocationParameters
    extends AxdrSequenceOf<Data> {
        @Override
        protected Data createListElement() {
            return new Data();
        }

        protected SubSeqOfMethodInvocationParameters(int length) {
            super(length);
        }

        public SubSeqOfMethodInvocationParameters() {
        }
    }

    public static class SubSeqOfCosemMethodDescriptorList
    extends AxdrSequenceOf<CosemMethodDescriptor> {
        @Override
        protected CosemMethodDescriptor createListElement() {
            return new CosemMethodDescriptor();
        }

        protected SubSeqOfCosemMethodDescriptorList(int length) {
            super(length);
        }

        public SubSeqOfCosemMethodDescriptorList() {
        }
    }
}

