/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.cosem.CosemObjectInstanceId;
import org.openmuc.jdlms.internal.asn1.cosem.Integer8;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned16;

public class CosemAttributeDescriptor
implements AxdrType {
    public byte[] code = null;
    public Unsigned16 classId = null;
    public CosemObjectInstanceId instanceId = null;
    public Integer8 attributeId = null;

    public CosemAttributeDescriptor() {
    }

    public CosemAttributeDescriptor(byte[] code) {
        this.code = code;
    }

    public CosemAttributeDescriptor(Unsigned16 classId, CosemObjectInstanceId instanceId, Integer8 attributeId) {
        this.classId = classId;
        this.instanceId = instanceId;
        this.attributeId = attributeId;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
        } else {
            codeLength = 0;
            codeLength += this.attributeId.encode(axdrOStream);
            codeLength += this.instanceId.encode(axdrOStream);
            codeLength += this.classId.encode(axdrOStream);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        this.classId = new Unsigned16();
        codeLength += this.classId.decode(iStream);
        this.instanceId = new CosemObjectInstanceId();
        codeLength += this.instanceId.decode(iStream);
        this.attributeId = new Integer8();
        return codeLength += this.attributeId.decode(iStream);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public String toString() {
        return "sequence: {classId: " + this.classId + ", instanceId: " + this.instanceId + ", attributeId: " + this.attributeId + "}";
    }
}

